/*
 * Decompiled with CFR 0.152.
 */
package marmot.core;

import marmot.core.FloatFeatureVector;
import marmot.core.FloatWeights;

public class DenseArrayFloatFeatureVector
implements FloatFeatureVector {
    private static final long serialVersionUID = 1L;
    private double[] weights_;

    public DenseArrayFloatFeatureVector(double[] weights) {
        this.weights_ = weights;
    }

    @Override
    public int getDim() {
        return this.weights_.length;
    }

    @Override
    public void updateFloatWeight(FloatWeights weights, int tag_index, int offset, double value) {
        int feature = offset;
        for (double weight : this.weights_) {
            int f_index = weights.getFloatIndex(feature, tag_index);
            weights.updateFloatWeight(f_index, weight * value);
            ++feature;
        }
    }

    @Override
    public double getDotProduct(FloatWeights weights, int tag_index, int offset) {
        double score = 0.0;
        int feature = offset;
        for (double weight : this.weights_) {
            int f_index = weights.getFloatIndex(feature, tag_index);
            score += weight * weights.getFloatWeight(f_index);
            ++feature;
        }
        return score;
    }

    public double[] getValues() {
        return this.weights_;
    }
}

