/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream;

import java.util.Stack;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.IndexedStack;
import net.sf.saxon.type.SchemaType;

public class Projector
extends ProxyReceiver {
    private final Stack<PathMap.PathMapNodeSet> pathPositionStack;
    private final IndexedStack<Boolean> isCopiedStack;
    private int level = 0;
    private int copyAllLevel = Integer.MAX_VALUE;
    private int inputNodes = 0;
    private int outputNodes = 0;
    private boolean displayStatistics = false;
    private final NamespaceBinding[] nsStack = new NamespaceBinding[20];
    private int nsStackTop = 0;
    private final int[] nsCountStack = new int[20];
    private static final PathMap.PathMapNodeSet DUMMY_PATHMAP_NODESET = new PathMap.PathMapNodeSet();

    public Projector(PathMap.PathMapRoot pathMapRoot, Receiver next) {
        super(next);
        this.pathPositionStack = new Stack();
        this.isCopiedStack = new IndexedStack();
        this.pathPositionStack.push(new PathMap.PathMapNodeSet(pathMapRoot));
    }

    @Override
    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        super.setPipelineConfiguration(pipe);
        this.displayStatistics = pipe.getConfiguration().isTiming();
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        ++this.level;
        ++this.inputNodes;
        boolean elementCopied = false;
        if (this.level > this.copyAllLevel) {
            super.startElement(elemName, type, attributes, namespaces, location, properties);
            elementCopied = true;
            this.pathPositionStack.push(DUMMY_PATHMAP_NODESET);
        } else {
            PathMap.PathMapNodeSet state = this.pathPositionStack.peek();
            PathMap.PathMapNodeSet newState = new PathMap.PathMapNodeSet();
            boolean foundMatch = false;
            for (PathMap.PathMapNode aState : state) {
                PathMap.PathMapArc[] pathMapArcs;
                for (PathMap.PathMapArc arc : pathMapArcs = aState.getArcs()) {
                    NodeTest test = arc.getNodeTest();
                    if (test.matches(1, elemName, type)) {
                        foundMatch = true;
                        PathMap.PathMapNode target = arc.getTarget();
                        newState.add(target);
                        if (target.isAtomized() || target.isReturnable()) {
                            this.copyAllLevel = this.level;
                        }
                    }
                    if (arc.getAxis() != 4) continue;
                    newState.add(aState);
                }
            }
            this.pathPositionStack.push(newState);
            if (foundMatch) {
                super.startElement(elemName, type, attributes, namespaces, location, properties);
                elementCopied = true;
            }
        }
        if (elementCopied) {
            int i;
            ++this.outputNodes;
            int pendingNamespaces = 0;
            for (i = this.level - 2; i >= 0 && !this.isCopiedStack.get(i).booleanValue(); --i) {
                pendingNamespaces += this.nsCountStack[i];
            }
            for (i = this.nsStackTop - pendingNamespaces; i < this.nsStackTop; ++i) {
                boolean duplicate = false;
                for (int j = i + 1; j < this.nsStackTop; ++j) {
                    if (!this.nsStack[j].getPrefix().equals(this.nsStack[i].getPrefix())) continue;
                    duplicate = true;
                    break;
                }
                if (duplicate) continue;
                throw new UnsupportedOperationException("to be re-implemented");
            }
        }
        this.isCopiedStack.push(elementCopied);
    }

    @Override
    public void characters(UnicodeString chars, Location locationId, int properties) throws XPathException {
        ++this.inputNodes;
        if (this.level >= this.copyAllLevel) {
            super.characters(chars, locationId, properties);
            ++this.outputNodes;
        } else {
            PathMap.PathMapNodeSet state = this.pathPositionStack.peek();
            for (PathMap.PathMapNode pathNode : state) {
                PathMap.PathMapArc[] pathMapArcs;
                for (PathMap.PathMapArc arc : pathMapArcs = pathNode.getArcs()) {
                    NodeTest test = arc.getNodeTest();
                    if (!test.matches(3, null, null)) continue;
                    super.characters(chars, locationId, properties);
                    ++this.outputNodes;
                    return;
                }
            }
        }
    }

    @Override
    public void comment(UnicodeString chars, Location locationId, int properties) throws XPathException {
        ++this.inputNodes;
        if (this.level > this.copyAllLevel) {
            super.comment(chars, locationId, properties);
            ++this.outputNodes;
        } else {
            PathMap.PathMapNodeSet state = this.pathPositionStack.peek();
            for (PathMap.PathMapNode aState : state) {
                PathMap.PathMapArc[] pathMapArcs;
                for (PathMap.PathMapArc arc : pathMapArcs = aState.getArcs()) {
                    NodeTest test = arc.getNodeTest();
                    if (!test.matches(8, null, null)) continue;
                    super.comment(chars, locationId, properties);
                    ++this.outputNodes;
                    return;
                }
            }
        }
    }

    @Override
    public void processingInstruction(String target, UnicodeString data, Location locationId, int properties) throws XPathException {
        ++this.inputNodes;
        if (this.level > this.copyAllLevel) {
            super.processingInstruction(target, data, locationId, properties);
            ++this.outputNodes;
        } else {
            PathMap.PathMapNodeSet state = this.pathPositionStack.peek();
            for (PathMap.PathMapNode aState : state) {
                PathMap.PathMapArc[] pathMapArcs;
                for (PathMap.PathMapArc arc : pathMapArcs = aState.getArcs()) {
                    NodeTest test = arc.getNodeTest();
                    if (!test.matches(7, new NoNamespaceName(target), null)) continue;
                    super.processingInstruction(target, data, locationId, properties);
                    ++this.outputNodes;
                    return;
                }
            }
        }
    }

    @Override
    public void endElement() throws XPathException {
        boolean wasCopied = this.isCopiedStack.pop();
        if (wasCopied) {
            super.endElement();
        }
        this.pathPositionStack.pop();
        --this.level;
        if (this.level < this.copyAllLevel) {
            this.copyAllLevel = Integer.MAX_VALUE;
        }
        this.nsStackTop -= this.nsCountStack[this.level];
        this.nsCountStack[this.level] = 0;
    }

    @Override
    public void endDocument() throws XPathException {
        if (this.displayStatistics) {
            this.outputStatistics(this.getConfiguration().getLogger());
        }
        super.endDocument();
    }

    public void outputStatistics(Logger out) {
        out.info("Document projection for " + this.getSystemId());
        out.info("-- Input nodes " + this.inputNodes + "; output nodes " + this.outputNodes + "; reduction = " + (100 - 100 * this.outputNodes / this.inputNodes) + "%");
    }
}

