/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.serialize;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.serialize.Emitter;
import net.sf.saxon.serialize.ExpandedStreamResult;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;

public abstract class BinaryEmitter
extends Emitter {
    protected OutputStream outputStream;
    private boolean mustClose;

    public BinaryEmitter(StreamResult streamResult, PipelineConfiguration pipe) throws XPathException {
        this.setPipelineConfiguration(pipe);
        this.outputStream = this.makeOutputStream(streamResult);
    }

    @Override
    public void open() throws XPathException {
    }

    @Override
    public void startDocument(int properties) throws XPathException {
    }

    @Override
    public void endDocument() throws XPathException {
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
    }

    @Override
    public void endElement() throws XPathException {
    }

    @Override
    public void characters(UnicodeString chars, Location locationId, int properties) throws XPathException {
        assert (this.outputStream != null);
        byte[] bytes = this.textNodeToBinary(chars.tidy());
        try {
            this.outputStream.write(bytes);
        }
        catch (IOException err) {
            throw new XPathException(err);
        }
    }

    protected abstract byte[] textNodeToBinary(UnicodeString var1) throws XPathException;

    @Override
    public void processingInstruction(String name, UnicodeString data, Location locationId, int properties) throws XPathException {
    }

    @Override
    public void comment(UnicodeString content, Location locationId, int properties) throws XPathException {
    }

    @Override
    public void close() throws XPathException {
        try {
            if (this.mustClose && this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (IOException e) {
            throw new XPathException(e);
        }
    }

    @Override
    public boolean usesTypeAnnotations() {
        return false;
    }

    protected OutputStream makeOutputStream(StreamResult streamResult) throws XPathException {
        if (streamResult.getOutputStream() != null) {
            return streamResult.getOutputStream();
        }
        String uriString = streamResult.getSystemId();
        if (uriString == null) {
            throw new XPathException("BinaryEmitter result has no system ID or output stream defined", "SXRD0004");
        }
        try {
            File file = ExpandedStreamResult.makeWritableOutputFile(uriString);
            this.outputStream = new FileOutputStream(file);
            streamResult.setOutputStream(this.outputStream);
            this.mustClose = true;
        }
        catch (FileNotFoundException | IllegalArgumentException | URISyntaxException fnf) {
            throw new XPathException("Unable to write to output destination", fnf).withErrorCode("SXRD0004");
        }
        return this.outputStream;
    }
}

