/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntIterator;

public class EscapeNCName
extends SystemFunction {
    @Override
    public StringValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        int ch;
        UnicodeString input = arguments[0].head().getUnicodeStringValue();
        if (input.isEmpty()) {
            return new StringValue("_", (AtomicType)BuiltInAtomicType.NCNAME);
        }
        UnicodeBuilder out = new UnicodeBuilder((int)input.estimatedLength());
        IntIterator iter = input.codePoints();
        if (iter.hasNext()) {
            ch = iter.next();
            if (NameChecker.isNCNameStartChar(ch)) {
                if (ch == 95) {
                    out.append('_').append('_');
                } else {
                    out.append(ch);
                }
            } else {
                this.escape(ch, out);
            }
        }
        while (iter.hasNext()) {
            ch = iter.next();
            if (NameChecker.isNCNameChar(ch)) {
                if (ch == 95) {
                    out.append('_').append('_');
                    continue;
                }
                out.append(ch);
                continue;
            }
            this.escape(ch, out);
        }
        return new StringValue(out.toUnicodeString(), (AtomicType)BuiltInAtomicType.NCNAME);
    }

    private void escape(int codepoint, UnicodeBuilder sb) {
        sb.append('_');
        sb.append(Integer.toHexString(codepoint));
        sb.append('_');
    }
}

