/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.postag;

import java.io.File;
import java.io.IOException;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.SystemInputStreamFactory;
import opennlp.tools.cmdline.postag.POSModelLoader;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSSample;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.PlainTextByLineStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class POSTaggerTool
extends BasicCmdLineTool {
    private static final Logger logger = LoggerFactory.getLogger(POSTaggerTool.class);

    @Override
    public String getShortDescription() {
        return "Learnable part of speech tagger";
    }

    @Override
    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " model < sentences";
    }

    @Override
    public void run(String[] args2) {
        if (args2.length != 1) {
            logger.info(this.getHelp());
        } else {
            POSModel model = (POSModel)new POSModelLoader().load(new File(args2[0]));
            POSTaggerME tagger = new POSTaggerME(model);
            PerformanceMonitor perfMon = null;
            try (PlainTextByLineStream lineStream = new PlainTextByLineStream((InputStreamFactory)new SystemInputStreamFactory(), SystemInputStreamFactory.encoding());){
                String line;
                perfMon = new PerformanceMonitor("sent");
                perfMon.start();
                while ((line = (String)lineStream.read()) != null) {
                    String[] whitespaceTokenizerLine = WhitespaceTokenizer.INSTANCE.tokenize(line);
                    String[] tags = tagger.tag(whitespaceTokenizerLine);
                    POSSample sample2 = new POSSample(whitespaceTokenizerLine, tags);
                    logger.info(sample2.toString());
                    perfMon.incrementCounter();
                }
            }
            catch (IOException e) {
                CmdLineUtil.handleStdinIoError(e);
            }
            perfMon.stopAndPrintFinalResult();
        }
    }
}

