/*
 * Decompiled with CFR 0.152.
 */
package marmot.test.tokenizer.opennlp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import marmot.tokenize.RuleBasedTokenizer;
import marmot.tokenize.Tokenizer;
import marmot.tokenize.openlp.OpenNlpTokenizerTrainer;
import marmot.tokenize.rules.RuleProvider;
import org.junit.Assert;
import org.junit.Test;

public class RuleBasedTokenizerTest {
    private Tokenizer tokenizer_;
    private BufferedReader examples_;

    private String getResourceFile(String name) {
        String source = "src" + File.separatorChar;
        Package pack = this.getClass().getPackage();
        String path = pack.getName().replace('.', File.separatorChar) + File.separatorChar;
        return String.format("%s%s%s", source, path, name);
    }

    public RuleBasedTokenizerTest() {
        Tokenizer tokenizer;
        OpenNlpTokenizerTrainer trainer = new OpenNlpTokenizerTrainer();
        try {
            System.out.println(this.getResourceFile(""));
            this.examples_ = new BufferedReader(new FileReader(this.getResourceFile("RBTT_examples.txt")));
            tokenizer = trainer.train("data/es/open_nlp_style.txt");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        RuleProvider provider = RuleProvider.createRuleProvider("es");
        this.tokenizer_ = new RuleBasedTokenizer(tokenizer, provider);
    }

    @Test
    public void testTokenizer() {
        try {
            String untok_1 = this.examples_.readLine();
            ArrayList<String> result_1 = new ArrayList<String>();
            for (String string : this.examples_.readLine().split(" ")) {
                result_1.add(string);
            }
            List<String> prediction_1 = this.tokenizer_.tokenize(untok_1);
            Assert.assertEquals(prediction_1, result_1);
            String untok_2 = this.examples_.readLine();
            ArrayList<String> result_2 = new ArrayList<String>();
            for (String string : this.examples_.readLine().split(" ")) {
                result_2.add(string);
            }
            List<String> list = this.tokenizer_.tokenize(untok_2);
            Assert.assertEquals(list, result_2);
            String untok_3 = this.examples_.readLine();
            ArrayList<String> result_3 = new ArrayList<String>();
            for (String string : this.examples_.readLine().split(" ")) {
                result_3.add(string);
            }
            List<String> list2 = this.tokenizer_.tokenize(untok_3);
            Assert.assertEquals(list2, result_3);
            String untok_4 = this.examples_.readLine();
            ArrayList<String> result_4 = new ArrayList<String>();
            for (String token : this.examples_.readLine().split(" ")) {
                result_4.add(token);
            }
            List<String> list3 = this.tokenizer_.tokenize(untok_4);
            Assert.assertEquals(list3, result_4);
            this.examples_.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

