/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.ids_mannheim.korap.constants.RelationDirection;
import de.ids_mannheim.korap.query.QueryBuilder;
import de.ids_mannheim.korap.query.wrap.SpanAlterQueryWrapper;
import de.ids_mannheim.korap.query.wrap.SpanAttributeQueryWrapper;
import de.ids_mannheim.korap.query.wrap.SpanClassQueryWrapper;
import de.ids_mannheim.korap.query.wrap.SpanElementQueryWrapper;
import de.ids_mannheim.korap.query.wrap.SpanFocusQueryWrapper;
import de.ids_mannheim.korap.query.wrap.SpanQueryWrapper;
import de.ids_mannheim.korap.query.wrap.SpanReferenceQueryWrapper;
import de.ids_mannheim.korap.query.wrap.SpanRegexQueryWrapper;
import de.ids_mannheim.korap.query.wrap.SpanRelationWrapper;
import de.ids_mannheim.korap.query.wrap.SpanRepetitionQueryWrapper;
import de.ids_mannheim.korap.query.wrap.SpanSegmentQueryWrapper;
import de.ids_mannheim.korap.query.wrap.SpanSequenceQueryWrapper;
import de.ids_mannheim.korap.query.wrap.SpanSimpleQueryWrapper;
import de.ids_mannheim.korap.query.wrap.SpanSubspanQueryWrapper;
import de.ids_mannheim.korap.query.wrap.SpanWithAttributeQueryWrapper;
import de.ids_mannheim.korap.query.wrap.SpanWithinQueryWrapper;
import de.ids_mannheim.korap.response.Notifications;
import de.ids_mannheim.korap.util.QueryException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KrillQuery
extends Notifications {
    private QueryBuilder builder;
    private String field;
    private JsonNode json;
    private static final Logger log = LoggerFactory.getLogger(KrillQuery.class);
    public static final boolean DEBUG = false;
    public static final byte OVERLAP = 0;
    public static final byte REAL_OVERLAP = 2;
    public static final byte WITHIN = 4;
    public static final byte REAL_WITHIN = 6;
    public static final byte ENDSWITH = 8;
    public static final byte STARTSWITH = 10;
    public static final byte MATCH = 12;
    private static final int MAX_CLASS_NUM = 255;

    public KrillQuery(String field) {
        this.field = field;
    }

    public String getField() {
        if (this.field == null) {
            return "tokens";
        }
        return this.field;
    }

    public SpanQueryWrapper fromKoral(String json) throws QueryException {
        JsonNode jsonN;
        try {
            jsonN = new ObjectMapper().readValue(json, JsonNode.class);
        }
        catch (IOException e) {
            String msg = e.getMessage();
            log.warn("Unable to parse JSON: " + msg.split("\n")[0]);
            throw new QueryException(621, "Unable to parse JSON");
        }
        if (!jsonN.has("@type") && jsonN.has("query")) {
            jsonN = jsonN.get("query");
        }
        return this.fromKoral(jsonN);
    }

    public SpanQueryWrapper fromKoral(JsonNode json) throws QueryException {
        this.json = json;
        return this._fromKoral(json);
    }

    private SpanQueryWrapper _fromKoral(JsonNode json) throws QueryException {
        return this._fromKoral(json, false);
    }

    private SpanQueryWrapper _fromKoral(JsonNode json, boolean isOperationRelation) throws QueryException {
        String type;
        int number = 0;
        if (!json.has("@type")) {
            throw new QueryException(701, "JSON-LD group has no @type attribute");
        }
        switch (type = json.get("@type").asText()) {
            case "koral:group": {
                return this._groupFromJson(json);
            }
            case "koral:reference": {
                if (json.has("operation") && !json.get("operation").asText().equals("operation:focus")) {
                    throw new QueryException(712, "Unknown reference operation");
                }
                if (!json.has("operands")) {
                    throw new QueryException(766, "Peripheral references are currently not supported");
                }
                JsonNode operands = json.get("operands");
                if (!operands.isArray()) {
                    throw new QueryException(704, "Operation needs operand list");
                }
                if (operands.size() == 0) {
                    throw new QueryException(704, "Operation needs operand list");
                }
                if (operands.size() != 1) {
                    throw new QueryException(705, "Number of operands is not acceptable");
                }
                if (json.has("classRef")) {
                    if (json.has("classRefOp")) {
                        throw new QueryException(761, "Class reference operators are currently not supported");
                    }
                    number = json.get("classRef").get(0).asInt();
                    if (number > 255) {
                        throw new QueryException(709, "Valid class numbers exceeded");
                    }
                } else if (json.has("spanRef")) {
                    JsonNode spanRef = json.get("spanRef");
                    int length = 0;
                    int startOffset = 0;
                    if (!spanRef.isArray() || spanRef.size() == 0) {
                        throw new QueryException(714, "Span references expect a start position and a length parameter");
                    }
                    if (spanRef.size() > 1) {
                        length = spanRef.get(1).asInt(0);
                    }
                    startOffset = spanRef.get(0).asInt(0);
                    SpanQueryWrapper sqw = this._fromKoral(operands.get(0));
                    SpanSubspanQueryWrapper ssqw = new SpanSubspanQueryWrapper(sqw, startOffset, length);
                    return ssqw;
                }
                return new SpanFocusQueryWrapper(this._fromKoral(operands.get(0)), number);
            }
            case "koral:token": {
                if (!json.has("wrap")) {
                    return new SpanRepetitionQueryWrapper();
                }
                if (json.has("attr")) {
                    JsonNode wrap = json.get("wrap");
                    JsonNode attrNode = json.get("attr");
                    if (wrap.has("foundry")) {
                        ((ObjectNode)attrNode).set("foundry", wrap.get("foundry"));
                    }
                    if (wrap.has("layer")) {
                        ((ObjectNode)attrNode).set("layer", wrap.get("layer"));
                    }
                    ((ObjectNode)json.get("wrap")).set("attr", attrNode);
                }
                return this._segFromJson(json.get("wrap"));
            }
            case "koral:span": {
                if (isOperationRelation && !json.has("key") && !json.has("wrap") && !json.has("attr")) {
                    return new SpanRepetitionQueryWrapper();
                }
                if (!json.has("wrap")) {
                    return this._termFromJson(json);
                }
                if (json.has("attr")) {
                    JsonNode wrap = json.get("wrap");
                    JsonNode attrNode = json.get("attr");
                    if (wrap.has("foundry")) {
                        ((ObjectNode)attrNode).set("foundry", wrap.get("foundry"));
                    }
                    if (wrap.has("layer")) {
                        ((ObjectNode)attrNode).set("layer", wrap.get("layer"));
                    }
                    ((ObjectNode)json.get("wrap")).set("attr", attrNode);
                }
                return this._termFromJson(json.get("wrap"), true);
            }
        }
        throw new QueryException(713, "Query type is not supported");
    }

    public QueryBuilder builder() {
        if (this.builder == null) {
            this.builder = new QueryBuilder(this.field);
        }
        return this.builder;
    }

    @Override
    public JsonNode toJsonNode() {
        return this.json;
    }

    @Override
    public String toJsonString() {
        if (this.json == null) {
            return "{}";
        }
        return this.json.toString();
    }

    private SpanQueryWrapper _groupFromJson(JsonNode json) throws QueryException {
        if (!json.has("operation")) {
            throw new QueryException(703, "Group expects operation");
        }
        String operation = json.get("operation").asText();
        if (!json.has("operands")) {
            throw new QueryException(704, "Operation needs operand list");
        }
        JsonNode operands = json.get("operands");
        if (operands == null || !operands.isArray()) {
            throw new QueryException(704, "Operation needs operand list");
        }
        SpanQueryWrapper spanReferenceQueryWrapper = this._operationReferenceFromJSON(json, operands);
        if (spanReferenceQueryWrapper != null) {
            return spanReferenceQueryWrapper;
        }
        switch (operation) {
            case "operation:junction": {
                return this._operationJunctionFromJson(operands);
            }
            case "operation:position": {
                return this._operationPositionFromJson(json, operands);
            }
            case "operation:sequence": {
                return this._operationSequenceFromJson(json, operands);
            }
            case "operation:class": {
                return this._operationClassFromJson(json, operands);
            }
            case "operation:repetition": {
                return this._operationRepetitionFromJson(json, operands);
            }
            case "operation:relation": {
                if (json.has("relType")) {
                    return this._operationRelationFromJson(operands, json.get("relType"));
                }
                if (json.has("relation")) {
                    return this._operationRelationFromJson(operands, json.get("relation"));
                }
                throw new QueryException(717, "Missing relation node");
            }
            case "operation:merge": {
                this.addWarning(774, "Merge operation is currently not supported", new String[0]);
                return this._fromKoral(operands.get(0));
            }
            case "operation:or": {
                return this._operationJunctionFromJson(operands);
            }
            case "operation:disjunction": {
                return this._operationJunctionFromJson(operands);
            }
        }
        throw new QueryException(711, "Unknown group operation");
    }

    private SpanQueryWrapper _operationReferenceFromJSON(JsonNode node, JsonNode operands) throws QueryException {
        boolean isReference = false;
        int classNum = -1;
        int refOperandNum = -1;
        for (int i = 0; i < operands.size(); ++i) {
            JsonNode childNode = operands.get(i);
            if (!childNode.has("@type") || !childNode.get("@type").asText().equals("koral:reference") || !childNode.has("operation") || !childNode.get("operation").asText().equals("operation:focus") || childNode.has("operands") || !childNode.has("classRef")) continue;
            classNum = childNode.get("classRef").get(0).asInt();
            refOperandNum = i;
            isReference = true;
            break;
        }
        if (isReference) {
            JsonNode resolvedNode = this._resolveReference(node, operands, refOperandNum, classNum);
            SpanQueryWrapper queryWrapper = this._fromKoral(resolvedNode);
            return new SpanReferenceQueryWrapper(queryWrapper, classNum);
        }
        return null;
    }

    private JsonNode _resolveReference(JsonNode node, JsonNode operands, int refOperandNum, int classNum) throws QueryException {
        JsonNode referent = null;
        ObjectMapper m = new ObjectMapper();
        ArrayNode newOperands = m.createArrayNode();
        boolean isReferentFound = false;
        for (int i = 0; i < operands.size(); ++i) {
            if (i == refOperandNum) continue;
            if (!isReferentFound && (referent = this._extractReferentClass(operands.get(i), classNum)) != null) {
                isReferentFound = true;
            }
            newOperands.insert(i, operands.get(i));
        }
        if (isReferentFound) {
            newOperands.insert(refOperandNum, referent);
            ((ObjectNode)node).set("operands", newOperands);
            return node;
        }
        throw new QueryException("Referent node is not found");
    }

    private JsonNode _extractReferentClass(JsonNode node, int classNum) {
        if (node.has("classOut") && node.get("classOut").asInt() == classNum) {
            return node;
        }
        if (node.has("operands") && node.get("operands").isArray()) {
            for (JsonNode childOperand : node.get("operands")) {
                JsonNode referent = this._extractReferentClass(childOperand, classNum);
                if (referent == null) continue;
                return referent;
            }
        }
        return null;
    }

    private SpanQueryWrapper _operationRelationFromJson(JsonNode operands, JsonNode relation) throws QueryException {
        if (operands.size() < 2) {
            throw new QueryException(705, "Number of operands is not acceptable");
        }
        SpanQueryWrapper operand1 = this._fromKoral(operands.get(0), true);
        SpanQueryWrapper operand2 = this._fromKoral(operands.get(1), true);
        RelationDirection direction = operand1.isEmpty() && !operand2.isEmpty() ? RelationDirection.LEFT : RelationDirection.RIGHT;
        if (!relation.has("@type")) {
            throw new QueryException(701, "JSON-LD group has no @type attribute");
        }
        if (relation.get("@type").asText().equals("koral:relation")) {
            if (!relation.has("wrap")) {
                throw new QueryException(718, "Missing relation term.");
            }
            SpanQueryWrapper relationTermWrapper = this._termFromJson(relation.get("wrap"), false, false, direction);
            SpanRelationWrapper spanRelationWrapper = new SpanRelationWrapper(relationTermWrapper, operand1, operand2);
            spanRelationWrapper.setDirection(direction);
            return spanRelationWrapper;
        }
        throw new QueryException(713, "Query type is not supported");
    }

    private SpanQueryWrapper _operationJunctionFromJson(JsonNode operands) throws QueryException {
        SpanAlterQueryWrapper ssaq = new SpanAlterQueryWrapper(this.field);
        for (JsonNode operand : operands) {
            ssaq.or(this._fromKoral(operand));
        }
        return ssaq;
    }

    private SpanQueryWrapper _operationPositionFromJson(JsonNode json, JsonNode operands) throws QueryException {
        if (operands.size() != 2) {
            throw new QueryException(705, "Number of operands is not acceptable");
        }
        String frame = "contains";
        if (json.has("frames")) {
            frameN = json.get("frames");
            if (frameN.isArray()) {
                int fs = 0;
                block38: for (JsonNode frameS : frameN) {
                    switch (frameS.asText()) {
                        case "frames:matches": {
                            ++fs;
                            continue block38;
                        }
                        case "frames:startsWith": {
                            ++fs;
                            continue block38;
                        }
                        case "frames:isAround": {
                            ++fs;
                            continue block38;
                        }
                        case "frames:endsWith": {
                            ++fs;
                            continue block38;
                        }
                    }
                    fs += 7;
                }
                if (fs == 4) {
                    frame = "contains";
                } else {
                    if (frameN.size() > 1) {
                        this.addMessage(0, "Frames not fully supported yet", new String[0]);
                    }
                    if ((frameN = frameN.get(0)) != null && frameN.isValueNode()) {
                        frame = frameN.asText().substring(7);
                    }
                }
            }
        } else if (json.has("frame")) {
            this.addMessage(0, "Frame is deprecated", new String[0]);
            frameN = json.get("frame");
            if (frameN != null && frameN.isValueNode()) {
                frame = frameN.asText().substring(6);
            }
        }
        byte flag = 4;
        switch (frame) {
            case "contains": {
                JsonNode operand = operands.get(0);
                if (!operand.get("@type").asText().equals("koral:token")) break;
                throw new QueryException(719, "Token cannot contain another token or element.");
            }
            case "isAround": {
                JsonNode operand = operands.get(0);
                if (operand.get("@type").asText().equals("koral:token")) {
                    throw new QueryException(719, "Token cannot contain another token or element.");
                }
                this.addMessage(0, "'isAround' will have a different meaning in the future and is therefore temporarily deprecated in favor of 'contains'", new String[0]);
                break;
            }
            case "strictlyContains": {
                flag = 6;
                break;
            }
            case "isWithin": {
                break;
            }
            case "startsWith": {
                flag = 10;
                break;
            }
            case "endsWith": {
                flag = 8;
                break;
            }
            case "matches": {
                flag = 12;
                break;
            }
            case "overlaps": {
                flag = 0;
                this.addWarning(769, "Overlap variant currently interpreted as overlap", new String[0]);
                break;
            }
            case "overlapsLeft": {
                this.addWarning(769, "Overlap variant currently interpreted as overlap", new String[0]);
                flag = 0;
                break;
            }
            case "overlapsRight": {
                this.addWarning(769, "Overlap variant currently interpreted as overlap", new String[0]);
                flag = 0;
                break;
            }
            case "strictlyOverlaps": {
                flag = 2;
                break;
            }
            default: {
                throw new QueryException(706, "Frame type is unknown");
            }
        }
        if (json.has("exclude") && json.get("exclude").asBoolean()) {
            throw new QueryException(760, "Exclusion is currently not supported in position operations");
        }
        return new SpanWithinQueryWrapper(this._fromKoral(operands.get(0)), this._fromKoral(operands.get(1)), flag);
    }

    private SpanQueryWrapper _operationRepetitionFromJson(JsonNode json, JsonNode operands) throws QueryException {
        SpanQueryWrapper sqw;
        if (operands.size() != 1) {
            throw new QueryException(705, "Number of operands is not acceptable");
        }
        int min = 0;
        int max = 100;
        if (json.has("boundary")) {
            Boundary b = new Boundary(json.get("boundary"), 0, 100);
            min = b.min;
            max = b.max;
        } else {
            this.addMessage(0, "Setting boundary by min and max is deprecated", new String[0]);
            if (json.has("min")) {
                min = json.get("min").asInt(0);
            }
            if (json.has("max")) {
                max = json.get("max").asInt(100);
            }
        }
        if (max < 0) {
            max = 100;
        } else if (max > 100) {
            max = 100;
        }
        if (min < 0) {
            min = 0;
        } else if (min > 100) {
            min = 100;
        }
        if (min > max) {
            // empty if block
        }
        if ((sqw = this._fromKoral(operands.get(0))).maybeExtension()) {
            return sqw.setMin(min).setMax(max);
        }
        return new SpanRepetitionQueryWrapper(sqw, min, max);
    }

    @Deprecated
    private SpanQueryWrapper _operationSubmatchFromJson(JsonNode json, JsonNode operands) throws QueryException {
        int number = 1;
        this.addMessage(0, "operation:submatch is deprecated", new String[0]);
        if (operands.size() != 1) {
            throw new QueryException(705, "Number of operands is not acceptable");
        }
        if (json.has("classRef")) {
            if (json.has("classRefOp")) {
                throw new QueryException(761, "Class reference operators are currently not supported");
            }
            number = json.get("classRef").get(0).asInt();
        } else if (json.has("spanRef")) {
            throw new QueryException(762, "Span references are currently not supported");
        }
        return new SpanFocusQueryWrapper(this._fromKoral(operands.get(0)), number);
    }

    private SpanQueryWrapper _operationClassFromJson(JsonNode json, JsonNode operands) throws QueryException {
        int number = 1;
        if (operands.size() != 1) {
            throw new QueryException(705, "Number of operands is not acceptable");
        }
        if (json.has("classOut")) {
            number = json.get("classOut").asInt(0);
        } else if (json.has("class")) {
            this.addMessage(0, "Class is deprecated", new String[0]);
            number = json.get("class").asInt(0);
        }
        if (json.has("classRefCheck")) {
            this.addWarning(764, "Class reference checks are currently not supported - results may not be correct", new String[0]);
        }
        if (json.has("classRefOp")) {
            throw new QueryException(761, "Class reference operators are currently not supported");
        }
        if (number > 0) {
            if (operands.size() != 1) {
                throw new QueryException(705, "Number of operands is not acceptable");
            }
            if (number > 255) {
                throw new QueryException(709, "Valid class numbers exceeded");
            }
            SpanQueryWrapper sqw = this._fromKoral(operands.get(0));
            if (sqw.maybeExtension()) {
                return sqw.setClassNumber(number);
            }
            return new SpanClassQueryWrapper(sqw, number);
        }
        throw new QueryException(710, "Class attribute missing");
    }

    private SpanQueryWrapper _operationSequenceFromJson(JsonNode json, JsonNode operands) throws QueryException {
        if (operands.size() == 1) {
            return this._fromKoral(operands.get(0));
        }
        SpanSequenceQueryWrapper sseqqw = this.builder().seq();
        if (json.has("inOrder")) {
            sseqqw.setInOrder(json.get("inOrder").asBoolean());
        }
        if (json.has("distances")) {
            JsonNode distances;
            if (json.has("exclude") && json.get("exclude").asBoolean()) {
                throw new QueryException(763, "Excluding distance constraints are currently not supported");
            }
            if (!json.get("distances").isArray()) {
                throw new QueryException(707, "Distance Constraints have to be defined as arrays");
            }
            JsonNode firstDistance = json.get("distances").get(0);
            if (!firstDistance.has("@type")) {
                throw new QueryException(701, "JSON-LD group has no @type attribute");
            }
            if (firstDistance.get("@type").asText().equals("koral:group")) {
                if (!firstDistance.has("operands") || !firstDistance.get("operands").isArray()) {
                    throw new QueryException(704, "Operation needs operand list");
                }
                distances = firstDistance.get("operands");
            } else if (firstDistance.get("@type").asText().equals("koral:distance") || firstDistance.get("@type").asText().equals("cosmas:distance")) {
                distances = json.get("distances");
            } else {
                throw new QueryException(708, "No valid distances defined");
            }
            for (JsonNode constraint : distances) {
                String unit = "w";
                if (constraint.has("key")) {
                    unit = constraint.get("key").asText();
                }
                int min = 0;
                int max = 100;
                if (constraint.has("boundary")) {
                    Boundary b = new Boundary(constraint.get("boundary"), 0, 100);
                    min = b.min;
                    max = b.max;
                } else {
                    if (constraint.has("min")) {
                        min = constraint.get("min").asInt(0);
                    }
                    if (constraint.has("max")) {
                        max = constraint.get("max").asInt(100);
                    }
                }
                if (constraint.has("foundry") && constraint.has("layer") && constraint.get("foundry").asText().length() > 0 && constraint.get("layer").asText().length() > 0) {
                    value = new StringBuilder();
                    value.append(constraint.get("foundry").asText());
                    value.append('/');
                    value.append(constraint.get("layer").asText());
                    value.append(':').append(unit);
                    unit = value.toString();
                } else if (unit.equals("s") || unit.equals("p") || unit.equals("t")) {
                    value = new StringBuilder();
                    unit = value.append("base/s:").append(unit).toString();
                }
                if (constraint.get("@type").asText().equals("koral:distance")) {
                    ++min;
                    ++max;
                }
                Boolean exclusion = false;
                if (constraint.has("exclude")) {
                    exclusion = constraint.get("exclude").asBoolean();
                }
                if (max < min) {
                    max = min;
                }
                sseqqw.withConstraint(min, max, unit, (boolean)exclusion);
            }
        }
        for (JsonNode operand : operands) {
            sseqqw.append(this._fromKoral(operand));
        }
        if (!sseqqw.isInOrder() && !sseqqw.hasConstraints()) {
            sseqqw.withConstraint(1, 1, "w");
        }
        return sseqqw;
    }

    private SpanQueryWrapper _segFromJson(JsonNode json) throws QueryException {
        String type;
        if (!json.has("@type")) {
            throw new QueryException(701, "JSON-LD group has no @type attribute");
        }
        switch (type = json.get("@type").asText()) {
            case "koral:term": {
                return this._termFromJson(json);
            }
            case "koral:termGroup": {
                if (!json.has("operands")) {
                    throw new QueryException(742, "Term group needs operand list");
                }
                JsonNode operands = json.get("operands");
                SpanSegmentQueryWrapper ssegqw = this.builder().seg();
                if (!json.has("relation")) {
                    throw new QueryException(743, "Term group expects a relation");
                }
                switch (json.get("relation").asText()) {
                    case "relation:and": {
                        for (JsonNode operand : operands) {
                            SpanQueryWrapper part = this._segFromJson(operand);
                            if (part instanceof SpanAlterQueryWrapper) {
                                ssegqw.with((SpanAlterQueryWrapper)part);
                                continue;
                            }
                            if (part instanceof SpanRegexQueryWrapper) {
                                ssegqw.with((SpanRegexQueryWrapper)part);
                                continue;
                            }
                            if (part instanceof SpanSegmentQueryWrapper) {
                                ssegqw.with((SpanSegmentQueryWrapper)part);
                                continue;
                            }
                            throw new QueryException(744, "Operand not supported in term group");
                        }
                        return ssegqw;
                    }
                    case "relation:or": {
                        SpanAlterQueryWrapper ssaq = new SpanAlterQueryWrapper(this.field);
                        for (JsonNode operand : operands) {
                            ssaq.or(this._segFromJson(operand));
                        }
                        return ssaq;
                    }
                }
            }
        }
        throw new QueryException(745, "Token type is not supported");
    }

    private SpanQueryWrapper _termFromJson(JsonNode json) throws QueryException {
        return this._termFromJson(json, false, false, null);
    }

    private SpanQueryWrapper _termFromJson(JsonNode json, boolean isSpan) throws QueryException {
        return this._termFromJson(json, isSpan, false, null);
    }

    private SpanQueryWrapper _termFromJson(JsonNode json, boolean isSpan, boolean isAttr) throws QueryException {
        return this._termFromJson(json, isSpan, true, null);
    }

    private SpanQueryWrapper _termFromJson(JsonNode json, boolean isSpan, boolean isAttr, RelationDirection direction) throws QueryException {
        if (!json.has("@type")) {
            throw new QueryException(701, "JSON-LD group has no @type attribute");
        }
        String termType = json.get("@type").asText();
        Boolean isTerm = termType.equals("koral:term");
        Boolean isCaseInsensitive = false;
        if ((!json.has("key") || json.get("key").size() == 1 && json.get("key").asText().length() < 1) && !json.has("attr")) {
            throw new QueryException(740, "Key definition is missing in term or span");
        }
        LinkedList<String> keys = new LinkedList<String>();
        if (json.has("key")) {
            if (json.get("key").size() > 1) {
                for (JsonNode value : json.get("key")) {
                    keys.push(value.asText());
                }
            } else {
                keys.push(json.get("key").asText());
            }
        }
        if (isSpan) {
            isTerm = false;
        }
        if (json.has("caseInsensitive") && json.get("caseInsensitive").asBoolean()) {
            isCaseInsensitive = true;
        } else if (json.has("flags") && json.get("flags").isArray()) {
            Iterator<JsonNode> flags = json.get("flags").elements();
            while (flags.hasNext()) {
                String flag = flags.next().asText();
                if (flag.equals("flags:caseInsensitive")) {
                    isCaseInsensitive = true;
                    continue;
                }
                this.addWarning(748, "Flag is unknown", flag);
            }
        }
        StringBuilder value = new StringBuilder();
        LinkedList<String> values = new LinkedList<String>();
        if (direction != null) {
            value.append(direction.value());
        } else if (isAttr) {
            value.append("@:");
        }
        if (json.has("foundry") && json.get("foundry").asText().length() > 0) {
            value.append(json.get("foundry").asText()).append('/');
        }
        if (json.has("layer") && json.get("layer").asText().length() > 0) {
            String layer = json.get("layer").asText();
            switch (layer) {
                case "lemma": {
                    layer = "l";
                    break;
                }
                case "pos": {
                    layer = "p";
                    break;
                }
                case "orth": {
                    layer = ".";
                    break;
                }
                case "struct": {
                    layer = "s";
                    break;
                }
                case "const": {
                    layer = "c";
                }
            }
            if (isCaseInsensitive.booleanValue() && isTerm.booleanValue()) {
                if (layer.equals(".")) {
                    layer = "i";
                } else {
                    this.addWarning(767, "Case insensitivity is currently not supported for this layer", new String[0]);
                }
            }
            if (layer.equals(".")) {
                layer = "s";
                value.setLength(0);
            } else if (layer.equals("i")) {
                value.setLength(0);
            }
            value.append(layer).append(':');
        }
        int offset = value.length();
        for (String key : keys) {
            value.setLength(offset);
            if (isCaseInsensitive.booleanValue()) {
                if (key.toLowerCase().equals(key.toUpperCase().toLowerCase())) {
                    value.append(key.toLowerCase());
                } else {
                    value.append(key.toLowerCase());
                    values.push(value.toString());
                    value.setLength(offset);
                    value.append(key.toUpperCase().toLowerCase());
                }
            } else {
                value.append(key);
            }
            if (json.has("value") && json.get("value").asText().length() > 0) {
                value.append(':').append(json.get("value").asText());
            }
            values.push(value.toString());
        }
        if (isTerm.booleanValue()) {
            SpanAlterQueryWrapper saqw = new SpanAlterQueryWrapper(this.field);
            String match = "match:eq";
            if (json.has("match")) {
                match = json.get("match").asText();
            }
            if (json.has("type")) {
                QueryBuilder qb = this.builder();
                switch (json.get("type").asText()) {
                    case "type:regex": {
                        for (String v : values) {
                            if (v.matches("^[si]:\\.[\\+\\*]\\??$")) {
                                return new SpanRepetitionQueryWrapper();
                            }
                            SpanRegexQueryWrapper srqw = qb.re(v, isCaseInsensitive);
                            if (srqw.error != null) {
                                throw new QueryException(719, "Invalid regex");
                            }
                            saqw.or(srqw);
                        }
                        if (match.equals("match:ne")) {
                            saqw.setNegative(true);
                            return saqw;
                        }
                        if (match.equals("match:eq")) {
                            return saqw;
                        }
                        throw new QueryException(741, "Match relation unknown");
                    }
                    case "type:wildcard": {
                        for (String v : values) {
                            saqw.or(qb.wc(v, isCaseInsensitive));
                        }
                        if (match.equals("match:ne")) {
                            saqw.setNegative(true);
                            return saqw;
                        }
                        if (match.equals("match:eq")) {
                            return saqw;
                        }
                        throw new QueryException(741, "Match relation unknown");
                    }
                    case "type:string": {
                        break;
                    }
                    default: {
                        this.addWarning(746, "Term type is not supported - treated as a string", new String[0]);
                    }
                }
            }
            for (String v : values) {
                saqw.or(v);
            }
            if (match.equals("match:ne")) {
                saqw.setNegative(true);
                return saqw;
            }
            if (match.equals("match:eq")) {
                return saqw;
            }
            throw new QueryException(741, "Match relation unknown");
        }
        if (values.size() > 1) {
            throw new QueryException(0, "List representation for spans not yet supported");
        }
        if (json.has("attr")) {
            JsonNode attrNode = json.get("attr");
            if (!attrNode.has("@type")) {
                throw new QueryException(701, "JSON-LD group has no @type attribute");
            }
            if (value.toString().isEmpty()) {
                return this._createElementAttrFromJson(null, json, attrNode);
            }
            SpanElementQueryWrapper elementWithIdWrapper = this.builder().tag(value.toString());
            if (elementWithIdWrapper == null) {
                return null;
            }
            return this._createElementAttrFromJson(elementWithIdWrapper, json, attrNode);
        }
        return this.builder().tag(value.toString());
    }

    private SpanQueryWrapper _createElementAttrFromJson(SpanQueryWrapper elementWithIdWrapper, JsonNode json, JsonNode attrNode) throws QueryException {
        if (attrNode.get("@type").asText().equals("koral:term")) {
            SpanQueryWrapper attrWrapper = this._attrFromJson(json.get("attr"));
            if (attrWrapper != null) {
                if (elementWithIdWrapper != null) {
                    return new SpanWithAttributeQueryWrapper(elementWithIdWrapper, attrWrapper);
                }
                return new SpanWithAttributeQueryWrapper(attrWrapper);
            }
            throw new QueryException(747, "Attribute is null");
        }
        if (attrNode.get("@type").asText().equals("koral:termGroup")) {
            return this._handleAttrGroup(elementWithIdWrapper, attrNode);
        }
        this.addWarning(715, "Attribute type is not supported", new String[0]);
        return elementWithIdWrapper;
    }

    private SpanQueryWrapper _handleAttrGroup(SpanQueryWrapper elementWithIdWrapper, JsonNode attrNode) throws QueryException {
        if (!attrNode.has("relation")) {
            throw new QueryException(743, "Term group expects a relation");
        }
        if (!attrNode.has("operands")) {
            throw new QueryException(742, "Term group needs operand list");
        }
        String relation = attrNode.get("relation").asText();
        JsonNode operands = attrNode.get("operands");
        if ("relation:and".equals(relation)) {
            ArrayList<SpanQueryWrapper> wrapperList = new ArrayList<SpanQueryWrapper>();
            for (JsonNode operand : operands) {
                SpanQueryWrapper attrWrapper = this._termFromJson(operand, false, true);
                if (attrWrapper == null) {
                    throw new QueryException(747, "Attribute is null");
                }
                wrapperList.add(attrWrapper);
            }
            if (elementWithIdWrapper != null) {
                return new SpanWithAttributeQueryWrapper(elementWithIdWrapper, wrapperList);
            }
            return new SpanWithAttributeQueryWrapper(wrapperList);
        }
        if ("relation:or".equals(relation)) {
            SpanAlterQueryWrapper saq = new SpanAlterQueryWrapper(this.field);
            for (JsonNode operand : operands) {
                SpanQueryWrapper attrWrapper = this._termFromJson(operand, false, true);
                if (attrWrapper == null) {
                    throw new QueryException(747, "Attribute is null");
                }
                SpanWithAttributeQueryWrapper saqw = elementWithIdWrapper != null ? new SpanWithAttributeQueryWrapper(elementWithIdWrapper, attrWrapper) : new SpanWithAttributeQueryWrapper(attrWrapper);
                saq.or(saqw);
            }
            return saq;
        }
        throw new QueryException(716, "Unknown relation");
    }

    private SpanQueryWrapper _attrFromJson(JsonNode attrNode) throws QueryException {
        String rootValue;
        if (attrNode.has("key")) {
            return this._termFromJson(attrNode, false, true);
        }
        if (attrNode.has("tokenarity") || attrNode.has("arity")) {
            this.addWarning(770, "Arity attributes are currently not supported - results may not be correct", new String[0]);
        } else if (attrNode.has("root") && ((rootValue = attrNode.get("root").asText()).equals("true") || rootValue.equals("false"))) {
            return new SpanAttributeQueryWrapper(new SpanSimpleQueryWrapper(this.field, "@root", Boolean.valueOf(rootValue)));
        }
        return null;
    }

    private class Boundary {
        public int min;
        public int max;

        public Boundary(JsonNode json, int defaultMin, int defaultMax) throws QueryException {
            if (!json.has("@type")) {
                throw new QueryException(701, "JSON-LD group has no @type attribute");
            }
            if (!json.get("@type").asText().equals("koral:boundary")) {
                throw new QueryException(702, "Boundary definition is invalid");
            }
            this.min = json.has("min") ? json.get("min").asInt(defaultMin) : defaultMin;
            this.max = json.has("max") ? json.get("max").asInt(defaultMax) : defaultMax;
        }
    }
}

