/*
 * Decompiled with CFR 0.152.
 */
package marmot.test.tokenizer.rules;

import marmot.tokenize.rules.RuleProvider;
import marmot.tokenize.rules.RulebasedTransformator;
import org.junit.Assert;
import org.junit.Test;

public class RulebasedTransformatorTest {
    public void testTokRules(String lang, String input, String expected) {
        RuleProvider p = RuleProvider.createRuleProvider(lang);
        RulebasedTransformator r = p.getTokTransformator();
        this.test(r, input, expected);
    }

    public void testUnTokRules(String lang, String input, String expected) {
        RuleProvider p = RuleProvider.createRuleProvider(lang);
        RulebasedTransformator r = p.getUnTokTransformator();
        this.test(r, input, expected);
    }

    private void test(RulebasedTransformator r, String input, String expected) {
        String actual = r.applyRules(input);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSpanishTokRules() {
        this.testUnTokRules("es", "no match.", "no match.");
        this.testUnTokRules("es", " del. ", " de el. ");
        this.testUnTokRules("es", " adela del ", " adela de el ");
        this.testUnTokRules("es", " \u00e1dela del ", " \u00e1dela de el ");
        this.testUnTokRules("es", " \u00f6dela del ", " \u00f6dela de el ");
        this.testUnTokRules("es", " \u00f1dela del ", " \u00f1dela de el ");
        this.testUnTokRules("es", "P\u00e1del", "P\u00e1del");
        this.testUnTokRules("es", " del ", " de el ");
        this.testUnTokRules("es", "del", "de el");
        this.testUnTokRules("es", " del", " de el");
        this.testUnTokRules("es", "del ", "de el ");
        this.testUnTokRules("es", "(del)", "(de el)");
    }

    @Test
    public void testSpanishUnTokRules() {
        this.testTokRules("es", "dejando_de_lado", "dejando de lado");
        this.testTokRules("es", "Jos\u00e9_Ramon", "Jos\u00e9 Ramon");
        this.testTokRules("es", "3_mayo", "3 mayo");
        this.testTokRules("es", "van_a_conocer ", "van a conocer ");
        this.testTokRules("es", " 1.0 Fz ", " 1.0 ");
        this.testTokRules("es", " 1.0 FZ ", " 1.0 FZ ");
        this.testTokRules("es", " 1.0 Fz", " 1.0");
    }

    @Test
    public void testCzechTokRules() {
        this.testTokRules("cs", "Starov\u011bk\u00fd Bejt \u0160e &apos; arim", "Starov\u011bk\u00fd Bejt \u0160e ' arim");
        this.testTokRules("cs", "&quot; Elysium &quot;", "\" Elysium \"");
    }
}

