/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.extfn.js;

import com.saxonica.ee.extfn.js.IXSL3FunctionSet;
import com.saxonica.ee.extfn.js.IXSLFunctionSet;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class IXSLSetProperty
extends StyleElement {
    private Expression name;
    private Expression select;
    private Expression object;
    private Expression convert;
    private boolean convertAttSupplied = false;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    protected boolean mayContainSequenceConstructor() {
        return false;
    }

    @Override
    protected void prepareAttributes() {
        block14: for (AttributeInfo att : this.attributes()) {
            NodeName attName = att.getNodeName();
            String f = attName.getDisplayName();
            String value = att.getValue();
            switch (f) {
                case "name": {
                    String nameAtt = Whitespace.trim(value);
                    this.name = this.makeAttributeValueTemplate(nameAtt, att);
                    continue block14;
                }
                case "select": {
                    String selectAtt = value;
                    this.select = this.makeExpression(selectAtt, att);
                    continue block14;
                }
                case "object": {
                    String objectAtt = value;
                    this.object = this.makeExpression(objectAtt, att);
                    continue block14;
                }
                case "convert-value": {
                    boolean convertVal = this.processBooleanAttribute("convert-value", value);
                    this.convert = convertVal ? this.makeExpression("true()", att) : this.makeExpression("false()", att);
                    this.convertAttSupplied = true;
                    continue block14;
                }
            }
            this.checkUnknownAttribute(attName);
        }
        if (this.object == null) {
            try {
                this.object = IXSLFunctionSet.getInstance().makeFunction("window", 0).makeFunctionCall(new Expression[0]);
            }
            catch (XPathException e) {
                this.compileError(e);
            }
        }
        if (this.name == null) {
            this.reportAbsence("name");
        }
        if (this.select == null) {
            this.reportAbsence("select");
        }
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        this.checkEmpty();
        this.name = this.typeCheck("name", this.name);
        this.select = this.typeCheck("select", this.select);
        this.object = this.typeCheck("object", this.object);
        this.convert = this.typeCheck("convert-value", this.convert);
    }

    @Override
    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        if (this.convertAttSupplied) {
            if (!"JS3".equals(exec.getCompilerInfo().getTargetEdition())) {
                this.compileError("ixsl:set-property/@convert-value is available only if the target edition is JS3");
            } else {
                Expression e4 = IXSL3FunctionSet.getInstance().makeFunction("set-property", 4).makeFunctionCall(this.name, this.select, this.object, this.convert);
                e4.setRetainedStaticContext(this.makeRetainedStaticContext());
                return e4;
            }
        }
        Expression e3 = IXSLFunctionSet.getInstance().makeFunction("set-property", 3).makeFunctionCall(this.name, this.select, this.object);
        e3.setRetainedStaticContext(this.makeRetainedStaticContext());
        return e3;
    }
}

