/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import com.saxonica.ee.schema.ElementDecl;
import com.saxonica.ee.validate.LaxValidator;
import com.saxonica.ee.validate.SkipValidator;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;

public class AnyTypeValidator
extends LaxValidator {
    UnicodeString fixedValue = null;
    UnicodeString defaultValue = null;
    boolean foundChildren = false;
    UnicodeBuilder buffer;

    public AnyTypeValidator(Receiver next) {
        super(next);
    }

    public AnyTypeValidator(ElementDecl elementDecl, Receiver next) {
        super(next);
        if (elementDecl != null) {
            AtomicSequence fixed = elementDecl.getFixedValue();
            if (fixed != null) {
                this.fixedValue = ((AtomicValue)fixed).getUnicodeStringValue();
            }
            this.defaultValue = elementDecl.getDefaultValueLexicalForm();
        }
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        if (this.locallyInvalid) {
            this.childValidator = new SkipValidator(this.nextReceiver);
            this.nextReceiver.startElement(elemName, AnyType.getInstance(), attributes, namespaces, location, properties);
            return;
        }
        if (this.fixedValue != null) {
            String message = "Element " + Err.wrap(elemName.getDisplayName(), 1) + " cannot appear here, because the containing " + this.getContainingElementName() + " element has fixed content";
            ValidationFailure ve = new ValidationFailure(message);
            ve.setConstraintReference(1, "cvc-elt", "5.2.2.1");
            ve.setSchemaType(this.getSchemaType());
            this.reportValidationError(ve, true, location);
        }
        this.foundChildren = true;
        super.startElement(elemName, type, attributes, namespaces, location, properties);
    }

    @Override
    public void characters(UnicodeString chars, Location locationId, int properties) throws XPathException {
        if (this.fixedValue != null || this.defaultValue != null) {
            if (this.buffer == null) {
                this.buffer = new UnicodeBuilder();
            }
            this.buffer.accept(chars);
        }
        super.characters(chars, locationId, properties);
    }

    @Override
    public void endElement() throws XPathException {
        if (this.fixedValue != null) {
            if (this.buffer == null || this.buffer.isEmpty()) {
                this.characters(this.fixedValue, Loc.NONE, 0);
            } else if (!this.buffer.toUnicodeString().equals(this.fixedValue)) {
                String message = "The content of " + this.getContainingElementName() + " differs from the fixed value defined in the schema. Fixed value is " + Err.wrap(this.fixedValue, 4) + ", actual value is " + Err.wrap(this.buffer.toString(), 4);
                ValidationFailure ve = new ValidationFailure(message);
                ve.setConstraintReference(1, "cvc-elt", "5.2.2.2");
                ve.setSchemaType(this.getSchemaType());
                this.reportValidationError(ve, true, this.getContainingElementLocationId());
            }
        }
        if (this.defaultValue != null && !this.foundChildren && (this.buffer == null || this.buffer.isEmpty())) {
            this.characters(this.defaultValue, Loc.NONE, 0);
        }
        super.endElement();
    }
}

