/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import com.saxonica.ee.validate.AssertionTreeBuilder;
import com.saxonica.ee.validate.AttributeInheritor;
import com.saxonica.ee.validate.ConstraintChecker;
import com.saxonica.ee.validate.ValidationContext;
import net.sf.saxon.event.PathMaintainer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.number.Numberer_en;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.lib.InvalidityHandler;
import net.sf.saxon.lib.InvalidityHandlerWrappingErrorReporter;
import net.sf.saxon.om.AbsolutePath;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.StringView;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.AttributeLocation;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;

public class ValidatingFilter
extends ProxyReceiver {
    private ValidationContext validationContext;
    boolean locallyInvalid = false;

    ValidatingFilter(Receiver next) {
        super(next);
    }

    public ValidationContext getValidationContext() {
        return this.validationContext;
    }

    public void setValidationContext(ValidationContext validationContext) {
        this.validationContext = validationContext;
    }

    public void setConstraintChecker(ConstraintChecker checker) {
        this.validationContext.setConstraintChecker(checker);
    }

    protected ConstraintChecker getConstraintChecker() {
        return this.validationContext.getConstraintChecker();
    }

    public void setStartTagBuffer(AttributeInheritor startTag) {
        this.validationContext.setAttributeInheritor(startTag);
    }

    public AttributeInheritor getAttributeInheritor() {
        return this.validationContext.getAttributeInheritor();
    }

    @Override
    public boolean usesTypeAnnotations() {
        return false;
    }

    @Override
    public void append(Item item, Location locationId, int copyNamespaces) throws XPathException {
        this.decompose(item, locationId, copyNamespaces);
    }

    protected void reportValidationError(ValidationFailure err, boolean issueComment, Location locationId) throws XPathException {
        InvalidityHandler handler;
        PathMaintainer pm;
        if (err.hasBeenReported()) {
            return;
        }
        PipelineConfiguration pipe = this.getPipelineConfiguration();
        if (Loc.isUnknown(locationId)) {
            err.setSourceLocator(this.validationContext.getInitiatingLocation());
        } else {
            err.setSourceLocator(locationId);
        }
        if (err.getErrorCodeQName() == null) {
            err.setErrorCode(this.validationContext.getErrorCode());
        }
        if ((pm = (PathMaintainer)pipe.getComponent("net.sf.saxon.event.PathMaintainer")) != null) {
            AbsolutePath path = pm.getAbsolutePath();
            if (locationId instanceof AttributeLocation) {
                FingerprintedQName attName = new FingerprintedQName(((AttributeLocation)locationId).getAttributeName(), this.getNamePool());
                path.appendAttributeName(attName);
            }
            err.setPath(path);
        } else if (locationId instanceof AttributeLocation) {
            String attLoc = "@" + ((AttributeLocation)locationId).getAttributeName().getDisplayName();
            StructuredQName elName = ((AttributeLocation)locationId).getElementName();
            if (elName != null) {
                attLoc = elName.getDisplayName() + "/" + attLoc;
            }
            String message = "At " + attLoc + ": " + err.getMessage();
            err.setMessage(message);
        }
        for (XPathContext context = pipe.getXPathContext(); context != null; context = context.getCaller()) {
            Item current = context.getContextItem();
            if (!(current instanceof NodeInfo)) continue;
            err.setContextPath(Navigator.getAbsolutePath((NodeInfo)current));
            break;
        }
        if ((handler = this.validationContext.getInvalidityHandler()) == null) {
            handler = new InvalidityHandlerWrappingErrorReporter(pipe.getErrorReporter());
        }
        handler.reportInvalidity(err);
        err.setHasBeenReported(true);
        AssertionTreeBuilder atb = this.validationContext.getAssertionTreeBuilder();
        if (atb != null) {
            atb.markAncestorNodesUntyped();
        }
        if (this.validationContext.incrementErrorCount(err)) {
            throw new XPathException("Validation terminated - too many errors");
        }
        if (issueComment && pipe.getParseOptions().isAddCommentsAfterValidationErrors()) {
            this.comment(StringView.of("\nVALIDATION ERROR: " + err.getMessage() + '\n'), locationId, 0);
        }
    }

    protected void reportIfInvalid() throws ValidationException {
        if (this.validationContext != null && this.validationContext.getErrorCount() > 0 && !this.getPipelineConfiguration().isRecoverFromValidationErrors()) {
            String message = this.validationContext.getErrorCount() == 1 ? "One validation error was reported: " : new Numberer_en().toWords("", this.validationContext.getErrorCount()) + " validation errors were reported. First error: ";
            message = message + this.validationContext.getFirstFailure().getMessage();
            ValidationFailure err = new ValidationFailure(message);
            String firstErrorCode = this.validationContext.getFirstFailure().getErrorCode();
            if (firstErrorCode != null && !firstErrorCode.startsWith("FO")) {
                err.setErrorCode(firstErrorCode);
            } else if (this.validationContext.getErrorCode() != null) {
                err.setErrorCode(this.validationContext.getErrorCode());
            } else {
                err.setErrorCode(this.getPipelineConfiguration().isXSLT() ? "XTTE1510" : "XQDY0027");
            }
            ValidationException ve = err.makeException();
            ve.setHasBeenReported(true);
            ve.setErrorObject(this.validationContext.getValidationErrorObject());
            throw ve;
        }
    }
}

