/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.AccumulatorRegistryEE;
import com.saxonica.ee.stream.Inversion;
import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.PushToPull;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.stream.watch.AccumulatorWatch;
import com.saxonica.ee.stream.watch.StreamWatch;
import com.saxonica.ee.stream.watch.WatchManager;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.expr.ContextMappingIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.accum.Accumulator;
import net.sf.saxon.expr.sort.ItemWithMergeKeys;
import net.sf.saxon.expr.sort.MergeInstr;
import net.sf.saxon.functions.DocumentFn;
import net.sf.saxon.functions.SnapshotFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.ExternalObject;

public class MergeInstrAdjunct
extends StreamingAdjunct {
    public static void checkStreamability(MergeInstr.MergeSource mergeSource, Configuration config) throws XPathException {
        String streamabilityOption = config.getConfigurationProperty(Feature.STREAMABILITY);
        boolean actuallyStreamable = true;
        ArrayList<String> reasons = new ArrayList<String>();
        if (streamabilityOption.equals("off")) {
            reasons.add("Streaming is disabled at the Saxon Configuration level");
            actuallyStreamable = false;
        } else {
            Object snapshot;
            ContextItemStaticInfoEE info = new ContextItemStaticInfoEE(NodeKindTest.DOCUMENT, false, Posture.STRIDING);
            Expression rowSelect = mergeSource.getRowSelect();
            if (rowSelect.isCallOn(SnapshotFn.class)) {
                snapshot = rowSelect;
                rowSelect = ((SystemFunctionCall)rowSelect).getArg(0);
            } else {
                snapshot = SystemFunction.makeCall("snapshot", rowSelect.getRetainedStaticContext(), mergeSource.getRowSelect());
                mergeSource.setRowSelect((Expression)snapshot);
            }
            PostureAndSweep ps = Streamability.getStreamability(rowSelect, info, reasons);
            if (ps.getPosture() != Posture.STRIDING) {
                actuallyStreamable = false;
                reasons.add("The select expression for the merge source is not striding");
            } else {
                Streamability.getStreamability((Expression)snapshot, info, reasons);
                mergeSource.invertedAction = Inversion.invertExpression((Expression)snapshot, false);
            }
        }
        if (!actuallyStreamable) {
            FastStringBuffer buffer;
            boolean fallback = config.getBooleanProperty(Feature.STREAMING_FALLBACK);
            if (fallback) {
                buffer = new FastStringBuffer(120);
                buffer.append("Executing without streaming. ");
                for (String s : reasons) {
                    buffer.append(s + ". ");
                }
                config.getErrorListener().warning(new XPathException(buffer.toString()));
                mergeSource.streamable = false;
            } else {
                buffer = new FastStringBuffer(120);
                buffer.append("Streaming requested for xsl:merge, but the construct is not streamable. ");
                for (String s : reasons) {
                    buffer.append(s + ". ");
                }
                XPathException err = new XPathException(buffer.toString(), "XTSE3430");
                err.setIsStaticError(true);
                throw err;
            }
        }
    }

    @Override
    public PostureAndSweep computeStreamability(ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        MergeInstr instr = (MergeInstr)this.getExpression();
        for (MergeInstr.MergeSource ms : instr.getMergeSources()) {
            if (ms.getForEachItem() != null && !Streamability.getStreamability(ms.getForEachItem(), contextInfo, reasons).equals(PostureAndSweep.GROUNDED_AND_MOTIONLESS)) {
                reasons.add("The for-each-item expression, if present, must be grounded and motionless");
                return PostureAndSweep.ROAMING_AND_FREE_RANGING;
            }
            if (ms.getForEachSource() != null && !Streamability.getStreamability(ms.getForEachSource(), contextInfo, reasons).equals(PostureAndSweep.GROUNDED_AND_MOTIONLESS)) {
                reasons.add("The for-each-source expression, if present, must be grounded and motionless");
                return PostureAndSweep.ROAMING_AND_FREE_RANGING;
            }
            if (ms.getForEachItem() != null || ms.getForEachSource() != null || Streamability.getStreamability(ms.getRowSelect(), contextInfo, reasons).equals(PostureAndSweep.GROUNDED_AND_MOTIONLESS)) continue;
            reasons.add("If neither of the attributes for-each-item or for-each-source is present, the select expression must be grounded and motionless");
            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
        }
        return PostureAndSweep.GROUNDED_AND_MOTIONLESS;
    }

    public static List<ContextMappingIterator<ExternalObject<ItemWithMergeKeys>>> makeSourceIterators(MergeInstr.MergeSource ms, PackageData pd, XPathContext c1) throws XPathException {
        Object uri;
        ArrayList<ContextMappingIterator<ExternalObject<ItemWithMergeKeys>>> result = new ArrayList<ContextMappingIterator<ExternalObject<ItemWithMergeKeys>>>();
        SequenceIterator<?> uriIter = ms.getForEachSource().iterate(c1);
        while ((uri = uriIter.next()) != null) {
            ParseOptions options = new ParseOptions(c1.getConfiguration().getParseOptions());
            options.setSchemaValidationMode(ms.validation);
            options.setTopLevelType(ms.schemaType);
            options.setApplicableAccumulators(ms.accumulators);
            String href = uri.getStringValue();
            PushToPull.Pusher pusher = context -> {
                Controller controller = context.getController();
                XPathContextMajor c2 = context.newContext();
                c2.setCurrentTemplateRule(null);
                PipelineConfiguration pipe = controller.makePipelineConfiguration();
                pipe.setXPathContext(context);
                WatchManager wm = new WatchManager(pipe);
                wm.setXPathContext(context);
                AccumulatorRegistryEE am = (AccumulatorRegistryEE)pd.getAccumulatorRegistry();
                if (am != null && ms.accumulators != null) {
                    Map<Accumulator, AccumulatorWatch> watchMap = AccumulatorRegistryEE.registerSelectedAccumulators(wm, ms.accumulators);
                    wm.setAccumulatorWatchMap(watchMap);
                }
                StartTagBuffer stb = new StartTagBuffer(wm);
                wm.setStartTagBuffer(stb);
                stb.setUnderlyingReceiver(wm);
                Receiver out = stb;
                if (pd instanceof StylesheetPackage && ((StylesheetPackage)pd).isStripsTypeAnnotations()) {
                    out = pd.getConfiguration().getAnnotationStripper(out);
                }
                wm.addWatch(new StreamWatch((Inversion)ms.invertedAction, wm, c2), true);
                DocumentFn.sendDoc(href, ms.baseURI, context, ms.location, out, options);
            };
            SequenceIterator<Item<?>> iter = new PushToPull(pusher, c1).getIterator();
            XPathContextMinor c2 = c1.newMinorContext();
            c2.trackFocus(iter);
            MergeInstr.MergeKeyMappingFunction addMergeKeys = new MergeInstr.MergeKeyMappingFunction(c2, ms);
            ContextMappingIterator<ExternalObject<ItemWithMergeKeys>> iter3 = new ContextMappingIterator<ExternalObject<ItemWithMergeKeys>>(addMergeKeys, c2);
            result.add(iter3);
        }
        return result;
    }
}

