/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.s9api;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.s9api.ValidationStatistics;
import com.saxonica.ee.trans.Outcome;
import com.saxonica.ee.validate.InvalidityReportGeneratorEE;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.Sink;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.GlobalParameterSet;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.InvalidityHandler;
import net.sf.saxon.lib.InvalidityHandlerWrappingErrorListener;
import net.sf.saxon.lib.InvalidityReportGenerator;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SaxonApiUncheckedException;
import net.sf.saxon.s9api.SchemaValidator;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.streams.Steps;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.type.ValidationParams;

public class SchemaValidatorImpl
extends SchemaValidator {
    private Processor processor;
    private boolean lax;
    private InvalidityHandler invalidityHandler;
    private Destination destination;
    private QName documentElementName;
    private SchemaType documentElementType;
    private boolean expandAttributeDefaults = true;
    private boolean useXsiSchemaLocation;
    private boolean keepStatistics;
    private ValidationStatistics latestStatistics = null;
    private GlobalParameterSet suppliedParams = new GlobalParameterSet();
    private int threadCount = Runtime.getRuntime().availableProcessors();

    public SchemaValidatorImpl(Processor processor) {
        this.processor = processor;
        this.useXsiSchemaLocation = processor.getConfigurationProperty(Feature.USE_XSI_SCHEMA_LOCATION);
        this.invalidityHandler = new InvalidityHandlerWrappingErrorListener(processor.getUnderlyingConfiguration().getErrorListener());
    }

    @Override
    public void setLax(boolean lax) {
        this.lax = lax;
    }

    @Override
    public boolean isLax() {
        return this.lax;
    }

    @Override
    public void setErrorListener(ErrorListener listener) {
        this.invalidityHandler = new InvalidityHandlerWrappingErrorListener(listener);
    }

    @Override
    public ErrorListener getErrorListener() {
        if (this.invalidityHandler instanceof InvalidityHandlerWrappingErrorListener) {
            return ((InvalidityHandlerWrappingErrorListener)this.invalidityHandler).getErrorListener();
        }
        return null;
    }

    @Override
    public void setValidityReporting(Destination destination) throws SaxonApiException {
        this.invalidityHandler = this.processor.getUnderlyingConfiguration().createValidityReporter();
        ((InvalidityReportGeneratorEE)this.invalidityHandler).setDestination(destination);
    }

    @Override
    public InvalidityHandler getInvalidityHandler() {
        return this.invalidityHandler;
    }

    @Override
    public void setInvalidityHandler(InvalidityHandler handler) {
        this.invalidityHandler = handler;
    }

    @Override
    public void setCollectStatistics(boolean collect) {
        this.keepStatistics = collect;
        this.latestStatistics = null;
    }

    @Override
    public boolean isCollectStatistics() {
        return this.keepStatistics;
    }

    @Override
    public void reportValidationStatistics(Destination destination) throws SaxonApiException {
        if (this.latestStatistics != null) {
            this.latestStatistics.report(this.processor, destination);
        }
    }

    @Override
    public void setUseXsiSchemaLocation(boolean recognize) {
        this.useXsiSchemaLocation = recognize;
    }

    @Override
    public boolean isUseXsiSchemaLocation() {
        return this.useXsiSchemaLocation;
    }

    @Override
    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    @Override
    public Destination getDestination() {
        return this.destination;
    }

    @Override
    public void setDocumentElementName(QName name) {
        this.documentElementName = name;
    }

    @Override
    public QName getDocumentElementName() {
        return this.documentElementName;
    }

    @Override
    public void setDocumentElementTypeName(QName name) throws SaxonApiException {
        Configuration config = this.processor.getUnderlyingConfiguration();
        this.documentElementType = config.getSchemaType(name.getStructuredQName());
        if (this.documentElementType == null) {
            throw new SaxonApiException("Unknown type " + name.getClarkName());
        }
    }

    @Override
    public QName getDocumentElementTypeName() {
        if (this.documentElementType == null) {
            return null;
        }
        return new QName(this.documentElementType.getStructuredQName());
    }

    @Override
    protected SchemaType getDocumentElementType() {
        return this.documentElementType;
    }

    @Override
    public void setExpandAttributeDefaults(boolean expand) {
        this.expandAttributeDefaults = expand;
    }

    @Override
    public boolean isExpandAttributeDefaults() {
        return this.expandAttributeDefaults;
    }

    @Override
    public void setParameter(QName name, XdmValue value) {
        try {
            this.suppliedParams.put(name.getStructuredQName(), value == null ? null : value.getUnderlyingValue().materialize());
        }
        catch (XPathException e) {
            throw new SaxonApiUncheckedException(e);
        }
    }

    @Override
    public XdmValue getParameter(QName name) {
        GroundedValue<?> value = this.suppliedParams.get(name.getStructuredQName());
        return value == null ? null : XdmValue.wrap(value);
    }

    public void setThreadCount(int tc) {
        this.threadCount = tc;
    }

    @Override
    public void validateMultiple(Iterable<Source> sources) throws SaxonApiException {
        EnterpriseConfiguration config = (EnterpriseConfiguration)this.processor.getUnderlyingConfiguration();
        if (!config.getBooleanProperty(Feature.ALLOW_MULTITHREADING)) {
            this.threadCount = 1;
        }
        if (this.threadCount < 1) {
            this.threadCount = 1;
        }
        ExecutorService executorService = config.getMultithreadingFactory().makeExecutorService(this.threadCount);
        if (this.destination != null) {
            throw new IllegalStateException("Cannot validate multiple documents when destination is set externally");
        }
        Destination reportDestination = null;
        List<XdmNode> reportDocs = Collections.synchronizedList(new ArrayList());
        if (this.invalidityHandler instanceof InvalidityReportGeneratorEE) {
            reportDestination = ((InvalidityReportGeneratorEE)this.invalidityHandler).getDestination();
        }
        InvalidityReportGenerator singleTaskHandler = null;
        ValidationCompletionAction completionAction = null;
        LinkedBlockingQueue<Future<Outcome<Boolean>>> queue = new LinkedBlockingQueue<Future<Outcome<Boolean>>>();
        for (Source s : sources) {
            if (this.invalidityHandler != null) {
                XdmDestination xdmDestination = new XdmDestination();
                singleTaskHandler = this.processor.getUnderlyingConfiguration().createValidityReporter();
                ((InvalidityReportGeneratorEE)singleTaskHandler).setDestination(xdmDestination);
                InvalidityReportGeneratorEE singleReportHandler = (InvalidityReportGeneratorEE)singleTaskHandler;
                singleReportHandler.setXsdVersion(this.processor.getUnderlyingConfiguration().getXsdVersion() == 11 ? "1.1" : "1.0");
                try {
                    singleReportHandler.startReporting(s.getSystemId());
                }
                catch (XPathException e) {
                    e.printStackTrace();
                }
                completionAction = () -> {
                    try {
                        singleReportHandler.endReporting();
                        reportDocs.add(((XdmDestination)singleReportHandler.getDestination()).getXdmNode());
                    }
                    catch (XPathException e1) {
                        throw new SaxonApiException(e1);
                    }
                };
            }
            Future<Outcome<Boolean>> future = executorService.submit(new ValidationTask(s, singleTaskHandler, completionAction));
            queue.add(future);
        }
        executorService.shutdown();
        boolean finish = false;
        try {
            finish = executorService.awaitTermination(24L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
        if (!finish) {
            throw new SaxonApiException("Some validation task(s) failed to complete within 24 hours");
        }
        for (Future future : queue) {
            try {
                Outcome outcome = (Outcome)future.get();
                Exception ex = outcome.getException();
                if (ex == null || ex instanceof XPathException) continue;
                throw new SaxonApiException(ex);
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        ExplicitLocation loc = ExplicitLocation.UNKNOWN_LOCATION;
        if (reportDestination != null) {
            Receiver receiver = reportDestination.getReceiver(config.makePipelineConfiguration(), config.obtainDefaultSerializationProperties());
            try {
                receiver.open();
                receiver.startDocument(0);
                receiver.startElement(new FingerprintedQName("", "http://saxon.sf.net/ns/validation", "validation-reports"), Untyped.getInstance(), loc, 0);
                receiver.startContent();
                for (XdmNode node : reportDocs) {
                    for (XdmNode de : node.select(Steps.child()).asListOfNodes()) {
                        de.getUnderlyingNode().copy(receiver, 0, loc);
                    }
                }
                receiver.endElement();
                receiver.endDocument();
                receiver.close();
            }
            catch (XPathException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void validate(Source source) throws SaxonApiException {
        Configuration config = this.processor.getUnderlyingConfiguration();
        Receiver receiver = this.getReceiver(config, source.getSystemId());
        try {
            if (this.invalidityHandler instanceof InvalidityReportGenerator) {
                ((InvalidityReportGenerator)this.invalidityHandler).setXsdVersion(config.getXsdVersion() == 11 ? "1.1" : "1.0");
            }
            this.invalidityHandler.startReporting(source.getSystemId());
            Sender.send(source, receiver, receiver.getPipelineConfiguration().getParseOptions());
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
        finally {
            if (this.invalidityHandler != null) {
                try {
                    this.invalidityHandler.endReporting();
                }
                catch (XPathException xPathException) {}
            }
        }
    }

    protected ValidationParams convertParams(GlobalParameterSet suppliedParams, Collection<GlobalParam> declaredParams) throws XPathException {
        ValidationParams vp = new ValidationParams();
        XPathContextMajor context = new Controller(this.processor.getUnderlyingConfiguration()).newXPathContext();
        for (GlobalParam cp : declaredParams) {
            GroundedValue<?> value = suppliedParams.convertParameterValue(cp.getVariableQName(), cp.getRequiredType(), true, context);
            if (value == null) continue;
            vp.put(cp.getVariableQName(), value);
        }
        return vp;
    }

    @Override
    public Receiver getReceiver(PipelineConfiguration pipe, SerializationProperties params) throws SaxonApiException {
        return this.getReceiver(pipe.getConfiguration(), null);
    }

    private Receiver getReceiver(Configuration config, String systemId) throws SaxonApiException {
        Controller controller = new Controller(config);
        Executable exec = controller.getExecutable();
        PackageData pack = new PackageData(config);
        pack.setLocalLicenseId(((EnterpriseConfiguration)config).getSuperSchema().getLocalLicenseId());
        pack.setSchemaAware(true);
        exec.setTopLevelPackage(pack);
        exec.setSchemaAware(true);
        PipelineConfiguration pipe = controller.makePipelineConfiguration();
        pipe.setUseXsiSchemaLocation(this.useXsiSchemaLocation);
        pipe.setHostLanguage(52);
        ParseOptions options = pipe.getParseOptions();
        options.setCheckEntityReferences(true);
        options.setExpandAttributeDefaults(this.expandAttributeDefaults);
        options.setSchemaValidationMode(this.lax ? 2 : 1);
        options.setSpaceStrippingRule(NoElementsSpaceStrippingRule.getInstance());
        options.setTopLevelType(this.documentElementType);
        options.setInvalidityHandler(this.invalidityHandler);
        if (this.documentElementName != null) {
            options.setTopLevelElement(new StructuredQName(this.documentElementName.getPrefix(), this.documentElementName.getNamespaceURI(), this.documentElementName.getLocalName()));
        }
        try {
            options.setValidationParams(this.convertParams(this.suppliedParams, config.getDeclaredSchemaParameters()));
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
        options.setCheckEntityReferences(true);
        if (this.keepStatistics) {
            this.latestStatistics = new ValidationStatistics();
            options.setValidationStatisticsRecipient(this.latestStatistics.recipient);
        }
        Sink output = this.destination == null ? new Sink(pipe) : this.destination.getReceiver(pipe, config.obtainDefaultSerializationProperties());
        output.setPipelineConfiguration(pipe);
        return config.getDocumentValidator(output, systemId, options, null);
    }

    @Override
    public void close() throws SaxonApiException {
        if (this.destination != null) {
            this.destination.close();
            this.destination = null;
        }
    }

    class ValidationTask
    implements Callable<Outcome<Boolean>> {
        private Source source;
        private ValidationCompletionAction action = null;
        private InvalidityHandler handler = null;

        public ValidationTask(Source s, InvalidityHandler handler, ValidationCompletionAction action) {
            this.source = s;
            this.handler = handler;
            this.action = action;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Outcome<Boolean> call() throws Exception {
            Configuration config = SchemaValidatorImpl.this.processor.getUnderlyingConfiguration();
            try {
                Controller controller = new Controller(config);
                controller.getExecutable().setSchemaAware(true);
                PipelineConfiguration pipe = controller.makePipelineConfiguration();
                pipe.setUseXsiSchemaLocation(SchemaValidatorImpl.this.useXsiSchemaLocation);
                pipe.setHostLanguage(52);
                ParseOptions options = new ParseOptions();
                options.setCheckEntityReferences(true);
                options.setValidationParams(SchemaValidatorImpl.this.convertParams(SchemaValidatorImpl.this.suppliedParams, config.getDeclaredSchemaParameters()));
                options.setInvalidityHandler(this.handler);
                options.setCheckEntityReferences(true);
                options.setExpandAttributeDefaults(SchemaValidatorImpl.this.expandAttributeDefaults);
                options.setSchemaValidationMode(SchemaValidatorImpl.this.lax ? 2 : 1);
                options.setSpaceStrippingRule(NoElementsSpaceStrippingRule.getInstance());
                options.setTopLevelType(SchemaValidatorImpl.this.documentElementType);
                if (SchemaValidatorImpl.this.documentElementName != null) {
                    options.setTopLevelElement(new StructuredQName(SchemaValidatorImpl.this.documentElementName.getPrefix(), SchemaValidatorImpl.this.documentElementName.getNamespaceURI(), SchemaValidatorImpl.this.documentElementName.getLocalName()));
                }
                Sink output = SchemaValidatorImpl.this.destination == null ? new Sink(pipe) : SchemaValidatorImpl.this.destination.getReceiver(pipe, null);
                output.setPipelineConfiguration(pipe);
                Receiver receiver = config.getDocumentValidator(output, this.source.getSystemId(), options, null);
                Sender.send(this.source, receiver, options);
            }
            catch (SaxonApiException | XPathException e1) {
                Outcome<Boolean> outcome = new Outcome<Boolean>(e1);
                return outcome;
            }
            finally {
                if (this.action != null) {
                    this.action.finish();
                }
            }
            return new Outcome<Boolean>(true);
        }
    }

    static interface ValidationCompletionAction {
        public void finish() throws SaxonApiException;
    }
}

