/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph.cmd;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.LinkedList;
import marmot.core.Sequence;
import marmot.core.Token;
import marmot.morph.MorphModel;
import marmot.morph.MorphOptions;
import marmot.morph.MorphTagger;
import marmot.morph.Word;
import marmot.morph.cmd.Annotator;
import marmot.morph.io.SentenceReader;
import marmot.util.FileUtils;

public class Trainer {
    public static MorphTagger train(MorphOptions options) {
        long time = System.currentTimeMillis();
        LinkedList<Sequence> train_sentences = new LinkedList<Sequence>();
        SentenceReader reader = new SentenceReader(options.getTrainFile());
        if (options.getTagMorph()) {
            reader.getFileOptions().dieIfPropertyIsEmpty("morph-index");
        }
        for (Object sentence : reader) {
            train_sentences.add((Sequence)sentence);
        }
        reader = null;
        LinkedList<Sequence> test_sentences = null;
        if (!options.getTestFile().isEmpty()) {
            reader = new SentenceReader(options.getTestFile());
            if (options.getTagMorph()) {
                reader.getFileOptions().dieIfPropertyIsEmpty("morph-index");
            }
            test_sentences = new LinkedList<Sequence>();
            for (Sequence sentence : reader) {
                test_sentences.add(sentence);
            }
            reader = null;
        }
        MorphTagger tagger = (MorphTagger)MorphModel.train(options, train_sentences, test_sentences);
        if (!options.getModelFile().isEmpty()) {
            FileUtils.saveToFile((Serializable)tagger, options.getModelFile());
        }
        if (options.getVerbose()) {
            System.err.format("Training took: %ds\n", (System.currentTimeMillis() - time) / 1000L);
        }
        return tagger;
    }

    public static void main(String[] args) {
        MorphOptions options = new MorphOptions();
        options.setPropertiesFromStrings(args);
        options.dieIfPropertyIsEmpty("train-file");
        options.dieIfPropertyIsEmpty("model-file");
        MorphTagger tagger = Trainer.train(options);
        MorphModel model = (MorphModel)tagger.getModel();
        if (!options.getTestFile().isEmpty()) {
            LinkedList<Sequence> sentences = new LinkedList<Sequence>();
            SentenceReader reader = new SentenceReader(options.getTestFile());
            if (options.getTagMorph()) {
                reader.getFileOptions().dieIfPropertyIsEmpty("morph-index");
            }
            for (Sequence sentence : reader) {
                for (Token token : sentence) {
                    Word word = (Word)token;
                    model.addIndexes(word, false);
                }
                sentences.add(sentence);
            }
            if (!options.getPredFile().isEmpty()) {
                try {
                    Writer writer = FileUtils.openFileWriter(options.getPredFile());
                    Annotator.annotate(tagger, options.getTestFile(), writer);
                    writer.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

