/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.AttributeDecl;
import com.saxonica.ee.schema.AttributeGroupDecl;
import com.saxonica.ee.schema.ElementDecl;
import com.saxonica.ee.schema.ModelGroupDefinition;
import com.saxonica.ee.schema.Notation;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaStructure;
import com.saxonica.ee.schema.SingleNamespaceSchema;
import com.saxonica.ee.schema.UserDefinedType;
import com.saxonica.ee.schema.sdoc.SchemaDocument;
import com.saxonica.ee.schema.sdoc.SchemaElement;
import com.saxonica.ee.schema.sdoc.SchemaReader;
import com.saxonica.ee.schema.sdoc.XSDAttribute;
import com.saxonica.ee.schema.sdoc.XSDAttributeGroup;
import com.saxonica.ee.schema.sdoc.XSDComplexType;
import com.saxonica.ee.schema.sdoc.XSDElement;
import com.saxonica.ee.schema.sdoc.XSDGroup;
import com.saxonica.ee.schema.sdoc.XSDNotation;
import com.saxonica.ee.schema.sdoc.XSDSchema;
import com.saxonica.ee.schema.sdoc.XSDSimpleType;
import java.io.IOException;
import java.util.HashSet;
import javax.xml.transform.Source;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;

public class XSDOverride
extends SchemaElement {
    private SingleNamespaceSchema originalSchema;
    private SchemaDocument originalSchemaDocument;
    private SingleNamespaceSchema replacementSchema;

    @Override
    protected void prepareAttributes() throws SchemaException {
        SchemaCompiler compiler;
        if (this.getXSDSchema().getSchemaCompiler().getLanguageVersion() == 10) {
            this.error("The xs:override element requires XSD 1.1 to be enabled");
        }
        AttributeMap atts = this.attributes();
        String[] allowed = new String[]{"id", "schemaLocation"};
        this.allowAttributes(atts, allowed);
        this.processId();
        String schemaLocation = atts.getValue(NamespaceUri.NULL, "schemaLocation");
        if (schemaLocation == null) {
            this.missingAttribute("schemaLocation");
            return;
        }
        String documentBase = this.getBaseURI();
        Source source = SchemaReader.getSource(documentBase, schemaLocation, compiler = this.getXSDSchema().getSchemaCompiler(), null);
        if (source == null || source.getSystemId() == null) {
            throw new SchemaException("The xsl:override/@schemaLocation resolves to a source with no known system ID");
        }
        StringBuilder fsb = new StringBuilder(64);
        fsb.append(source.getSystemId());
        fsb.append("?referrer=");
        fsb.append(documentBase);
        fsb.append(";index=");
        fsb.append(Navigator.getNumberSimple(this, null) + "");
        String key = fsb.toString();
        if (compiler.isBeingRead(key)) {
            this.replacementSchema = null;
            return;
        }
        compiler.setBeingRead(key);
        if (compiler.getExistingSchemaDocument(schemaLocation, this.getXSDSchema().getTargetNamespace()) != null) {
            this.error("Saxon can't handle overriding of a schema document that has already been loaded by a different route");
            return;
        }
        try {
            SchemaDocument schemaDoc;
            PipelineConfiguration pipe = this.getSchemaNodeFactory().getPipelineConfiguration();
            this.originalSchemaDocument = schemaDoc = SchemaReader.buildSchemaDocument(source, compiler, pipe, this);
            this.originalSchema = schemaDoc.getXSDSchema().getSchema();
            NamespaceUri originalTargetNS = schemaDoc.getXSDSchema().getTargetNamespace();
            if (!this.getSchema().getTargetNamespace().equals(originalTargetNS)) {
                if (originalTargetNS.isEmpty()) {
                    this.originalSchemaDocument = schemaDoc = compiler.doChameleonTransformation(schemaDoc.getDocument().getRootNode(), this);
                    this.originalSchema = schemaDoc.getXSDSchema().getSchema();
                    try {
                        XSDSchema overridden = schemaDoc.getXSDSchema();
                        overridden.processAllAttributes();
                        overridden.validateSubtree(compiler);
                    }
                    catch (SchemaException err) {
                        compiler.warning("The target of the xs:override is not a valid schema", "SXSD1017", this);
                    }
                } else {
                    this.error("The targetNamespace of the overridden schema document differs from that of the overriding schema document");
                    this.originalSchema = null;
                }
            }
            SchemaDocument convertedSchemaDocument = compiler.doOverrideTransformation(schemaDoc.getDocument().getRootNode(), this);
            XSDSchema top = convertedSchemaDocument.getXSDSchema();
            top.processAllAttributes();
            top.validateSubtree(compiler);
            this.replacementSchema = top.getSchema();
        }
        catch (SchemaException e) {
            Throwable cause = e.getException();
            if (cause instanceof IOException) {
                this.warning("Failed to locate overridden schema document " + schemaLocation);
                this.originalSchema = new SingleNamespaceSchema((EnterpriseConfiguration)this.getConfiguration(), NamespaceUri.NULL);
            }
            throw e;
        }
    }

    public SingleNamespaceSchema getReplacementSchema() {
        return this.replacementSchema;
    }

    public SingleNamespaceSchema getOriginalSchema() {
        return this.originalSchema;
    }

    public SchemaDocument getOriginalSchemaDocument() {
        return this.originalSchemaDocument;
    }

    @Override
    public void validate(SchemaCompiler compiler) throws SchemaException {
        if (compiler.getLanguageVersion() == 10) {
            this.error("xs:override requires XML Schema 1.1 to be enabled");
            return;
        }
        if (this.originalSchema == null) {
            return;
        }
        HashSet<String> redefinedTypes = new HashSet<String>();
        HashSet<String> redefinedAttributeGroups = new HashSet<String>();
        HashSet<String> redefinedModelGroups = new HashSet<String>();
        HashSet<String> redefinedElements = new HashSet<String>();
        HashSet<String> redefinedAttributes = new HashSet<String>();
        HashSet<String> redefinedNotations = new HashSet<String>();
        block9: for (NodeInfo nodeInfo : this.children()) {
            int fp = nodeInfo.getFingerprint();
            switch (fp) {
                case 578: {
                    continue block9;
                }
                case 584: {
                    String attributeName = nodeInfo.getAttributeValue(NamespaceUri.NULL, "name");
                    if (attributeName == null || redefinedAttributes.add(attributeName)) continue block9;
                    this.error("Attempting to override the same attribute declaration more than once");
                    continue block9;
                }
                case 591: {
                    String elementName = nodeInfo.getAttributeValue(NamespaceUri.NULL, "name");
                    if (elementName == null || redefinedElements.add(elementName)) continue block9;
                    this.error("Attempting to override the same element declaration more than once");
                    continue block9;
                }
                case 585: {
                    String attributeGroupName = nodeInfo.getAttributeValue(NamespaceUri.NULL, "name");
                    if (attributeGroupName == null || redefinedAttributeGroups.add(attributeGroupName)) continue block9;
                    this.error("Attempting to override the same attribute group more than once");
                    continue block9;
                }
                case 588: 
                case 621: {
                    String typeName = nodeInfo.getAttributeValue(NamespaceUri.NULL, "name");
                    if (typeName == null || redefinedTypes.add(typeName)) continue block9;
                    this.error("Attempting to override the same type more than once");
                    continue block9;
                }
                case 596: {
                    String modelGroupName = nodeInfo.getAttributeValue(NamespaceUri.NULL, "name");
                    if (modelGroupName == null || redefinedModelGroups.add(modelGroupName)) continue block9;
                    this.error("Attempting to override the same named model group more than once");
                    continue block9;
                }
                case 611: {
                    String notationName = nodeInfo.getAttributeValue(NamespaceUri.NULL, "name");
                    if (notationName == null || redefinedNotations.add(notationName)) continue block9;
                    this.error("Attempting to override the same notation declaration more than once");
                    continue block9;
                }
            }
            this.illegalElement(nodeInfo);
        }
    }

    @Override
    public void postValidate(SchemaCompiler compiler) throws SchemaException {
        if (this.originalSchema == null || this.replacementSchema == null) {
            return;
        }
        for (NodeInfo nodeInfo : this.children()) {
            int childfp = nodeInfo.getFingerprint();
            switch (childfp) {
                case 584: {
                    SchemaComponent existing;
                    AttributeDecl attribute = ((XSDAttribute)nodeInfo).getAttributeDeclaration();
                    if (attribute == null || (existing = this.originalSchema.getAttributeDecl(attribute.getComponentName())) == null) break;
                    attribute.setRedefinitionLevel(((SchemaStructure)existing).getRedefinitionLevel() + 1);
                    break;
                }
                case 585: {
                    SchemaComponent existing;
                    AttributeGroupDecl ag = ((XSDAttributeGroup)nodeInfo).getAttributeGroupDecl();
                    if (ag == null || (existing = this.originalSchema.getAttributeGroup(ag.getAttributeGroupName())) == null) break;
                    ag.setRedefinitionLevel(((SchemaStructure)existing).getRedefinitionLevel() + 1);
                    break;
                }
                case 588: {
                    SchemaComponent existing;
                    UserDefinedType typeDef = ((XSDComplexType)nodeInfo).getComplexType();
                    if (typeDef == null || (existing = this.originalSchema.getType(typeDef.getTypeName())) == null) break;
                    typeDef.setRedefinitionLevel(existing.getRedefinitionLevel() + 1);
                    break;
                }
                case 621: {
                    UserDefinedType typeDef;
                    SchemaComponent existing;
                    try {
                        typeDef = ((XSDSimpleType)nodeInfo).getSimpleTypeDefinition();
                    }
                    catch (SchemaException e) {
                        this.error(e.getMessage());
                        return;
                    }
                    if (typeDef == null || (existing = this.originalSchema.getSimpleType(typeDef.getTypeName())) == null) break;
                    typeDef.setRedefinitionLevel(existing.getRedefinitionLevel() + 1);
                    break;
                }
                case 591: {
                    SchemaComponent existing;
                    ElementDecl element = ((XSDElement)nodeInfo).getElementDeclaration();
                    if (element == null || (existing = this.originalSchema.getElementDecl(element.getComponentName())) == null) break;
                    element.setRedefinitionLevel(((SchemaStructure)existing).getRedefinitionLevel() + 1);
                    break;
                }
                case 596: {
                    SchemaComponent existing;
                    ModelGroupDefinition group = ((XSDGroup)nodeInfo).getGroupDeclaration();
                    if (group == null || (existing = this.originalSchema.getGroup(group.getModelGroupName())) == null) break;
                    group.setRedefinitionLevel(((SchemaStructure)existing).getRedefinitionLevel() + 1);
                    break;
                }
                case 611: {
                    SchemaComponent existing;
                    Notation n = ((XSDNotation)nodeInfo).getNotation();
                    if (n == null || (existing = this.originalSchema.getNotation(n.getNotationName())) == null) break;
                    n.setRedefinitionLevel(((SchemaStructure)existing).getRedefinitionLevel() + 1);
                    break;
                }
            }
        }
        if (this.replacementSchema != null) {
            this.replacementSchema.copyTo(this.getSchema(), compiler);
        }
    }
}

