/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.jvm;

import java.lang.reflect.Constructor;
import opennlp.tools.util.jvm.CHMStringInterner;
import opennlp.tools.util.jvm.StringInterner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringInterners {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringInterners.class);
    private static final StringInterner INTERNER;

    public static String intern(String sample2) {
        if (sample2 == null) {
            return null;
        }
        return INTERNER.intern(sample2);
    }

    static {
        String clazzName = System.getProperty("opennlp.interner.class", CHMStringInterner.class.getCanonicalName());
        try {
            Class<?> clazz = Class.forName(clazzName);
            Constructor<?> cons = clazz.getDeclaredConstructor(new Class[0]);
            INTERNER = (StringInterner)cons.newInstance(new Object[0]);
            LOGGER.debug("Using '{}' as String interner implementation.", (Object)clazzName);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load specified String interner implementation: '" + clazzName + "'. Reason: " + e.getLocalizedMessage(), e);
        }
    }
}

