/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph.mapper.czech;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import marmot.morph.mapper.czech.MsdTag;
import marmot.util.Counter;
import marmot.util.FileUtils;
import marmot.util.LineIterator;

public class MsdReader {
    public static Map<String, Counter<String>> getDict(String filename) {
        HashMap<String, Counter<String>> map2 = new HashMap<String, Counter<String>>();
        LineIterator iterator2 = new LineIterator(filename);
        MsdReader reader = new MsdReader();
        while (iterator2.hasNext()) {
            Object line = iterator2.next();
            if (line.isEmpty()) continue;
            String msd_tag = (String)line.get(2);
            MsdTag tag = reader.parse(msd_tag);
            Counter counter = map2.computeIfAbsent((String)line.get(1), k -> new Counter());
            counter.increment(tag.toHumanString(), 1.0);
        }
        return map2;
    }

    public static void main(String[] args2) throws IOException {
        LineIterator iterator2 = new LineIterator(args2[0]);
        Writer writer = FileUtils.openFileWriter(args2[1]);
        int num_words = 0;
        int token_index = 0;
        MsdReader reader = new MsdReader();
        while (iterator2.hasNext()) {
            Object line = iterator2.next();
            if (!line.isEmpty()) {
                String msd_tag = (String)line.get(2);
                MsdTag tag = reader.parse(msd_tag);
                writer.write(Integer.toString(token_index));
                writer.write(9);
                writer.write((String)line.get(0));
                writer.write(9);
                writer.write((String)line.get(1));
                writer.write(9);
                writer.write(tag.toPosString());
                writer.write(9);
                writer.write(tag.toPosString());
                writer.write(9);
                writer.write(tag.toHumanMorphString());
                writer.write(9);
                writer.write(48);
                writer.write(9);
                writer.write(95);
                ++token_index;
                ++num_words;
            } else {
                token_index = 0;
                if (num_words > 50000) {
                    writer.write(10);
                    break;
                }
            }
            writer.write(10);
        }
        writer.close();
    }

    public MsdTag parse(String msd_tag) {
        msd_tag = msd_tag.replace('-', '_').toLowerCase();
        MsdTag tag = new MsdTag();
        if (!msd_tag.startsWith("#")) {
            assert (msd_tag.equals("c"));
            tag.pos_ = MsdTag.Pos.z;
            return tag;
        }
        msd_tag = msd_tag.substring(1);
        char pos_char = msd_tag.charAt(0);
        switch (pos_char) {
            case 'v': {
                this.parseVerb(tag, msd_tag);
                break;
            }
            case 'a': {
                this.parseAdj(tag, msd_tag);
                break;
            }
            case 'c': {
                this.parseConjunction(tag, msd_tag);
                break;
            }
            case 'n': {
                this.parseNoun(tag, msd_tag);
                break;
            }
            case 'm': {
                this.parseNumeral(tag, msd_tag);
                break;
            }
            case 's': {
                this.parseAdposition(tag, msd_tag);
                break;
            }
            case 'r': {
                this.parseAdverb(tag, msd_tag);
                break;
            }
            case 'q': {
                tag.pos_ = MsdTag.Pos.q;
                this.parseGeneric(tag, msd_tag);
                break;
            }
            case 'p': {
                this.parsePronoun(tag, msd_tag);
                break;
            }
            case 'x': {
                tag.pos_ = MsdTag.Pos.x;
                this.parseGeneric(tag, msd_tag);
                break;
            }
            case 'y': {
                tag.pos_ = MsdTag.Pos.y;
                this.parseGeneric(tag, msd_tag);
                break;
            }
            case 'i': {
                tag.pos_ = MsdTag.Pos.i;
                this.parseGeneric(tag, msd_tag);
                break;
            }
            default: {
                throw new RuntimeException("Unknown POS: " + pos_char);
            }
        }
        return tag;
    }

    private void parsePronoun(MsdTag tag, String msd_tag) {
        tag.pos_ = MsdTag.Pos.p;
        block14: for (int index = 1; index < msd_tag.length(); ++index) {
            char c = msd_tag.charAt(index);
            if (c == '_') continue;
            switch (index) {
                case 1: {
                    this.setType(tag, c);
                    continue block14;
                }
                case 2: {
                    this.setPerson(tag, c);
                    continue block14;
                }
                case 3: {
                    this.setGender(tag, c);
                    continue block14;
                }
                case 4: {
                    this.setNumber(tag, c);
                    continue block14;
                }
                case 5: {
                    this.setCase(tag, c);
                    continue block14;
                }
                case 6: {
                    continue block14;
                }
                case 7: {
                    continue block14;
                }
                case 8: {
                    continue block14;
                }
                case 9: {
                    continue block14;
                }
                case 10: {
                    continue block14;
                }
                case 12: {
                    continue block14;
                }
                case 13: {
                    continue block14;
                }
                default: {
                    throw new RuntimeException("Unexpected Index: " + index);
                }
            }
        }
    }

    private void parseGeneric(MsdTag tag, String msd_tag) {
        block3: for (int index = 1; index < msd_tag.length(); ++index) {
            char c = msd_tag.charAt(index);
            if (c == '_') continue;
            switch (index) {
                case 1: {
                    this.setType(tag, c);
                    continue block3;
                }
                default: {
                    throw new RuntimeException("Unexpected Index: " + index);
                }
            }
        }
    }

    private void parseAdverb(MsdTag tag, String msd_tag) {
        tag.pos_ = MsdTag.Pos.r;
        block4: for (int index = 1; index < msd_tag.length(); ++index) {
            char c = msd_tag.charAt(index);
            if (c == '_') continue;
            switch (index) {
                case 1: {
                    this.setType(tag, c);
                    continue block4;
                }
                case 2: {
                    this.setDegree(tag, c);
                    continue block4;
                }
                default: {
                    throw new RuntimeException("Unexpected Index: " + index);
                }
            }
        }
    }

    private void parseAdposition(MsdTag tag, String msd_tag) {
        tag.pos_ = MsdTag.Pos.s;
        block5: for (int index = 1; index < msd_tag.length(); ++index) {
            char c = msd_tag.charAt(index);
            if (c == '_') continue;
            switch (index) {
                case 1: {
                    this.setType(tag, c);
                    continue block5;
                }
                case 2: {
                    continue block5;
                }
                case 3: {
                    this.setCase(tag, c);
                    continue block5;
                }
                default: {
                    throw new RuntimeException("Unexpected Index: " + index);
                }
            }
        }
    }

    private void parseNumeral(MsdTag tag, String msd_tag) {
        tag.pos_ = MsdTag.Pos.m;
        block9: for (int index = 1; index < msd_tag.length(); ++index) {
            char c = msd_tag.charAt(index);
            if (c == '_') continue;
            switch (index) {
                case 1: {
                    this.setType(tag, c);
                    continue block9;
                }
                case 2: {
                    this.setGender(tag, c);
                    continue block9;
                }
                case 3: {
                    this.setNumber(tag, c);
                    continue block9;
                }
                case 4: {
                    this.setCase(tag, c);
                    continue block9;
                }
                case 5: {
                    continue block9;
                }
                case 8: {
                    continue block9;
                }
                case 9: {
                    continue block9;
                }
                default: {
                    throw new RuntimeException("Unexpected Index: " + index);
                }
            }
        }
    }

    private void parseNoun(MsdTag tag, String msd_tag) {
        tag.pos_ = MsdTag.Pos.n;
        block7: for (int index = 1; index < msd_tag.length(); ++index) {
            char c = msd_tag.charAt(index);
            if (c == '_') continue;
            switch (index) {
                case 1: {
                    this.setType(tag, c);
                    continue block7;
                }
                case 2: {
                    this.setGender(tag, c);
                    continue block7;
                }
                case 3: {
                    this.setNumber(tag, c);
                    continue block7;
                }
                case 4: {
                    this.setCase(tag, c);
                    continue block7;
                }
                case 7: {
                    continue block7;
                }
                default: {
                    throw new RuntimeException("Unexpected Index: " + index);
                }
            }
        }
    }

    private void parseConjunction(MsdTag tag, String msd_tag) {
        tag.pos_ = MsdTag.Pos.c;
        block5: for (int index = 1; index < msd_tag.length(); ++index) {
            char c = msd_tag.charAt(index);
            if (c == '_') continue;
            switch (index) {
                case 1: {
                    this.setType(tag, c);
                    continue block5;
                }
                case 6: {
                    this.setNumber(tag, c);
                    continue block5;
                }
                case 7: {
                    this.setPerson(tag, c);
                    continue block5;
                }
                default: {
                    throw new RuntimeException("Unexpected Index: " + index);
                }
            }
        }
    }

    private void parseAdj(MsdTag tag, String msd_tag) {
        tag.pos_ = MsdTag.Pos.a;
        block9: for (int index = 1; index < msd_tag.length(); ++index) {
            char c = msd_tag.charAt(index);
            if (c == '_') continue;
            switch (index) {
                case 1: {
                    this.setType(tag, c);
                    continue block9;
                }
                case 2: {
                    this.setDegree(tag, c);
                    continue block9;
                }
                case 3: {
                    this.setGender(tag, c);
                    continue block9;
                }
                case 4: {
                    this.setNumber(tag, c);
                    continue block9;
                }
                case 5: {
                    this.setCase(tag, c);
                    continue block9;
                }
                case 8: {
                    continue block9;
                }
                case 9: {
                    continue block9;
                }
                default: {
                    throw new RuntimeException("Unexpected Index: " + index);
                }
            }
        }
    }

    private void setCase(MsdTag tag, char c) {
        tag.case_ = MsdTag.Case.valueOf(Character.toString(c));
    }

    private void setDegree(MsdTag tag, char c) {
        if (tag.pos_ == MsdTag.Pos.r) {
            return;
        }
        tag.degree_ = MsdTag.Degree.valueOf(Character.toString(c));
    }

    private void parseVerb(MsdTag tag, String msd_tag) {
        tag.pos_ = MsdTag.Pos.v;
        block12: for (int index = 1; index < msd_tag.length(); ++index) {
            char c = msd_tag.charAt(index);
            if (c == '_') continue;
            switch (index) {
                case 1: {
                    this.setType(tag, c);
                    continue block12;
                }
                case 2: {
                    this.setMood(tag, c);
                    continue block12;
                }
                case 3: {
                    this.setTense(tag, c);
                    continue block12;
                }
                case 4: {
                    this.setPerson(tag, c);
                    continue block12;
                }
                case 5: {
                    this.setNumber(tag, c);
                    continue block12;
                }
                case 6: {
                    this.setGender(tag, c);
                    continue block12;
                }
                case 7: {
                    this.setVoice(tag, c);
                    continue block12;
                }
                case 8: {
                    continue block12;
                }
                case 12: {
                    continue block12;
                }
                case 13: {
                    continue block12;
                }
                default: {
                    throw new RuntimeException("Unexpected Index: " + index);
                }
            }
        }
    }

    private void setType(MsdTag tag, char c) {
        tag.type_ = MsdTag.Type.valueOf(Character.toString(c));
    }

    private void setVoice(MsdTag tag, char c) {
        tag.voice_ = MsdTag.Voice.valueOf(Character.toString(c));
    }

    private void setGender(MsdTag tag, char c) {
        tag.gender_ = MsdTag.Gender.valueOf(Character.toString(c));
    }

    private void setMood(MsdTag tag, char c) {
        tag.mood_ = MsdTag.Mood.valueOf(Character.toString(c));
    }

    private void setNumber(MsdTag tag, char c) {
        tag.number_ = MsdTag.Number.valueOf(Character.toString(c));
    }

    private void setPerson(MsdTag tag, char c) {
        switch (c) {
            case '1': {
                tag.person_ = MsdTag.Person.fst;
                break;
            }
            case '2': {
                tag.person_ = MsdTag.Person.snd;
                break;
            }
            case '3': {
                tag.person_ = MsdTag.Person.thd;
                break;
            }
            case '_': {
                tag.person_ = MsdTag.Person._x;
                break;
            }
            default: {
                throw new RuntimeException("Unknown value: " + c);
            }
        }
    }

    private void setTense(MsdTag tag, char c) {
        tag.tense_ = MsdTag.Tense.valueOf(Character.toString(c));
    }
}

