/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.optim;

import com.saxonica.ee.optim.MultithreadedContextMappingIterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.ForEach;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;

public class MultithreadedForEach
extends ForEach {
    public MultithreadedForEach(Expression select, Expression action, boolean containsTailCall, Expression threads) {
        super(select, action, false, threads);
    }

    @Override
    public boolean isMultiThreaded(Configuration config) {
        return true;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Expression e2 = super.optimize(visitor, contextInfo);
        if (e2 != this) {
            return e2;
        }
        for (Expression e = this.getParentExpression(); e != null; e = e.getParentExpression()) {
            if (!(e instanceof LetExpression) || !ExpressionTool.dependsOnVariable(this.getAction(), new Binding[]{(LetExpression)e})) continue;
            ((LetExpression)e).setNeedsEagerEvaluation(true);
        }
        return this;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        MultithreadedForEach result = new MultithreadedForEach(this.getSelect().copy(rebindings), this.getAction().copy(rebindings), this.containsTailCall, this.getThreads());
        result.setInstruction(this.isInstruction());
        return result;
    }

    @Override
    public int getImplementationMethod() {
        return 4;
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        Receiver out = context.getReceiver();
        XPathContextMajor c2 = context.newContext();
        FocusIterator fit = c2.getController().getFocusTrackerFactory(true).apply(this.getSelect().iterate(context));
        c2.setCurrentIterator(fit);
        int maxThreads = this.evaluateThreads(context);
        if (maxThreads <= 1) {
            return super.processLeavingTail(context);
        }
        MultithreadedContextMappingIterator mapper = new MultithreadedContextMappingIterator(this.getAction(), c2, maxThreads);
        mapper.forEachOrFail(out::append);
        mapper.close();
        return null;
    }

    private int evaluateThreads(XPathContext context) throws XPathException {
        if (this.threadsOp == null) {
            return 1;
        }
        CharSequence threadsValue = this.getThreads().evaluateAsString(context);
        int threads = 0;
        try {
            threads = Integer.parseInt(threadsValue.toString());
        }
        catch (NumberFormatException e) {
            XPathException err = new XPathException("Value of 'threads' is not an integer (" + threadsValue + ")");
            err.setLocation(this.getLocation());
            err.setXPathContext(context);
            throw err;
        }
        return threads;
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext context) throws XPathException {
        int threads = this.evaluateThreads(context);
        XPathContextMinor c2 = context.newMinorContext();
        c2.trackFocus(this.getSelect().iterate(context));
        return new MultithreadedContextMappingIterator(this.getAction(), c2, threads);
    }

    @Override
    public String getExpressionName() {
        return "multithreadedForEach";
    }

    @Override
    protected void explainThreads(ExpressionPresenter out) throws XPathException {
        out.setChildRole("threads");
        this.getThreads().export(out);
    }
}

