/*
 * Decompiled with CFR 0.152.
 */
package experimental.analyzer.tagger;

import experimental.analyzer.Analyzer;
import experimental.analyzer.AnalyzerInstance;
import experimental.analyzer.AnalyzerReading;
import experimental.analyzer.AnalyzerResult;
import experimental.analyzer.AnalyzerTag;
import experimental.analyzer.AnalyzerTrainer;
import experimental.analyzer.tagger.TaggerAnalyzer;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import marmot.core.Sequence;
import marmot.morph.MorphModel;
import marmot.morph.MorphOptions;
import marmot.morph.MorphTagger;
import marmot.morph.Sentence;
import marmot.morph.Word;

public class TaggerAnalyzerTrainer
extends AnalyzerTrainer {
    public double getFscore(MorphTagger tagger, Collection<AnalyzerInstance> instances, double threshold) {
        TaggerAnalyzer analyzer = new TaggerAnalyzer(tagger, threshold);
        AnalyzerResult result2 = AnalyzerResult.test((Analyzer)analyzer, instances);
        double fscore = result2.getFscore();
        return fscore;
    }

    @Override
    public Analyzer train(Collection<AnalyzerInstance> instances) {
        LinkedList<Sequence> sentences = new LinkedList<Sequence>();
        for (AnalyzerInstance instance : instances) {
            for (AnalyzerReading reading : instance.getReadings()) {
                AnalyzerTag tag = reading.getTag();
                Word word = new Word(instance.getForm(), tag.getPosTag(), tag.getMorphTag());
                Sentence sentence = new Sentence(Collections.singletonList(word));
                sentences.add(sentence);
            }
        }
        MorphOptions options = new MorphOptions();
        options.setProperty("order", "0");
        options.setProperty("feature-templates", "affix,sig");
        options.setProperty("observed-feature", "false");
        options.setProperty("penalty", "0.0");
        if (this.options_.containsKey("float-dict")) {
            options.setProperty("type-embeddings", (String)this.options_.get("float-dict"));
        }
        MorphTagger tagger = (MorphTagger)MorphModel.train(options, sentences, null);
        double[] thresholds = new double[]{0.5, 0.45, 0.4, 0.35, 0.3, 0.25, 0.2, 0.15, 0.1, 0.05, 0.01};
        double best_threshold = 0.0;
        double best_fscore = -1.0;
        for (double threshold : thresholds) {
            double fscore = this.getFscore(tagger, instances, threshold);
            if (!(fscore > best_fscore)) continue;
            best_fscore = fscore;
            best_threshold = threshold;
        }
        System.err.println("Best threshold: " + best_threshold);
        return new TaggerAnalyzer(tagger, best_threshold);
    }
}

