/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph;

import java.text.NumberFormat;
import java.util.Locale;
import marmot.core.Model;
import marmot.core.Result;
import marmot.core.Tagger;

public class MorphResult
implements Result {
    private static final long serialVersionUID = 1L;
    public int num_sentences;
    public int sentence_errors;
    public int num_unreachable_sentences;
    public int[] rank;
    public int num_states;
    public int candidates_length;
    public int num_oovs;
    public int[] oov_errors;
    public int morph_oov_errors;
    public int[] token_errors;
    public int morph_errors;
    public int num_tokens;
    public long time;
    private Model model_;
    public long sum_lattice_time;
    public int lemma_errors;
    public int lemma_oov_errors;

    public MorphResult(Tagger tagger) {
        this(tagger.getModel(), tagger.getNumLevels());
    }

    public MorphResult(Model model, int level) {
        this.rank = new int[model.getOptions().getBeamSize()];
        this.oov_errors = new int[level];
        this.token_errors = new int[level];
        this.model_ = model;
    }

    public void increment(MorphResult eval) {
        int index;
        this.num_sentences += eval.num_sentences;
        this.sentence_errors += eval.sentence_errors;
        this.num_unreachable_sentences += eval.num_unreachable_sentences;
        this.morph_errors += eval.morph_errors;
        this.morph_oov_errors += eval.morph_oov_errors;
        this.num_states += eval.num_states;
        this.candidates_length += eval.candidates_length;
        this.num_oovs += eval.num_oovs;
        assert (this.oov_errors.length == eval.oov_errors.length);
        for (index = 0; index < eval.oov_errors.length; ++index) {
            int n = index;
            this.oov_errors[n] = this.oov_errors[n] + eval.oov_errors[index];
        }
        this.num_tokens += eval.num_tokens;
        assert (this.token_errors.length == eval.token_errors.length);
        for (index = 0; index < eval.token_errors.length; ++index) {
            int n = index;
            this.token_errors[n] = this.token_errors[n] + eval.token_errors[index];
        }
        assert (this.rank.length == eval.rank.length);
        for (index = 0; index < this.rank.length; ++index) {
            int n = index;
            this.rank[n] = this.rank[n] + eval.rank[index];
        }
        this.sum_lattice_time += eval.sum_lattice_time;
        this.lemma_errors += eval.lemma_errors;
        this.lemma_oov_errors += eval.lemma_oov_errors;
        this.time += eval.time;
    }

    public String toString() {
        NumberFormat nf2 = NumberFormat.getInstance(Locale.ENGLISH);
        StringBuilder sb = new StringBuilder();
        sb.append("Eval\n");
        sb.append(String.format("Token : %s\n", this.toString(this.token_errors, this.num_tokens)));
        sb.append(String.format("all : %s\n\n", this.toString(this.morph_errors, this.num_tokens)));
        sb.append(String.format("lemma : %s\n\n", this.toString(this.lemma_errors, this.num_tokens)));
        sb.append(String.format("OOV : %s\n", this.toString(this.oov_errors, this.num_oovs)));
        sb.append(String.format("all : %s\n\n", this.toString(this.morph_oov_errors, this.num_oovs)));
        sb.append(String.format("lemma : %s\n\n", this.toString(this.lemma_oov_errors, this.num_oovs)));
        sb.append(String.format("Sentence : %s", this.toString(this.sentence_errors, this.num_sentences)));
        for (int j : this.rank) {
            sb.append(' ');
            sb.append(nf2.format((double)j * 100.0 / (double)this.num_sentences));
            sb.append('%');
        }
        sb.append('\n');
        if (this.num_unreachable_sentences > 0) {
            sb.append(String.format("Unreachable : %s\n", this.toString(this.num_sentences - this.num_unreachable_sentences, this.num_sentences)));
        }
        if (this.candidates_length > 0) {
            sb.append(String.format("Candidates / Position : %s\n", (double)this.num_states / (double)this.candidates_length));
        }
        if (this.time > 1000L) {
            System.err.format("Processed %d sentences at %g sentences/s\n", this.num_sentences, (double)this.num_sentences / ((double)this.time / 1000.0));
        }
        if (this.sum_lattice_time > 500L) {
            System.err.format("Lattice time: %gs\n", (double)this.sum_lattice_time / 1000.0);
        }
        if (this.time - this.sum_lattice_time > 500L) {
            System.err.format("Viterbi time: %gs\n", (double)(this.time - this.sum_lattice_time) / 1000.0);
        }
        return sb.toString();
    }

    private String toString(int[] error, int total) {
        StringBuilder sb = new StringBuilder("\n");
        for (int index = 0; index < error.length; ++index) {
            String key = this.model_.getCategoryTable().toSymbol(index);
            sb.append(key);
            sb.append(": ");
            sb.append(this.toString(error[index], total));
            if (index >= error.length - 1) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    private String toString(int error, int total) {
        int correct = total - error;
        return String.format("%d / %d = %g%%", correct, total, (double)correct * 100.0 / (double)total);
    }

    public double getTokenAccuracy() {
        return 100.0 - (double)this.morph_errors * 100.0 / (double)this.num_tokens;
    }

    public double getOovTokenAccuracy() {
        return 100.0 - (double)this.morph_oov_errors * 100.0 / (double)this.num_oovs;
    }

    @Override
    public double getScore() {
        return this.getTokenAccuracy();
    }
}

