/*
 * Decompiled with CFR 0.152.
 */
package marmot.test.util;

import java.util.Random;
import marmot.util.Copy;
import marmot.util.Encoder;
import org.junit.Assert;
import org.junit.Test;

public class EncoderTest {
    @Test
    public void testBitsNeeded() {
        Assert.assertEquals((long)1L, (long)Encoder.bitsNeeded(0));
        Assert.assertEquals((long)1L, (long)Encoder.bitsNeeded(1));
        Assert.assertEquals((long)2L, (long)Encoder.bitsNeeded(2));
        Assert.assertEquals((long)2L, (long)Encoder.bitsNeeded(3));
        Assert.assertEquals((long)3L, (long)Encoder.bitsNeeded(4));
        Assert.assertEquals((long)3L, (long)Encoder.bitsNeeded(5));
        Assert.assertEquals((long)3L, (long)Encoder.bitsNeeded(6));
        Assert.assertEquals((long)3L, (long)Encoder.bitsNeeded(7));
        Assert.assertEquals((long)4L, (long)Encoder.bitsNeeded(8));
        for (int i = 0; i < 1000; ++i) {
            int expected_num_bits = Integer.toBinaryString(i).length();
            Assert.assertEquals((long)expected_num_bits, (long)Encoder.bitsNeeded(i));
        }
    }

    @Test
    public void testStoreState() {
        Random random = new Random(42L);
        for (int trial = 0; trial < 10; ++trial) {
            Encoder encoder = new Encoder(6);
            this.randomAppend(random, encoder, 100, 15);
            Encoder copy = Copy.clone(encoder);
            encoder.storeState();
            for (int append_trial = 0; append_trial < 10; ++append_trial) {
                this.randomAppend(random, encoder, 100, 15);
                encoder.restoreState();
                System.err.println(copy);
                System.err.println(encoder);
                Assert.assertEquals((Object)copy, (Object)encoder);
            }
        }
    }

    private void randomAppend(Random random, Encoder encoder, int max_max_value, int max_num_append) {
        int num_appends = random.nextInt(max_num_append + 1);
        for (int i = 0; i < num_appends; ++i) {
            int max_value = random.nextInt(max_max_value + 1);
            int value = random.nextInt(max_value + 1);
            encoder.append(value, Encoder.bitsNeeded(max_value));
        }
    }
}

