/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.WatchMaker;
import com.saxonica.ee.stream.watch.WatchManager;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.SimpleStepExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.UserFunctionParameter;
import net.sf.saxon.pattern.AncestorQualifiedPattern;
import net.sf.saxon.pattern.AnchorPattern;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;

public abstract class TransmissionAdjunct
extends StreamingAdjunct
implements FeedMaker {
    @Override
    public WatchMaker getWatchMaker(boolean forGrouping) throws XPathException {
        Posture posture = Streamability.getPosture(this.getExpression());
        if (posture.isIncremental()) {
            return new WatchMaker(){

                @Override
                public Trigger makeWatch(WatchManager watchManager, Feed out, XPathContext context) throws XPathException {
                    return TransmissionAdjunct.this.makeTransmissionFlow(watchManager, TransmissionAdjunct.this.getExpression(), out, context);
                }
            };
        }
        return null;
    }

    public Trigger makeTransmissionFlow(WatchManager watchManager, Expression exp, Feed out, XPathContext context) throws XPathException {
        SimpleStepExpression sse;
        Expression lhs;
        Expression select = null;
        for (Operand o : exp.operands()) {
            if (Streamability.getSweep(o.getChildExpression()) != Sweep.CONSUMING || !o.hasSameFocus()) continue;
            select = o.getChildExpression();
            break;
        }
        if (select == null) {
            for (Operand o : exp.operands()) {
                if (!o.hasSameFocus() || o.getUsage() != OperandUsage.TRANSMISSION) continue;
                select = o.getChildExpression();
                break;
            }
        }
        Pattern selection = null;
        if (select == null && exp instanceof SimpleStepExpression && (lhs = (sse = (SimpleStepExpression)exp).getLhsExpression()) instanceof LocalVariableReference && ((LocalVariableReference)lhs).getBinding() instanceof UserFunctionParameter) {
            AxisExpression ae = (AxisExpression)sse.getRhsExpression();
            byte axis = ae.getAxis();
            if (axis == 3) {
                selection = new AncestorQualifiedPattern(new NodeTestPattern(ae.getNodeTest()), AnchorPattern.getInstance(), 9);
            } else if (axis == 4) {
                selection = new AncestorQualifiedPattern(new NodeTestPattern(ae.getNodeTest()), AnchorPattern.getInstance(), 0);
            }
        }
        if (select == null && selection == null) {
            throw new XPathException("No transmission watch for " + exp.toShortString(), "SXST0067", exp.getLocation());
        }
        if (select != null && selection == null) {
            selection = Streamability.toStreamingPattern(select, context.getConfiguration());
        }
        Feed fw = this.makeItemFeed(watchManager, out, context);
        if (selection != null) {
            return new Trigger(selection, fw, context);
        }
        StreamingAdjunct sa = StreamingAdjunct.makeStreamingAdjunct(this.getConfiguration(), select);
        if (sa instanceof TransmissionAdjunct) {
            return ((TransmissionAdjunct)sa).makeTransmissionFlow(watchManager, select, fw, context);
        }
        throw new XPathException("No transmission filter available for " + select.toShortString(), "SXST0067", exp.getLocation());
    }
}

