/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.store.BaseDirectory;
import org.apache.lucene.store.FSLockFactory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.OutputStreamIndexOutput;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.IOUtils;

public abstract class FSDirectory
extends BaseDirectory {
    protected final Path directory;

    protected FSDirectory(Path path, LockFactory lockFactory) throws IOException {
        super(lockFactory);
        Files.createDirectories(path, new FileAttribute[0]);
        this.directory = path.toRealPath(new LinkOption[0]);
    }

    public static FSDirectory open(Path path) throws IOException {
        return FSDirectory.open(path, FSLockFactory.getDefault());
    }

    public static FSDirectory open(Path path, LockFactory lockFactory) throws IOException {
        if (Constants.JRE_IS_64BIT && MMapDirectory.UNMAP_SUPPORTED) {
            return new MMapDirectory(path, lockFactory);
        }
        if (Constants.WINDOWS) {
            return new SimpleFSDirectory(path, lockFactory);
        }
        return new NIOFSDirectory(path, lockFactory);
    }

    public static String[] listAll(Path dir) throws IOException {
        ArrayList<String> entries = new ArrayList<String>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                return !Files.isDirectory(entry, new LinkOption[0]);
            }
        });){
            for (Path path : stream) {
                entries.add(path.getFileName().toString());
            }
        }
        return entries.toArray(new String[entries.size()]);
    }

    @Override
    public String[] listAll() throws IOException {
        this.ensureOpen();
        return FSDirectory.listAll(this.directory);
    }

    @Override
    public long fileLength(String name) throws IOException {
        this.ensureOpen();
        return Files.size(this.directory.resolve(name));
    }

    @Override
    public void deleteFile(String name) throws IOException {
        this.ensureOpen();
        Files.delete(this.directory.resolve(name));
    }

    @Override
    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        this.ensureCanWrite(name);
        return new FSIndexOutput(name);
    }

    protected void ensureCanWrite(String name) throws IOException {
        Files.deleteIfExists(this.directory.resolve(name));
    }

    @Override
    public void sync(Collection<String> names) throws IOException {
        this.ensureOpen();
        for (String name : names) {
            this.fsync(name);
        }
    }

    @Override
    public void renameFile(String source, String dest) throws IOException {
        this.ensureOpen();
        Files.move(this.directory.resolve(source), this.directory.resolve(dest), StandardCopyOption.ATOMIC_MOVE);
        IOUtils.fsync(this.directory, true);
    }

    @Override
    public synchronized void close() {
        this.isOpen = false;
    }

    public Path getDirectory() {
        this.ensureOpen();
        return this.directory;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "@" + this.directory + " lockFactory=" + this.lockFactory;
    }

    protected void fsync(String name) throws IOException {
        IOUtils.fsync(this.directory.resolve(name), false);
    }

    final class FSIndexOutput
    extends OutputStreamIndexOutput {
        static final int CHUNK_SIZE = 8192;

        public FSIndexOutput(String name) throws IOException {
            super("FSIndexOutput(path=\"" + FSDirectory.this.directory.resolve(name) + "\")", new FilterOutputStream(Files.newOutputStream(FSDirectory.this.directory.resolve(name), new OpenOption[0])){

                @Override
                public void write(byte[] b, int offset, int length) throws IOException {
                    while (length > 0) {
                        int chunk = Math.min(length, 8192);
                        this.out.write(b, offset, chunk);
                        length -= chunk;
                        offset += chunk;
                    }
                }
            }, 8192);
        }
    }
}

