/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korapxmltools;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lde/ids_mannheim/korapxmltools/ColoredFormatter;", "Ljava/util/logging/Formatter;", "<init>", "()V", "format", "", "record", "Ljava/util/logging/LogRecord;", "Companion", "app"})
public final class ColoredFormatter
extends Formatter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final DateTimeFormatter dateTimeFormatter;
    @NotNull
    private static final String ANSI_RESET = "\u001b[0m";
    @NotNull
    private static final String ANSI_RED = "\u001b[31m";
    @NotNull
    private static final String ANSI_GREEN = "\u001b[32m";
    @NotNull
    private static final String ANSI_YELLOW = "\u001b[33m";

    @Override
    @NotNull
    public String format(@NotNull LogRecord record) {
        Intrinsics.checkNotNullParameter(record, "record");
        String color = "";
        Level level = record.getLevel();
        if (Intrinsics.areEqual(level, Level.SEVERE)) {
            color = ANSI_RED;
        } else if (Intrinsics.areEqual(level, Level.INFO)) {
            color = ANSI_GREEN;
        } else if (Intrinsics.areEqual(level, Level.WARNING)) {
            color = ANSI_YELLOW;
        }
        String string = dateTimeFormatter.format(Instant.now());
        String string2 = record.getLevel().getName();
        Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
        return color + string + " [" + StringsKt.padStart$default(string2, 7, '\u0000', 2, null) + "] " + this.formatMessage(record) + "\u001b[0m\n";
    }

    static {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd' 'HH:mm:ss").withZone(ZoneId.systemDefault());
        Intrinsics.checkNotNullExpressionValue(dateTimeFormatter, "withZone(...)");
        ColoredFormatter.dateTimeFormatter = dateTimeFormatter;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lde/ids_mannheim/korapxmltools/ColoredFormatter$Companion;", "", "<init>", "()V", "dateTimeFormatter", "Ljava/time/format/DateTimeFormatter;", "ANSI_RESET", "", "ANSI_RED", "ANSI_GREEN", "ANSI_YELLOW", "app"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

