/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.namefind;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.formats.NameFinderCensus90NameStream;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.StringList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CensusDictionaryCreatorTool
extends BasicCmdLineTool {
    private static final Logger logger = LoggerFactory.getLogger(CensusDictionaryCreatorTool.class);

    @Override
    public String getShortDescription() {
        return "Converts 1990 US Census names into a dictionary";
    }

    @Override
    public String getHelp() {
        return this.getBasicHelp((Class<?>)Parameters.class);
    }

    public static Dictionary createDictionary(ObjectStream<StringList> sampleStream) throws IOException {
        Dictionary mNameDictionary = new Dictionary(true);
        StringList entry = sampleStream.read();
        while (entry != null) {
            if (!mNameDictionary.contains(entry)) {
                mNameDictionary.put(entry);
            }
            entry = sampleStream.read();
        }
        return mNameDictionary;
    }

    @Override
    public void run(String[] args2) {
        Dictionary mDictionary;
        Parameters params = this.validateAndParseParams(args2, Parameters.class);
        File testData = new File(params.getCensusData());
        File dictOutFile = new File(params.getDict());
        CmdLineUtil.checkInputFile("Name data", testData);
        CmdLineUtil.checkOutputFile("Dictionary file", dictOutFile);
        InputStreamFactory sampleDataIn = CmdLineUtil.createInputStreamFactory(testData);
        try (NameFinderCensus90NameStream sampleStream = new NameFinderCensus90NameStream(sampleDataIn, Charset.forName(params.getEncoding()));){
            logger.info("Creating Dictionary...");
            mDictionary = CensusDictionaryCreatorTool.createDictionary(sampleStream);
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + e.getMessage(), e);
        }
        logger.info("Saving Dictionary...");
        try (FileOutputStream out = new FileOutputStream(dictOutFile);){
            mDictionary.serialize(out);
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while writing dictionary file: " + e.getMessage(), e);
        }
    }

    static interface Parameters {
        @ArgumentParser.ParameterDescription(valueName="code")
        @ArgumentParser.OptionalParameter(defaultValue="eng")
        public String getLang();

        @ArgumentParser.ParameterDescription(valueName="charsetName")
        @ArgumentParser.OptionalParameter(defaultValue="UTF-8")
        public String getEncoding();

        @ArgumentParser.ParameterDescription(valueName="censusDict")
        public String getCensusData();

        @ArgumentParser.ParameterDescription(valueName="dict")
        public String getDict();
    }
}

