/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.ee.schema.Facet;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.UserListType;
import com.saxonica.ee.schema.UserSimpleType;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.CallableDelegate;
import net.sf.saxon.expr.sort.SimpleTypeComparison;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.str.BMPString;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public class OrderFacet
extends Facet {
    private boolean ascending;

    @Override
    public String getName() {
        return "order";
    }

    @Override
    public UnicodeString getValue() {
        String base = this.ascending ? "ascending" : "descending";
        return BMPString.of(base);
    }

    public void setValue(String value) throws SchemaException {
        switch (value) {
            case "ascending": {
                this.ascending = true;
                break;
            }
            case "descending": {
                this.ascending = false;
                break;
            }
            default: {
                throw new SchemaException("Value of saxon:order facet must be ascending or descending");
            }
        }
    }

    @Override
    public void checkFacetRestriction(UserSimpleType type, SimpleType base, SchemaCompiler compiler) throws SchemaException {
        if (base instanceof UserListType) {
            UserListType ubase = (UserListType)base;
            OrderFacet baseFacet = (OrderFacet)ubase.getFacet(OrderFacet.class);
            if (baseFacet != null && baseFacet.ascending != this.ascending) {
                throw new SchemaException("The saxon:order facet cannot be varied in a restricted type");
            }
        } else {
            throw new SchemaException("The saxon:order facet is allowed only on list types");
        }
    }

    @Override
    public boolean testAtomicValue(AtomicValue value) {
        return true;
    }

    @Override
    public boolean testListValue(AtomicSequence value) {
        AtomicValue latest = null;
        if (this.ascending) {
            for (AtomicValue atom : value) {
                if (latest != null && SimpleTypeComparison.getInstance().compareItems(latest, atom) > 0) {
                    return false;
                }
                latest = atom;
            }
        } else {
            for (AtomicValue atom : value) {
                if (latest != null && SimpleTypeComparison.getInstance().compareItems(latest, atom) < 0) {
                    return false;
                }
                latest = atom;
            }
        }
        return true;
    }

    @Override
    public FunctionItem getFacetAsFunctionItem() {
        OrderFacet facet = this;
        CallableDelegate callable = new CallableDelegate((context, arguments) -> {
            String key;
            switch (key = arguments[0].head().getStringValue()) {
                case "class": {
                    return new StringValue(this.getName());
                }
                case "implementation": {
                    return new ObjectValue<OrderFacet>(facet);
                }
                case "value": {
                    return new StringValue(this.getValue());
                }
                case "fixed": {
                    return BooleanValue.get(this.isFixed());
                }
            }
            return EmptySequence.getInstance();
        });
        return new CallableFunction(1, (Callable)callable, SpecificFunctionType.COMPONENT_FUNCTION_TYPE);
    }
}

