/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.serialize;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;

public class AttributeSorter
extends ProxyReceiver {
    private Map<NodeName, Integer> knownAttributes;
    private static final int MIDDLE_GROUND = 10000000;

    public AttributeSorter(Receiver next) {
        super(next);
    }

    public void setOutputProperties(Properties details) {
        String attOrder;
        if ("yes".equals(details.getProperty("{http://saxon.sf.net/}canonical"))) {
            attOrder = "";
        } else {
            attOrder = details.getProperty("{http://saxon.sf.net/}attribute-order");
            if (attOrder == null) {
                attOrder = "";
            }
        }
        this.knownAttributes = new HashMap<NodeName, Integer>();
        int pos = 0;
        StringTokenizer st2 = new StringTokenizer(attOrder, " \t\n\r", false);
        while (st2.hasMoreTokens()) {
            String expandedName = st2.nextToken();
            if (expandedName.equals("*")) {
                pos += 10000000;
                continue;
            }
            StructuredQName sq = StructuredQName.fromClarkName(expandedName);
            this.knownAttributes.put(new FingerprintedQName("", sq.getNamespaceUri(), sq.getLocalPart()), pos++);
        }
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributesIn, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        if (attributesIn.size() <= 1) {
            this.nextReceiver.startElement(elemName, type, attributesIn, namespaces, location, properties);
        } else {
            ArrayList<AttributeInfo> attributes = attributesIn.asList();
            attributes.sort((a, b) -> {
                NodeName n0 = a.getNodeName();
                NodeName n1 = b.getNodeName();
                int r0 = this.knownAttributes.getOrDefault(n0, Integer.MIN_VALUE);
                int r1 = this.knownAttributes.getOrDefault(n1, Integer.MIN_VALUE);
                if (r0 != Integer.MIN_VALUE) {
                    if (r1 == Integer.MIN_VALUE) {
                        return Integer.compare(r0, 10000000);
                    }
                    return Integer.compare(r0, r1);
                }
                if (r1 != Integer.MIN_VALUE) {
                    return Integer.compare(10000000, r1);
                }
                int x = n0.getNamespaceUri().toString().compareTo(n1.getNamespaceUri().toString());
                if (x == 0) {
                    x = n0.getLocalPart().compareTo(n1.getLocalPart());
                }
                return x;
            });
            AttributeMap sorted = SequenceTool.attributeMapFromList(attributes);
            this.nextReceiver.startElement(elemName, type, sorted, namespaces, location, properties);
        }
    }
}

