/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.ee.schema.AttributeGroupReference;
import com.saxonica.ee.schema.AttributeUse;
import com.saxonica.ee.schema.AttributeWildcard;
import com.saxonica.ee.schema.ElementParticle;
import com.saxonica.ee.schema.ElementWildcard;
import com.saxonica.ee.schema.ModelGroupParticle;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SingleNamespaceSchema;
import com.saxonica.ee.schema.TypeReference;
import com.saxonica.ee.schema.UserComplexType;
import com.saxonica.ee.schema.UserDefinedType;
import com.saxonica.ee.schema.Wildcard;
import com.saxonica.ee.schema.sdoc.SchemaDocument;
import com.saxonica.ee.schema.sdoc.SchemaElement;
import com.saxonica.ee.schema.sdoc.SimpleTypeDefinition;
import com.saxonica.ee.schema.sdoc.XSDAnyAttribute;
import com.saxonica.ee.schema.sdoc.XSDAssert;
import com.saxonica.ee.schema.sdoc.XSDAttribute;
import com.saxonica.ee.schema.sdoc.XSDAttributeGroup;
import com.saxonica.ee.schema.sdoc.XSDComplexContent;
import com.saxonica.ee.schema.sdoc.XSDCompositor;
import com.saxonica.ee.schema.sdoc.XSDElement;
import com.saxonica.ee.schema.sdoc.XSDGroup;
import com.saxonica.ee.schema.sdoc.XSDOpenContent;
import com.saxonica.ee.schema.sdoc.XSDOverride;
import com.saxonica.ee.schema.sdoc.XSDRedefine;
import com.saxonica.ee.schema.sdoc.XSDSchema;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.Whitespace;

public class XSDComplexType
extends SchemaElement {
    Boolean mixed;
    boolean defaultAttributesApply = true;
    private boolean isRedefinition;
    private UserComplexType complexType = null;
    private static final int[] state0terms = new int[]{586, 619, 582, 612, 578, 585, 580, 620, 576, 584, 596, 587};
    private static final int[] state0targets = new int[]{3, 3, 7, 5, 6, 1, 4, 2, 3, 1, 3, 2};
    private static final int[] state1terms = new int[]{584, 585, 580, 582};
    private static final int[] state1targets = new int[]{1, 1, 4, 7};
    private static final int[] state2terms = new int[0];
    private static final int[] state2targets = new int[0];
    private static final int[] state3terms = new int[]{584, 585, 580, 582};
    private static final int[] state3targets = new int[]{1, 1, 4, 7};
    private static final int[] state4terms = new int[]{582};
    private static final int[] state4targets = new int[]{7};
    private static final int[] state5terms = new int[]{584, 596, 586, 585, 576, 580, 619, 582};
    private static final int[] state5targets = new int[]{1, 3, 3, 1, 3, 4, 3, 7};
    private static final int[] state6terms = new int[]{586, 619, 582, 612, 585, 580, 620, 576, 584, 596, 587};
    private static final int[] state6targets = new int[]{3, 3, 7, 5, 1, 4, 2, 3, 1, 3, 2};
    private static final int[] state7terms = new int[]{582};
    private static final int[] state7targets = new int[]{7};
    private static final int[][] stateTerms = new int[][]{state0terms, state1terms, state2terms, state3terms, state4terms, state5terms, state6terms, state7terms};
    private static final int[][] stateTargets = new int[][]{state0targets, state1targets, state2targets, state3targets, state4targets, state5targets, state6targets, state7targets};

    @Override
    public void prepareAttributes() throws SchemaException {
        String blockVal;
        String[] allowed;
        SingleNamespaceSchema schema = this.getSchema();
        this.complexType = new UserComplexType(schema.getConfiguration(), this);
        this.complexType.setSchemaDocumentURI(this.getParent().getSystemId());
        this.isRedefinition = this.getParent() instanceof XSDRedefine;
        AttributeCollection atts = this.getAttributeList();
        if (this.isTopLevel()) {
            allowed = new String[]{"abstract", "block", "defaultAttributesApply", "final", "id", "mixed", "name"};
            this.allowAttributes(atts, allowed);
            this.requireAttribute(atts, "name");
        } else {
            allowed = new String[]{"defaultAttributesApply", "id", "mixed"};
            this.allowAttributes(atts, allowed);
        }
        String debug = atts.getValue("http://saxon.sf.net/", "debug");
        if (debug != null && ("true".equals(debug = Whitespace.trim(debug)) || "1".equals(debug))) {
            this.complexType.setSaxonDebug(true);
        }
        this.processId();
        String attValue = Whitespace.trim(atts.getValue("", "name"));
        if (attValue != null) {
            StructuredQName typeName;
            try {
                typeName = this.getComponentName(attValue, 1);
            }
            catch (SchemaException err) {
                typeName = StandardNames.SQ_XS_INVALID_NAME;
                attValue = "invalid-complex-type-definition-" + this.hashCode();
                this.error(err.getMessage());
            }
            int fp = this.getNamePool().allocateFingerprint(typeName.getURI(), typeName.getLocalPart());
            this.complexType.setTypeName(typeName, fp);
            if (!this.isRedefinition && schema.getSchemaType(this.complexType.getStructuredQName()) != null && fp > 1023) {
                this.duplicate("type", attValue);
            }
        } else {
            NodeName nc = this.allocateAnonymousTypeCode();
            this.complexType.setTypeName(nc.getStructuredQName(), nc.getFingerprint());
            schema.addAnonymousType(this.complexType);
        }
        String mixedAtt = Whitespace.trim(atts.getValue("", "mixed"));
        if (mixedAtt != null) {
            this.mixed = this.parseBooleanAttribute("mixed", mixedAtt);
        }
        if ((attValue = atts.getValue("", "abstract")) != null) {
            boolean isAbstract = this.parseBooleanAttribute("abstract", attValue);
            this.complexType.setAbstract(isAbstract);
        }
        if ((blockVal = atts.getValue("", "block")) == null) {
            this.complexType.setFinalProhibitions(this.getXSDSchema().getBlockDefault());
        } else {
            int f = this.parseFinalOrBlock("block", blockVal, 3);
            this.complexType.setBlock(f);
        }
        String finalVal = atts.getValue("", "final");
        if (finalVal == null) {
            this.complexType.setFinalProhibitions(this.getXSDSchema().getFinalDefault());
        } else {
            int f = this.parseFinalOrBlock("final", finalVal, 3);
            this.complexType.setFinalProhibitions(f);
        }
        String applyAtt = Whitespace.trim(atts.getValue("", "defaultAttributesApply"));
        if (applyAtt != null) {
            if (applyAtt.equals("true") || applyAtt.equals("1")) {
                this.defaultAttributesApply = true;
            } else if (applyAtt.equals("false") || applyAtt.equals("0")) {
                this.defaultAttributesApply = false;
            } else {
                this.invalidAttributeValue("defaultAttributesApply", applyAtt, "Must be true or false");
            }
        }
    }

    public UserComplexType getComplexType() {
        return this.complexType;
    }

    @Override
    public void validate(SchemaCompiler compiler) throws SchemaException {
        NodeImpl child;
        this.checkContentModel(stateTerms, stateTargets, false);
        boolean foundSimpleContent = false;
        boolean foundComplexContent = false;
        boolean thisMixed = this.mixed != null && this.mixed != false;
        this.complexType.setVariety(thisMixed ? 3 : 2);
        AxisIterator iter = this.iterateAxis((byte)3);
        while ((child = (NodeImpl)iter.next()) != null) {
            int fp = child.getFingerprint();
            if (fp == 620) {
                foundSimpleContent = true;
                this.complexType.setVariety(1);
                if (!thisMixed || compiler.getLanguageVersion() != 11) continue;
                this.error("The <complexType> must not specify mixed='true' when <simpleContent> is present");
                continue;
            }
            if (fp == 587) {
                foundComplexContent = true;
                Boolean ccMixed = ((XSDComplexContent)child).getMixedAttribute();
                if (compiler.getLanguageVersion() == 11 && this.mixed != null && ccMixed != null && !this.mixed.equals(ccMixed)) {
                    this.error("If mixed is specified on both <complexType> and <complexContent>, they must agree");
                }
                boolean eitherMixed = thisMixed || ccMixed != null && ccMixed != false;
                this.complexType.setVariety(eitherMixed ? 3 : 2);
                continue;
            }
            if (fp == 582) {
                if (compiler.getLanguageVersion() != 10) continue;
                this.error("Assertions require XSD 1.1 to be enabled");
                continue;
            }
            if (fp != 612 || compiler.getLanguageVersion() != 10) continue;
            this.error("Open content requires XSD 1.1 to be enabled");
        }
        if (this.isRedefinition && !foundSimpleContent && !foundComplexContent) {
            this.error("A redefined complex type must be derived by extension or restriction");
        }
    }

    @Override
    protected boolean isFinalState(int state) {
        return true;
    }

    @Override
    public void postValidate(SchemaCompiler compiler) throws SchemaException {
        if (this.isRedefinition) {
            TypeReference simpleTypeRef;
            SimpleType simpleType;
            SingleNamespaceSchema externalSchema = ((XSDRedefine)this.getParent()).getExternalSchema();
            SingleNamespaceSchema redefinedSchema = ((XSDRedefine)this.getParent()).getRedefinedSchema();
            if (this.complexType.getBaseTypeFingerprint() != this.complexType.getFingerprint()) {
                this.error("A redefined complex type must be based on the type with the same name");
            }
            if (externalSchema == null) {
                return;
            }
            UserDefinedType oldType = (UserDefinedType)externalSchema.getSchemaType(this.complexType.getStructuredQName());
            if (oldType == null) {
                this.error("Cannot redefine complex type " + Err.wrap(this.complexType.getName()) + " because it is not present in the redefined schema");
                return;
            }
            if (oldType instanceof SimpleType) {
                this.error("Cannot redefine a simple type " + Err.wrap(this.complexType.getName()) + "as a complex type");
            }
            if (!((XSDRedefine)this.getParent()).getExternalSchemaDocumentURI().equals(oldType.getSchemaDocumentURI())) {
                compiler.warning("The redefined complex type was found, but not in the schema document referenced by the schemaLocation attribute of the containing <xs:redefine> element. This is not allowed by the XSD specification. However, Saxon does not currently enforce this rule.", this);
            }
            this.complexType.setRedefinitionLevel(oldType.getRedefinitionLevel() + 1);
            String uri = this.getXSDSchema().getTargetNamespace();
            NamePool pool = this.getNamePool();
            String localName = pool.getLocalName(this.complexType.getFingerprint());
            String newLocalName = localName + '_' + this.complexType.hashCode();
            String prefix = this.complexType.getStructuredQName().getPrefix();
            int newFingerprint = pool.allocateFingerprint(uri, newLocalName);
            oldType.setTypeName(new StructuredQName(prefix, uri, newLocalName), newFingerprint);
            TypeReference baseType = new TypeReference(newFingerprint, this.complexType.getConfiguration(), this);
            this.complexType.setBaseTypeReference(baseType);
            redefinedSchema.addType(oldType);
            redefinedSchema.addType(this.complexType);
            if (this.complexType.isSimpleContent() && (simpleType = (SimpleType)(simpleTypeRef = this.complexType.getSimpleContentTypeReference()).getTarget()) instanceof SimpleTypeDefinition) {
                ((SimpleTypeDefinition)simpleType).setBaseTypeReference(baseType);
                redefinedSchema.addType(simpleType);
            }
        } else {
            if (this.complexType.getBaseTypeReference() == null) {
                TypeReference ref = new TypeReference(572, this.complexType.getConfiguration(), this);
                ref.setTarget(AnyType.getInstance());
                this.complexType.setBaseTypeReference(ref);
            }
            if (this.complexType.getBaseTypeFingerprint() == this.complexType.getFingerprint() && this.complexType.getFingerprint() != 572) {
                this.error("A complex type must not be based on itself");
            }
        }
        this.assembleParticles();
    }

    private void assembleParticles() throws SchemaException {
        NodeImpl child;
        XSDSchema schemaDefiningDefaults;
        Wildcard openContentWildcard = null;
        String openContentMode = null;
        if (this.getParent() instanceof XSDOverride) {
            SchemaDocument original = ((XSDOverride)this.getParent()).getOriginalSchemaDocument();
            schemaDefiningDefaults = original.getXSDSchema();
        } else {
            schemaDefiningDefaults = this.getXSDSchema();
        }
        AttributeGroupReference defaultAttributes = schemaDefiningDefaults.getDefaultAttributeGroupReference();
        if (defaultAttributes != null && this.defaultAttributesApply) {
            this.complexType.addAttributeGroupReference(defaultAttributes);
        }
        AxisIterator iter = this.iterateAxis((byte)3);
        while ((child = (NodeImpl)iter.next()) != null) {
            switch (child.getFingerprint()) {
                case 580: {
                    AttributeWildcard wildcard = ((XSDAnyAttribute)child).getWildcard();
                    this.complexType.setAnyAttribute(wildcard);
                    break;
                }
                case 584: {
                    AttributeUse attrDecl = ((XSDAttribute)child).getAttributeUse();
                    this.complexType.addAttributeUse(attrDecl);
                    break;
                }
                case 585: {
                    AttributeGroupReference attrGroupRef = ((XSDAttributeGroup)child).getAttributeGroupReference();
                    this.complexType.addAttributeGroupReference(attrGroupRef);
                    break;
                }
                case 591: {
                    ElementParticle element = ((XSDElement)child).getElementParticle();
                    this.complexType.setParticle(element);
                    break;
                }
                case 596: {
                    ModelGroupParticle modelGroup = ((XSDGroup)child).getGroupReference();
                    this.complexType.setParticle(modelGroup);
                    break;
                }
                case 620: {
                    break;
                }
                case 587: {
                    openContentWildcard = this.complexType.getOpenContentWildcard();
                    openContentMode = this.complexType.getOpenContentModeString();
                    break;
                }
                case 576: 
                case 586: 
                case 619: {
                    this.complexType.setParticle(((XSDCompositor)child).getModelGroupParticle());
                    break;
                }
                case 582: {
                    this.complexType.addAssertion(((XSDAssert)child).getAssertion());
                    break;
                }
                case 578: {
                    break;
                }
                case 612: {
                    ElementWildcard ew = ((XSDOpenContent)child).getElementWildcard();
                    openContentWildcard = ew == null ? null : ew.getWildcard();
                    openContentMode = ((XSDOpenContent)child).getMode();
                    break;
                }
            }
        }
        if (openContentWildcard != null) {
            this.complexType.setOpenContentWildcard(openContentWildcard, openContentMode, true);
        } else if (schemaDefiningDefaults.getDefaultOpenContentWildcard() != null && !"none".equals(openContentMode)) {
            this.complexType.setOpenContentWildcard(schemaDefiningDefaults.getDefaultOpenContentWildcard(), schemaDefiningDefaults.getDefaultOpenContentMode(), schemaDefiningDefaults.defaultOpenContentAppliesToEmpty());
        }
    }
}

