/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.om;

import com.saxonica.ee.stream.om.FleetingElementNode;
import com.saxonica.ee.stream.om.FleetingNode;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;

final class AttributeIterator
implements AxisIterator,
LookaheadIterator<NodeInfo> {
    private FleetingElementNode element;
    private AttributeCollection attributes;
    private NodeTest nodeTest;
    private FleetingNode next;
    private int index;
    private int length;

    public AttributeIterator(FleetingElementNode element, AttributeCollection attributes, NodeTest nodeTest) {
        this.nodeTest = nodeTest;
        if (element.getNodeKind() == 1) {
            this.element = element;
            this.attributes = attributes;
            this.index = 0;
            if (nodeTest instanceof NameTest) {
                NameTest test = (NameTest)nodeTest;
                this.index = attributes.getIndexByFingerprint(test.getFingerprint());
                if (this.index < 0) {
                    this.next = null;
                } else {
                    this.next = AttributeIterator.makeAttributeNode(element, attributes, this.index);
                    this.index = 0;
                    this.length = 0;
                }
            } else {
                this.index = 0;
                this.length = attributes.getLength();
                this.advance();
            }
        } else {
            this.next = null;
            this.index = 0;
            this.length = 0;
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public NodeInfo next() {
        if (this.next == null) {
            return null;
        }
        FleetingNode current = this.next;
        this.advance();
        return current;
    }

    private void advance() {
        do {
            if (this.index >= this.length) {
                this.next = null;
                return;
            }
            this.next = AttributeIterator.makeAttributeNode(this.element, this.attributes, this.index);
            ++this.index;
        } while (!this.nodeTest.matchesNode(this.next));
    }

    @Override
    public int getProperties() {
        return 4;
    }

    private static FleetingNode makeAttributeNode(FleetingElementNode element, AttributeCollection attributes, int index) {
        FleetingNode attr = new FleetingNode();
        attr.setParent(element);
        attr.setNodeKind(2);
        attr.setNodeName(attributes.getNodeName(index));
        attr.setTypeAnnotation(attributes.getTypeAnnotation(index));
        attr.setStringValue(attributes.getValue(index));
        return attr;
    }
}

