/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.update;

import com.saxonica.ee.update.BasicUpdatingExpression;
import com.saxonica.ee.update.PendingUpdateListImpl;
import com.saxonica.ee.update.RenameAction;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class RenameExpression
extends BasicUpdatingExpression {
    private NamespaceResolver nsContext;
    private String defaultNamespace;
    private Operand nameOp;
    private Operand targetOp;

    public RenameExpression(Expression target, Expression name, NamespaceResolver nsContext, String defaultNamespace) {
        this.nameOp = new Operand(this, name, OperandRole.SINGLE_ATOMIC);
        this.targetOp = new Operand(this, target, OperandRole.INSPECT);
        this.nsContext = nsContext;
        this.defaultNamespace = defaultNamespace == null ? "" : defaultNamespace;
    }

    public Expression getTargetExp() {
        return this.targetOp.getChildExpression();
    }

    public void setTargetExp(Expression targetExpression) {
        this.targetOp.setChildExpression(targetExpression);
    }

    public Expression getNameExp() {
        return this.nameOp.getChildExpression();
    }

    public void setNameExp(Expression nameExpression) {
        this.nameOp.setChildExpression(nameExpression);
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(this.targetOp, this.nameOp);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        TypeChecker tc = visitor.getConfiguration().getTypeChecker(false);
        RoleDiagnostic role0 = new RoleDiagnostic(10, "insert", 1);
        role0.setErrorCode("XUDY0027");
        this.setTargetExp(tc.staticTypeCheck(this.getTargetExp(), SequenceType.NON_EMPTY_SEQUENCE, role0, visitor));
        role0 = new RoleDiagnostic(10, "rename", 0);
        role0.setErrorCode("XUTY0012");
        this.setTargetExp(tc.staticTypeCheck(this.getTargetExp(), SequenceType.OPTIONAL_NODE, role0, visitor));
        RoleDiagnostic role1 = new RoleDiagnostic(10, "rename", 1);
        role1.setErrorCode("XPTY0004");
        this.setNameExp(tc.staticTypeCheck(this.getNameExp(), SequenceType.SINGLE_ATOMIC, role1, visitor));
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        ItemType supplied = this.getNameExp().getItemType();
        if (th.relationship(supplied, BuiltInAtomicType.STRING) == 4 && th.relationship(supplied, BuiltInAtomicType.UNTYPED_ATOMIC) == 4 && th.relationship(supplied, BuiltInAtomicType.QNAME) == 4) {
            XPathException de = new XPathException("The new name must be a string, QName, or untypedAtomic");
            de.setErrorCode("XPTY0004");
            de.setIsTypeError(true);
            de.setLocation(this.getLocation());
            throw de;
        }
        return this;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        RenameExpression exp = new RenameExpression(this.getTargetExp().copy(rebindings), this.getNameExp().copy(rebindings), this.nsContext, this.defaultNamespace);
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("rename", this);
        this.getTargetExp().export(out);
        this.getNameExp().export(out);
        out.endElement();
    }

    @Override
    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        InscopeNamespaceResolver nr;
        String existingURI;
        String uri;
        String localName;
        String prefix;
        NodeInfo node = (NodeInfo)this.getTargetExp().evaluateItem(context);
        if (!(node instanceof MutableNodeInfo)) {
            XPathException err = new XPathException("Node to be renamed is not an updateable node", "SXUP0081");
            err.setLocation(this.getLocation());
            throw err;
        }
        int nodeKind = node.getNodeKind();
        if (nodeKind != 1 && nodeKind != 2 && nodeKind != 7) {
            XPathException err = new XPathException("Node to be renamed is not an element, attribute, or processing-instruction", "XUTY0012");
            err.setLocation(this.getLocation());
            throw err;
        }
        AtomicValue nameValue = (AtomicValue)this.getNameExp().evaluateItem(context);
        if (nameValue instanceof StringValue) {
            CharSequence rawName = nameValue.getStringValueCS();
            try {
                String[] parts = NameChecker.getQNameParts(rawName);
                prefix = parts[0];
                localName = parts[1];
            }
            catch (QNameException err11) {
                XPathException err1 = new XPathException("Invalid node name. " + err11.getMessage(), "XQDY0074", this.getLocation());
                err1.setXPathContext(context);
                throw err1;
            }
            if (prefix.isEmpty()) {
                uri = nodeKind == 1 ? this.defaultNamespace : "";
            } else {
                uri = this.nsContext.getURIForPrefix(prefix, true);
                if (uri == null) {
                    XPathException err1 = new XPathException("Undeclared prefix in new node name: " + prefix, "XQDY0074", this.getLocation());
                    err1.setXPathContext(context);
                    throw err1;
                }
            }
        } else if (nameValue instanceof QNameValue) {
            localName = ((QNameValue)nameValue).getLocalName();
            uri = ((QNameValue)nameValue).getNamespaceURI();
            prefix = ((QNameValue)nameValue).getPrefix();
        } else {
            XPathException err1 = new XPathException("Computed element name has incorrect type");
            err1.setErrorCode("XPTY0004");
            err1.setIsTypeError(true);
            err1.setXPathContext(context);
            err1.setLocation(this.getLocation());
            throw err1;
        }
        if (uri.isEmpty()) {
            prefix = "";
        }
        if (prefix.equals("xmlns")) {
            prefix = "x-xmlns";
        }
        if (nodeKind == 7 && (prefix.length() > 0 || uri.length() > 0)) {
            XPathException err1 = new XPathException("Processing instruction cannot be in a namespace");
            err1.setErrorCode("XUDY0025");
            err1.setIsTypeError(true);
            err1.setXPathContext(context);
            err1.setLocation(this.getLocation());
            throw err1;
        }
        FingerprintedQName name = new FingerprintedQName(prefix, uri, localName);
        NodeInfo targetNode = node;
        if (nodeKind == 2) {
            targetNode = node.getParent();
        } else if (nodeKind == 7) {
            targetNode = null;
        }
        if (!(targetNode == null || nodeKind != 1 && prefix.length() == 0 || (existingURI = (nr = new InscopeNamespaceResolver(targetNode)).getURIForPrefix(prefix, true)) == null || existingURI.length() == 0 || existingURI.equals(uri))) {
            XPathException err1 = new XPathException("New name conflicts with existing namespace binding");
            err1.setErrorCode("XUDY0023");
            err1.setIsTypeError(true);
            err1.setXPathContext(context);
            err1.setLocation(this.getLocation());
            throw err1;
        }
        try {
            RenameAction action = new RenameAction(node, name);
            action.setOriginator(this);
            ((PendingUpdateListImpl)pul).add(action);
        }
        catch (XPathException e) {
            e.maybeSetLocation(this.getLocation());
            e.maybeSetContext(context);
            throw e;
        }
    }

    @Override
    public String getExpressionName() {
        return "rename";
    }
}

