/*
 * Decompiled with CFR 0.152.
 */
package marmot.core;

import java.util.Arrays;
import marmot.core.FloatFeatureVector;

public class FeatureVector {
    private int[] features_;
    private int length_;
    private boolean is_state_ = false;
    private boolean concat_;
    private FeatureVector sub_vector_;
    private FloatFeatureVector float_vector_;

    public String toString() {
        return "[features_=" + Arrays.toString(this.features_) + ", length_=" + this.length_ + ", is_state_=" + this.is_state_ + ", concat_=" + this.concat_ + ", sub_vector_=" + this.sub_vector_ + ", float_vector_=" + this.float_vector_ + "]";
    }

    public FeatureVector(int capacity) {
        this(capacity, null, false);
    }

    public FeatureVector(int capacity, FeatureVector vector) {
        this(capacity, vector, true);
    }

    public FeatureVector(int capacity, FeatureVector vector, boolean concat) {
        this.features_ = new int[capacity];
        this.length_ = 0;
        this.is_state_ = false;
        this.sub_vector_ = vector;
        this.concat_ = concat;
    }

    public Integer get(int index) {
        if (index < this.length_ || !this.concat_) {
            return this.features_[index];
        }
        return this.sub_vector_.get(index - this.length_);
    }

    public boolean add(int feature) {
        if (feature >= 0) {
            if (this.length_ >= this.features_.length) {
                this.features_ = Arrays.copyOf(this.features_, this.features_.length * 2);
            }
            this.features_[this.length_++] = feature;
        }
        return true;
    }

    public int size() {
        if (this.concat_ && this.sub_vector_ != null) {
            return this.length_ + this.sub_vector_.size();
        }
        return this.length_;
    }

    public boolean getIsState() {
        return this.is_state_;
    }

    public void setIsState(boolean is_state) {
        this.is_state_ = is_state;
    }

    public void append(FeatureVector vector) {
        if (this.features_.length < vector.size() + this.length_) {
            int[] features = new int[vector.size() + this.length_];
            System.arraycopy(this.features_, 0, features, 0, this.length_);
            this.features_ = features;
        }
        for (int index = 0; index < vector.size(); ++index) {
            this.add(vector.get(index));
        }
    }

    public int getDepth() {
        if (this.sub_vector_ == null) {
            return 0;
        }
        return this.sub_vector_.getDepth() + 1;
    }

    public void setConcat(boolean concat) {
        this.concat_ = concat;
    }

    public FloatFeatureVector getFloatVector() {
        if (this.float_vector_ != null) {
            assert (this.sub_vector_ == null);
            return this.float_vector_;
        }
        if (this.sub_vector_ != null) {
            return this.sub_vector_.getFloatVector();
        }
        return null;
    }

    public void setFloatVector(FloatFeatureVector float_vector) {
        this.float_vector_ = float_vector;
    }
}

