/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.maxent.io;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import opennlp.tools.ml.AbstractMLModelWriter;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.ComparablePredicate;
import opennlp.tools.ml.model.Context;

public abstract class GISModelWriter
extends AbstractMLModelWriter {
    public GISModelWriter(AbstractModel model) {
        Object[] data = model.getDataStructures();
        Map pmap = (Map)data[1];
        this.OUTCOME_LABELS = (String[])data[2];
        this.PARAMS = new Context[pmap.size()];
        this.PRED_LABELS = new String[pmap.size()];
        int i = 0;
        for (Map.Entry pred : pmap.entrySet()) {
            this.PRED_LABELS[i] = (String)pred.getKey();
            this.PARAMS[i] = (Context)pred.getValue();
            ++i;
        }
    }

    @Override
    protected ComparablePredicate[] sortValues() {
        Object[] sortPreds = new ComparablePredicate[this.PARAMS.length];
        int numParams = 0;
        for (int pid = 0; pid < this.PARAMS.length; ++pid) {
            int[] predkeys = this.PARAMS[pid].getOutcomes();
            int numActive = predkeys.length;
            double[] activeParams = this.PARAMS[pid].getParameters();
            numParams += numActive;
            sortPreds[pid] = new ComparablePredicate(this.PRED_LABELS[pid], predkeys, activeParams);
        }
        Arrays.sort(sortPreds);
        return sortPreds;
    }

    @Override
    public void persist() throws IOException {
        this.writeUTF("GIS");
        this.writeInt(1);
        this.writeDouble(1.0);
        this.writeInt(this.OUTCOME_LABELS.length);
        for (String OUTCOME_LABEL : this.OUTCOME_LABELS) {
            this.writeUTF(OUTCOME_LABEL);
        }
        ComparablePredicate[] sorted2 = this.sortValues();
        List<List<ComparablePredicate>> compressed = this.compressOutcomes(sorted2);
        this.writeInt(compressed.size());
        for (List<ComparablePredicate> aCompressed : compressed) {
            this.writeUTF(aCompressed.size() + ((Object)aCompressed.get(0)).toString());
        }
        this.writeInt(this.PARAMS.length);
        for (ComparablePredicate aSorted : sorted2) {
            this.writeUTF(aSorted.name);
        }
        for (ComparablePredicate aSorted : sorted2) {
            for (int j = 0; j < aSorted.params.length; ++j) {
                this.writeDouble(aSorted.params[j]);
            }
        }
        this.close();
    }
}

