/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ExpressionCompiler;
import com.saxonica.ee.bytecode.LetExpressionCompiler;
import com.saxonica.ee.bytecode.ToPushCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.objectweb.asm.Type;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.ContextOriginator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.ApplyTemplates;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.WithParam;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.Mode;

public class ApplyTemplatesCompiler
extends ToPushCompiler {
    @Override
    public void compileToPush(CompilerService compiler, Expression expression) throws CannotCompileException {
        Configuration config = compiler.getConfiguration();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        ApplyTemplatesCompiler.visitAnnotation(compiler, "ApplyTemplates-push");
        ApplyTemplatesCompiler.visitLineNumber(compiler, ga, expression);
        ApplyTemplates apply = (ApplyTemplates)expression;
        int modeVar = methodInfo.allocateLocal(Component.M.class);
        if (apply.usesCurrentMode()) {
            compiler.generateGetContext();
            ga.invokeInstanceMethod(XPathContext.class, "getCurrentMode", new Class[0]);
            ga.storeLocal(modeVar);
        } else {
            int slot = apply.getBindingSlot();
            compiler.generateGetContext();
            ga.push(slot);
            ga.invokeInstanceMethod(XPathContext.class, "getTargetComponent", Integer.TYPE);
            ga.storeLocal(modeVar);
        }
        compiler.generateGetContext();
        ga.invokeInstanceMethod(XPathContext.class, "newContext", new Class[0]);
        int context2Var = methodInfo.allocateLocal(XPathContextMajor.class);
        ApplyTemplatesCompiler.visitAnnotation(compiler, "ApplyTemplatesCompiler - newMajorContext");
        ga.storeLocal(context2Var);
        ga.loadLocal(context2Var);
        ga.newInstance(FocusTrackingIterator.class);
        ga.dup();
        compiler.compileToIterator(apply.getSelectExpression());
        ga.invokeConstructor(FocusTrackingIterator.class, SequenceIterator.class);
        ga.invokeInstanceMethod(XPathContext.class, "setCurrentIterator", FocusIterator.class);
        ApplyTemplatesCompiler.visitLineNumber(compiler, ga, expression);
        ApplyTemplatesCompiler.visitAnnotation(compiler, "ApplyTemplatesCompiler - setCurrentIterator");
        ga.loadLocal(context2Var);
        ga.checkClass(XPathContextMajor.class);
        ApplyTemplatesCompiler.allocateStatic(compiler, expression);
        ga.invokeInstanceMethod(XPathContextMajor.class, "setOrigin", ContextOriginator.class);
        ga.loadLocal(context2Var);
        ga.loadLocal(modeVar);
        ga.checkClass(Component.M.class);
        ga.invokeInstanceMethod(XPathContextMajor.class, "setCurrentMode", Component.M.class);
        ga.loadLocal(context2Var);
        ga.loadLocal(modeVar);
        ga.invokeInstanceMethod(XPathContextMajor.class, "setCurrentComponent", Component.class);
        boolean hasNonTunnelParams = apply.getActualParams() != null;
        int paramsVar = 0;
        if (hasNonTunnelParams) {
            paramsVar = methodInfo.allocateLocal(ParameterSet.class);
            ApplyTemplatesCompiler.compileParameterSet(compiler, this, apply.getActualParams());
            ga.storeLocal(paramsVar);
        }
        int tunnelsVar = methodInfo.allocateLocal(ParameterSet.class);
        ApplyTemplatesCompiler.compileTunnelParameterSet(compiler, this, apply.getTunnelParams());
        ga.storeLocal(tunnelsVar);
        methodInfo.pushContextVariableInfo(context2Var, false);
        ga.loadLocal(modeVar);
        ga.invokeInstanceMethod(Component.class, "getActor", new Class[0]);
        ga.checkClass(Mode.class);
        if (hasNonTunnelParams) {
            ga.loadLocal(paramsVar);
        } else {
            ga.pushNull();
        }
        ga.loadLocal(tunnelsVar);
        ga.loadLocal(context2Var);
        ApplyTemplatesCompiler.allocateStatic(compiler, apply.getLocation());
        ga.invokeInstanceMethod(Mode.class, "applyTemplates", ParameterSet.class, ParameterSet.class, XPathContextMajor.class, Location.class);
        LabelInfo applyEnd = methodInfo.newLabel("applyEnd");
        LabelInfo tailCallLoop = methodInfo.placeNewLabel("loop");
        ga.dup();
        ga.ifNull(applyEnd.label());
        ga.invokeInstanceMethod(TailCall.class, "processLeavingTail", new Class[0]);
        ga.goTo(tailCallLoop);
        methodInfo.placeLabel(applyEnd);
        ga.pop();
        methodInfo.popContextVariableInfo();
        methodInfo.releaseLocal(modeVar);
        methodInfo.releaseLocal(tunnelsVar);
        methodInfo.releaseLocal(context2Var);
        methodInfo.releaseLocal(paramsVar);
    }

    public static void compileParameterSet(CompilerService compiler, ExpressionCompiler ec, WithParam[] params) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        ApplyTemplatesCompiler.visitAnnotation(compiler, "compileParameterSet");
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        if (params == null || params.length == 0) {
            ga.pushNull();
        } else {
            ga.newInstance(Type.getType(ParameterSet.class));
            ga.dup();
            ga.push(params.length);
            ga.invokeConstructor(ParameterSet.class, Integer.TYPE);
            for (WithParam param : params) {
                ga.dup();
                compiler.generateGetContext();
                ga.dup();
                ga.invokeInstanceMethod(XPathContext.class, "getTemporaryOutputState", new Class[0]);
                int savedOutputStateVar = methodInfo.allocateLocal(Integer.TYPE);
                ga.storeLocal(savedOutputStateVar);
                ga.push(208);
                ga.invokeInstanceMethod(XPathContext.class, "setTemporaryOutputState", Integer.TYPE);
                ApplyTemplatesCompiler.allocateStatic(compiler, param.getVariableQName());
                LetExpressionCompiler.compileCommonExpr(compiler, param.getSelectExpression(), param.getEvaluationMode(), 10);
                ga.push(param.isTypeChecked());
                ga.invokeInstanceMethod(ParameterSet.class, "put", StructuredQName.class, Sequence.class, Boolean.TYPE);
                compiler.generateGetContext();
                ga.loadLocal(savedOutputStateVar);
                ga.invokeInstanceMethod(XPathContext.class, "setTemporaryOutputState", Integer.TYPE);
            }
        }
    }

    public static void compileTunnelParameterSet(CompilerService compiler, ExpressionCompiler ec, WithParam[] params) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        int existingParamsVar = methodInfo.allocateLocal(ParameterSet.class);
        LabelInfo endTunnel = methodInfo.newLabel("endTunnel");
        compiler.generateGetContext();
        ga.invokeInstanceMethod(XPathContext.class, "getTunnelParameters", new Class[0]);
        ga.storeLocal(existingParamsVar);
        LabelInfo nonNullExisting = methodInfo.newLabel("nonNullExisting");
        ga.loadLocal(existingParamsVar);
        ga.ifNonNull(nonNullExisting.label());
        ApplyTemplatesCompiler.compileParameterSet(compiler, ec, params);
        ga.goTo(endTunnel);
        methodInfo.placeLabel(nonNullExisting);
        ga.newInstance(ParameterSet.class);
        ga.dup();
        ga.loadLocal(existingParamsVar);
        ga.push(params == null ? 0 : params.length);
        ga.invokeConstructor(ParameterSet.class, ParameterSet.class, Integer.TYPE);
        if (params != null && params.length != 0) {
            for (WithParam param : params) {
                ga.dup();
                ApplyTemplatesCompiler.allocateStatic(compiler, param.getVariableQName());
                LetExpressionCompiler.compileCommonExpr(compiler, param.getSelectExpression(), param.getEvaluationMode(), 10);
                ga.push(false);
                ga.invokeInstanceMethod(ParameterSet.class, "put", StructuredQName.class, Sequence.class, Boolean.TYPE);
            }
        }
        methodInfo.placeLabel(endTunnel);
        methodInfo.releaseLocal(existingParamsVar);
    }
}

