/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ByteCodeCandidate;
import java.io.PrintWriter;
import java.util.Locale;
import net.sf.saxon.z.IntHashMap;

public class ByteCodeMonitor {
    public IntHashMap<ByteCodeDetails> stats = new IntHashMap();

    public void logCompilation(ByteCodeCandidate candidate, long time) {
        ByteCodeDetails details = this.obtainDetails(candidate);
        if (details.isCompiled) {
            throw new IllegalStateException();
        }
        details.isCompiled = true;
        details.compileTime = time;
    }

    private ByteCodeDetails obtainDetails(ByteCodeCandidate candidate) {
        int id = candidate.getId();
        ByteCodeDetails details = this.stats.get(id);
        if (details == null) {
            details = new ByteCodeDetails();
            details.candidate = candidate;
            this.stats.put(id, details);
        }
        return details;
    }

    public void logExecution(ByteCodeCandidate candidate, String evalMode, long time) {
        ByteCodeDetails details = this.obtainDetails(candidate);
        if (details.isCompiled) {
            ++details.byteCodeExecutions;
            details.timeInByteCode += time;
        } else {
            ++details.interpretedExecutions;
            details.timeInInterpreter += time;
        }
        if ("ebv".equals(evalMode)) {
            ++details.ebvCount;
        } else if ("eval".equals(evalMode)) {
            ++details.evalCount;
        } else if ("process".equals(evalMode)) {
            ++details.processCount;
        } else if ("iterate".equals(evalMode)) {
            ++details.iterateCount;
        }
    }

    public void report(PrintWriter w) {
        w.println("<stats unit='microseconds'>");
        for (ByteCodeDetails details : this.stats.valueSet()) {
            StringBuilder sb = new StringBuilder();
            sb.append(" <exp ");
            ByteCodeMonitor.att(sb, "id", "" + details.candidate.getId());
            ByteCodeMonitor.att(sb, "text", details.candidate.getBaseExpression().toShortString());
            ByteCodeMonitor.att(sb, "intCount", "" + details.interpretedExecutions);
            ByteCodeMonitor.att(sb, "intTime", "" + details.timeInInterpreter / 1000L);
            ByteCodeMonitor.att(sb, "bcCount", "" + details.byteCodeExecutions);
            ByteCodeMonitor.att(sb, "bcTime", "" + details.timeInByteCode / 1000L);
            ByteCodeMonitor.att(sb, "compileTime", "" + details.compileTime / 1000L);
            if (details.byteCodeExecutions > 0L && details.interpretedExecutions > 0L) {
                double avBC = details.timeInByteCode / details.byteCodeExecutions;
                double avInt = details.timeInInterpreter / details.interpretedExecutions;
                double ratio = avBC / avInt;
                ByteCodeMonitor.att(sb, "ratio", String.format((Locale)null, "%.3f", ratio));
            }
            ByteCodeMonitor.att(sb, "ebv", "" + details.ebvCount);
            ByteCodeMonitor.att(sb, "eval", "" + details.evalCount);
            ByteCodeMonitor.att(sb, "iterate", "" + details.iterateCount);
            ByteCodeMonitor.att(sb, "process", "" + details.processCount);
            ByteCodeMonitor.att(sb, "module", details.candidate.getLocation().getSystemId());
            ByteCodeMonitor.att(sb, "line", "" + details.candidate.getLocation().getLineNumber());
            sb.append("/>");
            w.println(sb);
        }
        w.println("</stats>");
    }

    private static void att(StringBuilder sb, String name, String value) {
        sb.append(name);
        sb.append("=\"");
        sb.append(value.replace("\"", "&quot;").replace("&", "&amp;").replace("<", "&lt;"));
        sb.append("\" ");
    }

    private static class ByteCodeDetails {
        ByteCodeCandidate candidate;
        boolean isCompiled;
        long compileTime;
        long interpretedExecutions;
        long timeInInterpreter;
        long byteCodeExecutions;
        long timeInByteCode;
        long ebvCount;
        long evalCount;
        long processCount;
        long iterateCount;

        private ByteCodeDetails() {
        }
    }
}

