/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ExpressionCompiler;
import com.saxonica.ee.bytecode.ToBooleanCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.objectweb.asm.Type;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.InstanceOfExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;

public class InstanceOfCompiler
extends ToBooleanCompiler {
    @Override
    public void compileToBoolean(CompilerService compiler, Expression expression) throws CannotCompileException {
        TypeHierarchy th = compiler.getConfiguration().getTypeHierarchy();
        InstanceOfExpression exp = (InstanceOfExpression)expression;
        Expression arg = exp.getBaseExpression();
        int requiredCardinality = exp.getRequiredCardinality();
        ItemType requiredType = exp.getRequiredItemType();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        InstanceOfCompiler.visitAnnotation(compiler, "compileToBoolean(instanceOf())");
        boolean anyItem = requiredType == AnyItemType.getInstance();
        boolean anyNode = requiredType == AnyNodeTest.getInstance();
        boolean anyAtomic = requiredType == BuiltInAtomicType.ANY_ATOMIC;
        boolean anyFunction = requiredType == AnyFunctionType.getInstance();
        boolean specificType = !anyItem && !anyNode && !anyAtomic && !anyFunction;
        boolean itemTypeOK = th.isSubType(arg.getItemType(), requiredType);
        boolean cardinalityOK = Cardinality.subsumes(requiredCardinality, arg.getCardinality());
        int itemTypeVar = -1;
        int configVar = -1;
        if (specificType && !itemTypeOK) {
            ExpressionCompiler.allocateStatic(compiler, requiredType);
            itemTypeVar = methodInfo.allocateLocal(ItemType.class);
            ga.storeLocal(itemTypeVar);
            compiler.generateGetContext();
            ga.invokeInstanceMethod(XPathContext.class, "getConfiguration", new Class[0]);
            configVar = methodInfo.allocateLocal(Configuration.class);
            ga.storeLocal(configVar);
        }
        LabelInfo returnFalse = methodInfo.newLabel("returnFalse");
        LabelInfo returnTrue = methodInfo.newLabel("returnTrue");
        LabelInfo testEmpty = methodInfo.newLabel("testEmpty");
        LabelInfo done = methodInfo.newLabel("doneInstOf");
        if (Cardinality.allowsMany(arg.getCardinality())) {
            LabelInfo closeAndReturnFalse = methodInfo.newLabel("closeAndReturnFalse");
            compiler.compileToIterator(arg);
            int iterVar = methodInfo.allocateLocal(SequenceIterator.class);
            ga.storeLocal(iterVar);
            InstanceOfCompiler.visitLineNumber(compiler, ga, expression);
            int countVar = -1;
            if (!cardinalityOK) {
                countVar = ga.newLocal(Type.INT_TYPE);
                ga.push(-1);
                ga.storeLocal(countVar);
            }
            LabelInfo loop = methodInfo.placeNewLabel("loop");
            ga.loadLocal(iterVar);
            ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
            if (!itemTypeOK) {
                ga.dup();
            }
            ga.ifNull(testEmpty.label());
            if (!itemTypeOK) {
                if (anyNode) {
                    ga.instanceOf(Type.getType(NodeInfo.class));
                    ga.ifZCmp(153, closeAndReturnFalse.label());
                } else if (anyAtomic) {
                    ga.instanceOf(Type.getType(AtomicValue.class));
                    ga.ifZCmp(153, closeAndReturnFalse.label());
                } else if (anyFunction) {
                    ga.instanceOf(Type.getType(Function.class));
                    ga.ifZCmp(153, closeAndReturnFalse.label());
                } else if (specificType) {
                    ga.loadLocal(itemTypeVar);
                    ga.swap();
                    InstanceOfCompiler.allocateStatic(compiler, th);
                    ga.invokeInstanceMethod(ItemType.class, "matches", Item.class, TypeHierarchy.class);
                    ga.ifZCmp(153, closeAndReturnFalse.label());
                }
            }
            if (!cardinalityOK) {
                ga.iinc(countVar, 1);
                if (!Cardinality.allowsMany(requiredCardinality)) {
                    ga.loadLocal(countVar);
                    ga.ifZCmp(157, closeAndReturnFalse.label());
                }
            }
            ga.goTo(loop);
            methodInfo.placeLabel(testEmpty);
            if (!itemTypeOK) {
                ga.pop();
            }
            if (!cardinalityOK && !Cardinality.allowsZero(requiredCardinality)) {
                ga.loadLocal(countVar);
                ga.ifZCmp(155, returnFalse.label());
            }
            methodInfo.placeLabel(returnTrue);
            ga.push(true);
            ga.goTo(done);
            methodInfo.placeLabel(closeAndReturnFalse);
            ga.loadLocal(iterVar);
            ga.invokeInstanceMethod(SequenceIterator.class, "close", new Class[0]);
            methodInfo.placeLabel(returnFalse);
            ga.push(false);
            methodInfo.placeLabel(done);
            methodInfo.releaseLocal(iterVar);
        } else {
            compiler.compileToItem(arg);
            InstanceOfCompiler.visitLineNumber(compiler, ga, expression);
            if (Cardinality.allowsZero(arg.getCardinality())) {
                LabelInfo notNull = methodInfo.newLabel("notNullIO");
                ga.dup();
                ga.ifNonNull(notNull.label());
                ga.pop();
                ga.goTo(Cardinality.allowsZero(requiredCardinality) ? returnTrue.label() : returnFalse.label());
                methodInfo.placeLabel(notNull);
            }
            if (itemTypeOK) {
                ga.pop();
            } else if (anyNode) {
                ga.instanceOf(Type.getType(NodeInfo.class));
                ga.ifZCmp(153, returnFalse.label());
            } else if (anyAtomic) {
                ga.instanceOf(Type.getType(AtomicValue.class));
                ga.ifZCmp(153, returnFalse.label());
            } else if (anyFunction) {
                ga.instanceOf(Type.getType(Function.class));
                ga.ifZCmp(153, returnFalse.label());
            } else if (specificType) {
                ga.loadLocal(itemTypeVar);
                ga.swap();
                InstanceOfCompiler.allocateStatic(compiler, th);
                ga.invokeInstanceMethod(ItemType.class, "matches", Item.class, TypeHierarchy.class);
                ga.ifZCmp(153, returnFalse.label());
            }
            methodInfo.placeLabel(returnTrue);
            ga.push(true);
            ga.goTo(done);
            methodInfo.placeLabel(returnFalse);
            ga.push(false);
            methodInfo.placeLabel(done);
        }
        methodInfo.releaseLocal(itemTypeVar);
        methodInfo.releaseLocal(configVar);
    }
}

