/*
 * Decompiled with CFR 0.152.
 */
package chipmunk.segmenter;

import java.util.Collection;
import java.util.LinkedList;

public class TagSet {
    private static final String SEGMENT = "SEGMENT";
    public static final String NUMBER = "NUM";
    public static final String ALPHA = "ALPHA";
    public static String SPECIAL = "SPECIAL";

    public static String getTag(String tag, int tag_level) {
        if (tag == null || tag_level < 1) {
            return SEGMENT;
        }
        String[] subtags = TagSet.split(tag);
        LinkedList<String> newtags = new LinkedList<String>();
        for (String subtag : subtags) {
            if (subtag.equals("UNK")) continue;
            if (subtag.equals("ROOT") || subtag.equals("PREFIX") || subtag.equals("SUFFIX")) {
                newtags.add(subtag);
                continue;
            }
            if (tag_level > 1 && TagSet.countDoubleColon(subtag) == 0) {
                newtags.add(subtag);
                continue;
            }
            if (tag_level > 2 && TagSet.countDoubleColon(subtag) < 2) {
                newtags.add(subtag);
                continue;
            }
            if (tag_level <= 3) continue;
            newtags.add(subtag);
        }
        newtags.add(SEGMENT);
        return TagSet.join(newtags);
    }

    private static int countDoubleColon(String subtag) {
        int count2 = 0;
        int index = 0;
        while (index < subtag.length()) {
            if ((index = subtag.indexOf("::", index)) < 0) {
                return count2;
            }
            index += 2;
            ++count2;
        }
        return count2;
    }

    private static String join(Collection<String> subtags) {
        StringBuilder sb = new StringBuilder();
        for (String subtag : subtags) {
            if (sb.length() > 0) {
                sb.append('|');
            }
            sb.append(subtag);
        }
        return sb.toString();
    }

    public static String[] split(String tag) {
        return tag.split("\\|");
    }
}

