/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.spans;

import de.ids_mannheim.korap.query.spans.SimpleSpans;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.Bits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassSpans
extends SimpleSpans {
    protected List<byte[]> classedPayload;
    protected Spans spans;
    protected byte number;
    protected SpanQuery operand;
    protected Boolean hasmorespans = false;
    private final Logger log = LoggerFactory.getLogger(ClassSpans.class);
    public static final boolean DEBUG = false;

    public ClassSpans(SpanQuery operand, LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts, byte number) throws IOException {
        this.spans = operand.getSpans(context, acceptDocs, termContexts);
        this.number = number;
        this.operand = operand;
        this.classedPayload = new ArrayList<byte[]>(3);
    }

    @Override
    public Collection<byte[]> getPayload() throws IOException {
        return this.classedPayload;
    }

    @Override
    public boolean isPayloadAvailable() {
        return true;
    }

    public byte getNumber() {
        return this.number;
    }

    public void setNumber(byte number) {
        this.number = number;
    }

    @Override
    public int doc() {
        return this.spans.doc();
    }

    @Override
    public int start() {
        return this.spans.start();
    }

    @Override
    public int end() {
        return this.spans.end();
    }

    @Override
    public boolean next() throws IOException {
        if (this.spans.next()) {
            return this.addClassPayload();
        }
        this.hasmorespans = false;
        return false;
    }

    protected boolean addClassPayload() throws IOException {
        this.hasmorespans = true;
        this.classedPayload.clear();
        if (this.spans.isPayloadAvailable()) {
            this.classedPayload.addAll(this.spans.getPayload());
        }
        ByteBuffer bb = ByteBuffer.allocate(10);
        bb.put((byte)0);
        bb.putInt(this.spans.start());
        bb.putInt(this.spans.end());
        bb.put(this.number);
        this.classedPayload.add(bb.array());
        if (this.spans instanceof SimpleSpans) {
            SimpleSpans ss = (SimpleSpans)this.spans;
            this.hasSpanId = ss.hasSpanId;
            this.spanId = ss.spanId;
        }
        return true;
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        this.classedPayload.clear();
        if (this.hasmorespans.booleanValue() && this.spans.doc() < target && this.spans.skipTo(target)) {
            return this.addClassPayload();
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "(" + this.operand.toString() + ")@" + this.doc() + ":" + this.start() + "-" + this.end();
    }

    @Override
    public long cost() {
        return this.spans.cost();
    }
}

