/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.config;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.config.ProfessionalTransformerFactory;
import com.saxonica.config.pe.ConfigurationReaderPE;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.sdoc.SchemaDocument;
import com.saxonica.ee.schema.sdoc.SchemaReader;
import java.io.File;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.trans.XPathException;

public class EnterpriseTransformerFactory
extends ProfessionalTransformerFactory {
    public EnterpriseTransformerFactory() {
        super(new EnterpriseConfiguration());
        EnterpriseConfiguration config = (EnterpriseConfiguration)this.getConfiguration();
        config.setProcessor(this);
    }

    public EnterpriseTransformerFactory(EnterpriseConfiguration config) {
        this.setConfiguration(config);
    }

    public void addSchema(Source schemaSource) throws TransformerException {
        EnterpriseConfiguration config = (EnterpriseConfiguration)this.getConfiguration();
        SchemaCompiler compiler = config.newSchemaCompiler();
        PipelineConfiguration pipe = config.makePipelineConfiguration();
        pipe.setHostLanguage(52);
        SchemaDocument schemadoc = SchemaReader.read(schemaSource, compiler, pipe, null);
        compiler.validate(schemadoc);
    }

    @Override
    public void setAttribute(String name, Object value) throws IllegalArgumentException {
        if (name.equals("http://saxon.sf.net/feature/configuration-file")) {
            ConfigurationReaderPE reader = new ConfigurationReaderPE();
            try {
                this.setConfiguration(reader.makeConfiguration(new StreamSource(new File((String)value))));
            }
            catch (XPathException err) {
                throw new IllegalArgumentException(err);
            }
        } else {
            super.setAttribute(name, value);
        }
    }
}

