/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ExpressionCompiler;
import com.saxonica.ee.bytecode.ToIteratorCompiler;
import com.saxonica.ee.bytecode.VariableReferenceCompiler;
import com.saxonica.ee.bytecode.iter.CompiledFilterIterator;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.objectweb.asm.ClassVisitor;
import com.saxonica.objectweb.asm.ClassWriter;
import com.saxonica.objectweb.asm.Label;
import com.saxonica.objectweb.asm.Type;
import com.saxonica.objectweb.asm.commons.Method;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.SubsequenceIterator;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.NumericType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.MemoClosure;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class FilterExpressionCompiler
extends ToIteratorCompiler {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void compileToIterator(CompilerService compiler, Expression expression) throws CannotCompileException {
        FilterExpression filterExpr = (FilterExpression)expression;
        Expression start = filterExpr.getSelectExpression();
        Expression filter = filterExpr.getActionExpression();
        Generator ga = compiler.getCurrentGenerator();
        TypeHierarchy th = compiler.getConfiguration().getTypeHierarchy();
        FilterExpressionCompiler.visitLineNumber(compiler, ga, expression);
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        FilterExpressionCompiler.visitAnnotation(compiler, "FilterExpressionCompiler-Itr");
        LabelInfo endLab = methodInfo.newLabel("endFilterExp");
        LabelInfo notNullLab = methodInfo.newLabel("notNullLab");
        LabelInfo emptyIterLab = methodInfo.newLabel("emptyIterLab");
        int firstVar = ga.newLocal(Item.class);
        int seqItrVar = ga.newLocal(SequenceIterator.class);
        int posVar = ga.newLocal(Integer.TYPE);
        boolean seqItrVarCreated = false;
        LabelInfo notNumericLab = null;
        if (filterExpr.isIndependentFilter()) {
            block27: {
                if (filter instanceof Literal) {
                    GroundedValue<?> literalValue = ((Literal)filter).getValue();
                    if (literalValue.getLength() == 1) {
                        int literalIntValue = 0;
                        try {
                            literalIntValue = Integer.parseInt(literalValue.getStringValue());
                        }
                        catch (XPathException e) {
                            ga.invokeStaticMethod(EmptyIterator.class, "emptyIterator", new Class[0]);
                            return;
                        }
                        if (literalIntValue > 0 && literalIntValue < Integer.MAX_VALUE) {
                            ga.push(literalIntValue);
                            ga.storeLocal(posVar);
                            if (start instanceof Literal) {
                                throw new CannotCompileException();
                            }
                            if (!(start instanceof VariableReference)) {
                                compiler.compileToIterator(start);
                                ga.dup();
                                LabelInfo notGroundedLab = methodInfo.newLabel("notGroundLab");
                                ga.ifNotInstance(GroundedIterator.class, notGroundedLab);
                                ga.checkClass(GroundedIterator.class);
                                ga.invokeInstanceMethod(GroundedIterator.class, "materialize", new Class[0]);
                                ga.loadLocal(posVar);
                                ga.push(1);
                                ga.math(100, Type.INT_TYPE);
                                ga.invokeInstanceMethod(GroundedValue.class, "itemAt", Integer.TYPE);
                                ga.dup();
                                LabelInfo gitemNullCheck = methodInfo.newLabel("gitemNullCheck_FilerExpr");
                                ga.ifNull(gitemNullCheck.label());
                                ga.invokeInstanceMethod(Item.class, "iterate", new Class[0]);
                                ga.goTo(endLab);
                                methodInfo.placeLabel(gitemNullCheck);
                                ga.pop();
                                ga.invokeStaticMethod(EmptyIterator.class, "emptyIterator", new Class[0]);
                                ga.goTo(endLab);
                                methodInfo.placeLabel(notGroundedLab);
                                ga.loadLocal(posVar);
                                ga.dup();
                                ga.invokeStaticMethod(SubsequenceIterator.class, "make", SequenceIterator.class, Integer.TYPE, Integer.TYPE);
                                methodInfo.placeLabel(endLab);
                                return;
                            }
                            VariableReferenceCompiler.genEvaluateVariable(compiler, ga, (VariableReference)start);
                            ga.dup();
                            LabelInfo notMemoLab1 = methodInfo.newLabel("notMemoLab1");
                            ga.ifNotInstance(MemoClosure.class, notMemoLab1);
                            ga.checkClass(MemoClosure.class);
                            ga.loadLocal(posVar);
                            ga.push(1);
                            ga.math(100, Type.INT_TYPE);
                            ga.invokeInstanceMethod(MemoClosure.class, "itemAt", Integer.TYPE);
                            ga.invokeInstanceMethod(Sequence.class, "iterate", new Class[0]);
                            ga.goTo(endLab);
                            methodInfo.placeLabel(notMemoLab1);
                            LabelInfo nullItem2 = methodInfo.newLabel("nullItem2_FilterExpr");
                            ga.invokeInstanceMethod(Sequence.class, "materialize", new Class[0]);
                            ga.loadLocal(posVar);
                            ga.push(1);
                            ga.math(100, Type.INT_TYPE);
                            ga.invokeInstanceMethod(GroundedValue.class, "itemAt", Integer.TYPE);
                            ga.dup();
                            ga.ifNull(nullItem2.label());
                            ga.invokeStaticMethod(SingletonIterator.class, "makeIterator", Item.class);
                            ga.goTo(endLab);
                            methodInfo.placeLabel(nullItem2);
                            ga.pop();
                            ga.goTo(emptyIterLab);
                            break block27;
                        } else {
                            ga.invokeStaticMethod(EmptyIterator.class, "emptyIterator", new Class[0]);
                            return;
                        }
                    }
                    try {
                        boolean ebv = literalValue.effectiveBooleanValue();
                        if (!ebv) {
                            ga.invokeStaticMethod(EmptyIterator.class, "emptyIterator", new Class[0]);
                            return;
                        }
                        compiler.compileToIterator(start);
                    }
                    catch (XPathException e) {
                        ga.invokeStaticMethod(EmptyIterator.class, "emptyIterator", new Class[0]);
                        return;
                    }
                }
                FilterExpressionCompiler.visitAnnotation(compiler, "FilterExpressionCompiler-Itr2");
                if (!Cardinality.allowsMany(filter.getCardinality())) {
                    compiler.compileToItem(filter);
                    if (!Cardinality.allowsZero(filter.getCardinality())) {
                        ga.storeLocal(firstVar);
                    } else {
                        ga.dup();
                        ga.storeLocal(firstVar);
                        ga.ifNonNull(notNullLab.label());
                        ga.invokeStaticMethod(EmptyIterator.class, "emptyIterator", new Class[0]);
                        ga.goTo(endLab);
                        seqItrVarCreated = false;
                    }
                } else {
                    compiler.compileToIterator(filter);
                    ga.dup();
                    ga.storeLocal(seqItrVar);
                    seqItrVarCreated = true;
                    ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
                    ga.dup();
                    ga.storeLocal(firstVar);
                    ga.ifNonNull(notNullLab.label());
                    ga.invokeStaticMethod(EmptyIterator.class, "emptyIterator", new Class[0]);
                    ga.goTo(endLab);
                }
                methodInfo.placeLabel(notNullLab);
            }
            int relToNumeric = th.relationship(filter.getItemType(), NumericType.getInstance());
            if (relToNumeric != 4) {
                int relToInteger;
                if (relToNumeric != 0 && relToNumeric != 2) {
                    notNumericLab = methodInfo.newLabel("notNumericLab");
                    ga.loadLocal(firstVar);
                    ga.ifNotInstance(NumericValue.class, notNumericLab);
                }
                if (Cardinality.allowsMany(filter.getCardinality())) {
                    LabelInfo singleSeqLab = methodInfo.newLabel("singleSeqLab");
                    ga.loadLocal(seqItrVar);
                    ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
                    ga.ifNull(singleSeqLab.label());
                    ga.push("sequence of two or more items starting with a numeric value");
                    ga.invokeStaticMethod(ExpressionTool.class, "ebvError", String.class);
                    ga.pushNull();
                    ga.goTo(endLab);
                    methodInfo.placeLabel(singleSeqLab);
                }
                if ((relToInteger = th.relationship(filter.getItemType(), BuiltInAtomicType.INTEGER)) != 0 && relToNumeric != 2) {
                    ga.loadLocal(firstVar);
                    ga.checkClass(NumericValue.class);
                    ga.invokeInstanceMethod(NumericValue.class, "isWholeNumber", new Class[0]);
                    ga.ifFalse(emptyIterLab);
                }
                ga.loadLocal(firstVar);
                ga.checkClass(NumericValue.class);
                ga.invokeInstanceMethod(NumericValue.class, "asSubscript", new Class[0]);
                ga.storeLocal(posVar);
                ga.loadLocal(posVar);
                ga.ifZCmp(158, emptyIterLab.label());
                if (start instanceof VariableReference) {
                    VariableReferenceCompiler.genEvaluateVariable(compiler, ga, (VariableReference)start);
                    ga.dup();
                    LabelInfo notMemoLab = methodInfo.newLabel("notMemoLab");
                    ga.ifNotInstance(MemoClosure.class, notMemoLab);
                    ga.checkClass(MemoClosure.class);
                    ga.loadLocal(posVar);
                    ga.push(1);
                    ga.math(100, Type.INT_TYPE);
                    ga.invokeStaticMethod(SequenceTool.class, "itemAt", Sequence.class, Integer.TYPE);
                    ga.dup();
                    LabelInfo itemNullCheck = methodInfo.newLabel("itemNullCheck_FilerExpr");
                    ga.ifNull(itemNullCheck.label());
                    ga.invokeInstanceMethod(Item.class, "iterate", new Class[0]);
                    ga.goTo(endLab);
                    methodInfo.placeLabel(itemNullCheck);
                    ga.pop();
                    ga.goTo(emptyIterLab);
                    methodInfo.placeLabel(notMemoLab);
                    ga.invokeInstanceMethod(Sequence.class, "materialize", new Class[0]);
                    ga.loadLocal(posVar);
                    ga.push(1);
                    ga.math(100, Type.INT_TYPE);
                    ga.invokeInstanceMethod(GroundedValue.class, "itemAt", Integer.TYPE);
                    ga.dup();
                    LabelInfo itemIsNull = methodInfo.newLabel("itemIsNull");
                    ga.ifNull(itemIsNull.label());
                    ga.invokeInstanceMethod(Item.class, "iterate", new Class[0]);
                    ga.goTo(endLab);
                    methodInfo.placeLabel(itemIsNull);
                    ga.pop();
                    ga.goTo(emptyIterLab);
                } else if (start instanceof Literal) {
                    FilterExpressionCompiler.allocateStatic(compiler, ((Literal)start).getValue());
                    ga.loadLocal(posVar);
                    ga.push(1);
                    ga.math(100, Type.INT_TYPE);
                    ga.invokeInstanceMethod(GroundedValue.class, "itemAt", Integer.TYPE);
                    ga.dup();
                    LabelInfo itemNullCheck2 = methodInfo.newLabel("itemNullCheck2_FilerExpr");
                    ga.ifNull(itemNullCheck2.label());
                    ga.invokeInstanceMethod(Item.class, "iterate", new Class[0]);
                    ga.goTo(endLab);
                    methodInfo.placeLabel(itemNullCheck2);
                    ga.pop();
                    ga.goTo(emptyIterLab);
                } else {
                    compiler.compileToIterator(start);
                    ga.dup();
                    ga.invokeInstanceMethod(SequenceIterator.class, "getProperties", new Class[0]);
                    ga.push(1);
                    ga.math(126, Type.INT_TYPE);
                    LabelInfo notGrounded = methodInfo.newLabel("notGrounded");
                    ga.ifZCmp(153, notGrounded.label());
                    ga.checkClass(GroundedIterator.class);
                    ga.invokeInstanceMethod(GroundedIterator.class, "materialize", new Class[0]);
                    ga.checkClass(GroundedValue.class);
                    ga.loadLocal(posVar);
                    ga.push(1);
                    ga.math(100, Type.INT_TYPE);
                    ga.invokeInstanceMethod(GroundedValue.class, "itemAt", Integer.TYPE);
                    ga.dup();
                    LabelInfo itemNullCheck3 = methodInfo.newLabel("itemNullCheck3_FilerExpr");
                    ga.ifNull(itemNullCheck3.label());
                    ga.invokeInstanceMethod(Item.class, "iterate", new Class[0]);
                    ga.goTo(endLab);
                    methodInfo.placeLabel(itemNullCheck3);
                    ga.pop();
                    ga.goTo(emptyIterLab);
                    ga.goTo(endLab);
                    methodInfo.placeLabel(notGrounded);
                    ga.loadLocal(posVar);
                    ga.dup();
                    ga.invokeStaticMethod(SubsequenceIterator.class, "make", SequenceIterator.class, Integer.TYPE, Integer.TYPE);
                    ga.goTo(endLab);
                }
            }
            if (notNumericLab != null) {
                methodInfo.placeLabel(notNumericLab);
            }
            int itemVar = ga.newLocal(Type.BOOLEAN_TYPE);
            ga.push(false);
            ga.storeLocal(itemVar);
            LabelInfo endOfChecks = methodInfo.newLabel("endofChecks_FilterExpr");
            ItemType itemType = filter.getItemType();
            LabelInfo boolLab = methodInfo.newLabel("boolCheck");
            this.compileNodeCheck2(compiler, ga, th, itemType, endOfChecks, itemVar, firstVar);
            this.compileBooleanCheck2(compiler, ga, th, itemType, endOfChecks, Cardinality.allowsMany(filter.getCardinality()) && seqItrVarCreated, seqItrVar, itemVar, firstVar);
            this.compileStringCheck2(compiler, ga, th, itemType, endOfChecks, Cardinality.allowsMany(filter.getCardinality()) && seqItrVarCreated, seqItrVar, itemVar, firstVar);
            ga.push("sequence starting with an atomic value other than a boolean, number, or string");
            ga.invokeStaticMethod(ExpressionTool.class, "ebvError", String.class);
            methodInfo.placeLabel(endOfChecks);
            ga.loadLocal(itemVar);
            ga.ifFalse(emptyIterLab);
            compiler.compileToIterator(start);
            ga.goTo(endLab);
            methodInfo.releaseLocal(seqItrVar);
            methodInfo.releaseLocal(itemVar);
        } else {
            Class<? extends CompiledFilterIterator> filterIteratorClass = compiler.getCompiledClass(filter);
            if (filterIteratorClass == null) {
                filterIteratorClass = this.makeFilterIteratorClass(compiler, filter);
                compiler.setCompiledClass(filter, filterIteratorClass);
            }
            ExpressionCompiler.allocateStatic(compiler, filterIteratorClass);
            ga.invokeInstanceMethod(Class.class, "newInstance", new Class[0]);
            ga.checkClass(CompiledFilterIterator.class);
            ga.dup();
            compiler.compileToIterator(start);
            ga.checkClass(SequenceIterator.class);
            compiler.generateGetContext();
            ga.invokeInstanceMethod(CompiledFilterIterator.class, "setSequence", SequenceIterator.class, XPathContext.class);
            ga.goTo(endLab);
        }
        methodInfo.placeLabel(emptyIterLab);
        ga.invokeStaticMethod(EmptyIterator.class, "emptyIterator", new Class[0]);
        methodInfo.placeLabel(endLab);
    }

    private Class<? extends CompiledFilterIterator> makeFilterIteratorClass(CompilerService compiler, Expression predicate) throws CannotCompileException {
        compiler.checkMaxClassesLimit();
        ClassWriter cw = new ClassWriter(compiler.getFlags());
        ClassVisitor cv = cw;
        String className = "gen_CompiledFilterIterator_" + CompilerService.getUniqueNumber();
        cv = compiler.makeAnnotatedTraceClassVisitor(cv, className);
        cv.visitSource(predicate.getLocation().getSystemId(), null);
        cv.visit(49, 1, className, null, "com/saxonica/ee/bytecode/iter/CompiledFilterIterator", new String[0]);
        compiler.pushNewClassInfo(className, CompiledFilterIterator.class, cw);
        Method m = Method.getMethod("void <init> ()");
        Generator ga = new Generator(1, m, false, cv);
        ga.loadThis();
        ga.invokeConstructor(Type.getType(CompiledFilterIterator.class), m);
        ga.returnValue();
        ga.endMethod();
        m = Method.getMethod("boolean matches()");
        ga = new Generator(1, m, true, cv);
        int contextVar = ga.newLocal(XPathContext.class);
        compiler.pushNewMethodInfo(ga, false, contextVar);
        FilterExpressionCompiler.visitLineNumber(compiler, ga, predicate);
        ga.loadThis();
        ga.getField(Type.getType(CompiledFilterIterator.class), "filterContext", Type.getType(XPathContext.class));
        compiler.initNewMethod(ga, false);
        TypeHierarchy th = compiler.getConfiguration().getTypeHierarchy();
        ItemType predicateItemType = predicate.getItemType();
        if (predicate.getCardinality() == 16384 && th.isSubType(predicateItemType, BuiltInAtomicType.BOOLEAN)) {
            compiler.compileToBoolean(predicate);
        } else if (!Cardinality.allowsMany(predicate.getCardinality())) {
            this.compileSingletonPredicate(compiler, predicate);
        } else {
            this.compileGeneralPredicate(compiler, predicate);
        }
        ga.showMessage(compiler, "FilterExpression-itr-test1");
        ga.returnValue();
        try {
            ga.endMethod();
        }
        catch (Exception err) {
            System.err.println("**** endMethod failed");
        }
        compiler.popCurrentMethodInfo();
        cv.visitEnd();
        FilterExpressionCompiler.verify(cw, "Filter expression at line " + predicate.getLocation().getLineNumber(), compiler.isDebugByteCode());
        return compiler.makeClass(cw, className);
    }

    private void compileGeneralPredicate(CompilerService compiler, Expression predicate) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        TypeHierarchy th = compiler.getConfiguration().getTypeHierarchy();
        ItemType predicateItemType = predicate.getItemType();
        LabelInfo end = methodInfo.newLabel("end");
        LabelInfo checkNoMoreItems = methodInfo.newLabel("checkNoMoreItems");
        LabelInfo error = methodInfo.newLabel("error");
        FilterExpressionCompiler.visitAnnotation(compiler, "FilterExpressionCompiler.compileGeneralPredicate(" + predicate.toString() + ")");
        compiler.compileToIterator(predicate);
        int iterVar = methodInfo.allocateLocal(SequenceIterator.class);
        ga.storeLocal(iterVar);
        int resultVar = ga.newLocal(Type.BOOLEAN_TYPE);
        ga.push(false);
        ga.storeLocal(resultVar);
        ga.loadLocal(iterVar);
        ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
        int itemVar = methodInfo.allocateLocal(Item.class);
        ga.storeLocal(itemVar);
        if (Cardinality.allowsZero(predicate.getCardinality())) {
            FilterExpressionCompiler.visitAnnotation(compiler, "FilterExpressionCompiler.compileGeneralPredicate(): test if empty");
            LabelInfo notEmptySequence = methodInfo.newLabel("notEmptySequence");
            ga.loadLocal(itemVar);
            ga.ifNonNull(notEmptySequence.label());
            ga.goTo(end);
            methodInfo.placeLabel(notEmptySequence);
        }
        this.compileBooleanCheck(compiler, ga, th, predicateItemType, checkNoMoreItems, resultVar, itemVar);
        this.compileNumericCheck(compiler, ga, th, predicateItemType, end, checkNoMoreItems, resultVar, itemVar);
        this.compileStringCheck(compiler, ga, th, predicateItemType, checkNoMoreItems, resultVar, itemVar);
        this.compileNodeCheck(compiler, ga, th, predicateItemType, end, error, resultVar, itemVar);
        methodInfo.placeLabel(checkNoMoreItems);
        FilterExpressionCompiler.visitAnnotation(compiler, "FilterExpressionCompiler.compileGeneralPredicate(): check no more items");
        ga.loadLocal(iterVar);
        ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
        ga.ifNull(end.label());
        methodInfo.placeLabel(error);
        compiler.generateDynamicError("Effective boolean value is not defined", "FORG0006", predicate.getLocation(), false);
        methodInfo.placeLabel(end);
        ga.loadLocal(resultVar);
        methodInfo.releaseLocal(itemVar);
        methodInfo.releaseLocal(iterVar);
    }

    private void compileSingletonPredicate(CompilerService compiler, Expression predicate) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        TypeHierarchy th = compiler.getConfiguration().getTypeHierarchy();
        ItemType predicateItemType = predicate.getItemType();
        LabelInfo end = methodInfo.newLabel("end");
        LabelInfo error = methodInfo.newLabel("error");
        FilterExpressionCompiler.visitAnnotation(compiler, "FilterExpressionCompiler.compileSingletonPredicate(" + predicate + ")");
        compiler.compileToItem(predicate);
        int resultVar = ga.newLocal(Type.BOOLEAN_TYPE);
        ga.push(false);
        ga.storeLocal(resultVar);
        int itemVar = methodInfo.allocateLocal(Item.class);
        ga.storeLocal(itemVar);
        if (Cardinality.allowsZero(predicate.getCardinality())) {
            FilterExpressionCompiler.visitAnnotation(compiler, "FilterExpressionCompiler.compileSingletonPredicate(): test if empty");
            Label notEmptySequence = new Label();
            ga.loadLocal(itemVar);
            ga.ifNonNull(notEmptySequence);
            ga.goTo(end);
            ga.mark(notEmptySequence);
        }
        this.compileBooleanCheck(compiler, ga, th, predicateItemType, end, resultVar, itemVar);
        this.compileNumericCheck(compiler, ga, th, predicateItemType, end, end, resultVar, itemVar);
        this.compileStringCheck(compiler, ga, th, predicateItemType, end, resultVar, itemVar);
        this.compileNodeCheck(compiler, ga, th, predicateItemType, end, error, resultVar, itemVar);
        methodInfo.placeLabel(error);
        compiler.generateDynamicError("Effective boolean value is not defined", "FORG0006", predicate.getLocation(), false);
        FilterExpressionCompiler.visitAnnotation(compiler, "FilterExpressionCompiler.compileSingletonPredicate(): return");
        methodInfo.placeLabel(end);
        ga.loadLocal(resultVar);
    }

    private void compileBooleanCheck(CompilerService compiler, Generator ga, TypeHierarchy th, ItemType predicateItemType, LabelInfo checkNoMoreItems, int resultVar, int itemVar) {
        int relToBoolean = th.relationship(predicateItemType, BuiltInAtomicType.BOOLEAN);
        if (relToBoolean != 4) {
            Label notBoolean = null;
            FilterExpressionCompiler.visitAnnotation(compiler, "FilterExpressionCompiler.compilePredicate(): test boolean value");
            if (relToBoolean != 0 && relToBoolean != 2) {
                notBoolean = new Label();
                ga.loadLocal(itemVar);
                ga.instanceOf(Type.getType(BooleanValue.class));
                ga.ifZCmp(153, notBoolean);
            }
            ga.loadLocal(itemVar);
            ga.checkClass(BooleanValue.class);
            ga.invokeInstanceMethod(BooleanValue.class, "getBooleanValue", new Class[0]);
            ga.storeLocal(resultVar);
            ga.goTo(checkNoMoreItems);
            if (notBoolean != null) {
                ga.mark(notBoolean);
            }
        }
    }

    private void compileNumericCheck(CompilerService compiler, Generator ga, TypeHierarchy th, ItemType predicateItemType, LabelInfo end, LabelInfo checkNoMoreItems, int resultVar, int itemVar) {
        int relToNumeric = th.relationship(predicateItemType, NumericType.getInstance());
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        LabelInfo isZero = methodInfo.newLabel("isZeroLab");
        if (relToNumeric != 4) {
            FilterExpressionCompiler.visitAnnotation(compiler, "FilterExpressionCompiler.compilePredicate(): test numeric value");
            LabelInfo notNumeric = null;
            if (relToNumeric != 0 && relToNumeric != 2) {
                notNumeric = methodInfo.newLabel("notNumeric");
                ga.loadLocal(itemVar);
                ga.instanceOf(Type.getType(NumericValue.class));
                ga.ifFalse(notNumeric);
            }
            if (th.relationship(predicateItemType, BuiltInAtomicType.DOUBLE) != 4 || th.relationship(predicateItemType, BuiltInAtomicType.FLOAT) != 4) {
                FilterExpressionCompiler.visitAnnotation(compiler, "FilterExpressionCompiler.compilePredicate(): test for NaN");
                ga.loadLocal(itemVar);
                ga.checkClass(AtomicValue.class);
                ga.invokeInstanceMethod(AtomicValue.class, "isNaN", new Class[0]);
                Label notNaN = new Label();
                ga.ifZCmp(153, notNaN);
                ga.goTo(checkNoMoreItems);
                ga.mark(notNaN);
            }
            ga.loadLocal(itemVar);
            ga.checkClass(NumericValue.class);
            compiler.generateGetContext();
            ga.invokeInstanceMethod(XPathContext.class, "getCurrentIterator", new Class[0]);
            ga.invokeInstanceMethod(FocusIterator.class, "position", new Class[0]);
            ga.cast(Type.INT_TYPE, Type.LONG_TYPE);
            ga.invokeInstanceMethod(NumericValue.class, "compareTo", Long.TYPE);
            ga.ifZCmp(153, isZero.label());
            ga.push(false);
            ga.storeLocal(resultVar);
            ga.goTo(checkNoMoreItems);
            methodInfo.placeLabel(isZero);
            ga.push(true);
            ga.storeLocal(resultVar);
            ga.goTo(checkNoMoreItems);
            if (notNumeric != null) {
                methodInfo.placeLabel(notNumeric);
            }
        }
    }

    private void compileStringCheck(CompilerService compiler, Generator ga, TypeHierarchy th, ItemType predicateItemType, LabelInfo checkNoMoreItems, int resultVar, int itemVar) {
        int relToString = th.relationship(predicateItemType, BuiltInAtomicType.STRING);
        if (relToString != 4) {
            FilterExpressionCompiler.visitAnnotation(compiler, "FilterExpressionCompiler.compilePredicate: test string value");
            Label notString = null;
            if (relToString != 0 && relToString != 2) {
                notString = new Label();
                ga.loadLocal(itemVar);
                ga.instanceOf(Type.getType(StringValue.class));
                ga.ifZCmp(153, notString);
            }
            ga.loadLocal(itemVar);
            ga.checkClass(StringValue.class);
            ga.invokeInstanceMethod(StringValue.class, "isZeroLength", new Class[0]);
            ga.not();
            ga.storeLocal(resultVar);
            ga.goTo(checkNoMoreItems);
            if (notString != null) {
                ga.mark(notString);
            }
        }
    }

    private void compileNodeCheck(CompilerService compiler, Generator ga, TypeHierarchy th, ItemType predicateItemType, LabelInfo end, LabelInfo error, int resultVar, int itemVar) {
        int relToNode = th.relationship(predicateItemType, AnyNodeTest.getInstance());
        if (relToNode == 0 || relToNode == 2) {
            FilterExpressionCompiler.visitAnnotation(compiler, "FilterExpressionCompiler.compilePredicate(): node exists");
            ga.push(true);
            ga.storeLocal(resultVar);
            ga.goTo(end);
        } else if (relToNode != 4) {
            FilterExpressionCompiler.visitAnnotation(compiler, "FilterExpressionCompiler.compilePredicate(): test node existence");
            ga.loadLocal(itemVar);
            ga.instanceOf(Type.getType(NodeInfo.class));
            ga.ifZCmp(153, error.label());
            ga.push(true);
            ga.storeLocal(resultVar);
            ga.goTo(end);
        }
    }

    private void compileBooleanCheck2(CompilerService compiler, Generator ga, TypeHierarchy th, ItemType predicateItemType, LabelInfo end, boolean oneOrMoreCheck, int seqItrVar, int resultVar, int itemVar) {
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        int relToBoolean = th.relationship(predicateItemType, BuiltInAtomicType.BOOLEAN);
        if (relToBoolean != 4) {
            LabelInfo notBoolean = null;
            FilterExpressionCompiler.visitAnnotation(compiler, "FilterExpressionCompiler.compilePredicate(): test boolean value2");
            if (relToBoolean == 0 || relToBoolean == 2) {
                ga.loadLocal(itemVar);
                ga.checkClass(BooleanValue.class);
                ga.invokeInstanceMethod(BooleanValue.class, "getBooleanValue", new Class[0]);
                ga.storeLocal(resultVar);
            } else {
                notBoolean = methodInfo.newLabel("notBoolean_compileBooleanCheck2");
                ga.loadLocal(itemVar);
                ga.ifNotInstance(BooleanValue.class, notBoolean);
                ga.loadLocal(itemVar);
                ga.checkClass(BooleanValue.class);
                ga.invokeInstanceMethod(BooleanValue.class, "getBooleanValue", new Class[0]);
                ga.storeLocal(resultVar);
            }
            if (oneOrMoreCheck) {
                ga.loadLocal(seqItrVar);
                ga.checkClass(SequenceIterator.class);
                ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
                ga.ifNull(end.label());
                ga.push("sequence of two or more items starting with a boolean value");
                ga.invokeStaticMethod(ExpressionTool.class, "ebvError", String.class);
            }
            ga.goTo(end);
            if (notBoolean != null) {
                methodInfo.placeLabel(notBoolean);
            }
        }
    }

    private void compileStringCheck2(CompilerService compiler, Generator ga, TypeHierarchy th, ItemType predicateItemType, LabelInfo end, boolean oneOrMoreCheck, int seqItrVar, int resultVar, int firstVar) {
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        int relToString = th.relationship(predicateItemType, BuiltInAtomicType.STRING);
        if (relToString != 4) {
            FilterExpressionCompiler.visitAnnotation(compiler, "FilterExpressionCompiler.compilePredicate: test string value");
            LabelInfo notString = null;
            if (relToString != 0 && relToString != 2) {
                notString = methodInfo.newLabel("notString_compileStringCheck2");
                ga.loadLocal(firstVar);
                ga.instanceOf(Type.getType(StringValue.class));
                ga.ifZCmp(153, notString.label());
            }
            ga.loadLocal(firstVar);
            ga.checkClass(StringValue.class);
            ga.invokeInstanceMethod(StringValue.class, "isZeroLength", new Class[0]);
            ga.not();
            ga.storeLocal(resultVar);
            if (oneOrMoreCheck) {
                ga.loadLocal(seqItrVar);
                ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
                ga.ifNull(end.label());
                ga.push("sequence of two or more items starting with a string value");
                ga.invokeStaticMethod(ExpressionTool.class, "ebvError", String.class);
            }
            ga.goTo(end);
            if (notString != null) {
                methodInfo.placeLabel(notString);
            }
        }
    }

    private void compileNodeCheck2(CompilerService compiler, Generator ga, TypeHierarchy th, ItemType predicateItemType, LabelInfo end, int resultVar, int itemVar) {
        int relToNode = th.relationship(predicateItemType, AnyNodeTest.getInstance());
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        LabelInfo nextCheck = methodInfo.newLabel("nextcheck");
        if (relToNode == 0 || relToNode == 2) {
            FilterExpressionCompiler.visitAnnotation(compiler, "FilterExpressionCompiler.compilePredicate(): node exists");
            ga.push(true);
            ga.storeLocal(resultVar);
            ga.goTo(end);
        } else if (relToNode != 4) {
            FilterExpressionCompiler.visitAnnotation(compiler, "FilterExpressionCompiler.compilePredicate(): test node existence");
            ga.loadLocal(itemVar);
            ga.ifNotInstance(NodeInfo.class, nextCheck);
            ga.push(true);
            ga.storeLocal(resultVar);
            ga.goTo(end);
            methodInfo.placeLabel(nextCheck);
        }
    }
}

