/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToBooleanCompiler;
import com.saxonica.ee.bytecode.ValueComparisonCompiler;
import com.saxonica.ee.bytecode.util.Callback;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.OnEmpty;
import java.util.Stack;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.CodepointCollatingComparer;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.ComparableAtomicValueComparer;
import net.sf.saxon.expr.sort.UntypedNumericComparer;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.NumericType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class GeneralComparisonCompiler
extends ToBooleanCompiler {
    @Override
    public void compileToBoolean(CompilerService compiler, Expression expression) throws CannotCompileException {
        switch (((GeneralComparison)expression).getComparisonCardinality()) {
            case 0: {
                this.compileToBooleanOneToOne(compiler, (GeneralComparison)expression);
                break;
            }
            case 1: {
                this.compileToBooleanManyToOne(compiler, (GeneralComparison)expression);
                break;
            }
            case 2: {
                this.compileToBooleanManyToMany(compiler, (GeneralComparison)expression);
            }
        }
    }

    private void compileToBooleanOneToOne(CompilerService compiler, GeneralComparison comparison) throws CannotCompileException {
        TypeHierarchy th = compiler.getConfiguration().getTypeHierarchy();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        GeneralComparisonCompiler.visitAnnotation(compiler, "GeneralComparison-OneToOne-boolean");
        Expression arg0 = comparison.getLhsExpression();
        Expression arg1 = comparison.getRhsExpression();
        AtomicType type0 = (AtomicType)arg0.getItemType().getPrimitiveItemType();
        AtomicType type1 = (AtomicType)arg1.getItemType().getPrimitiveItemType();
        LabelInfo returnTrue = methodInfo.newLabel("returnTrue");
        LabelInfo returnFalse = methodInfo.newLabel("returnFalse");
        LabelInfo end = methodInfo.newLabel("sngCompEnd");
        if ((type0.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || th.isSubType(type0, BuiltInAtomicType.STRING)) && (type1.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || th.isSubType(type1, BuiltInAtomicType.STRING))) {
            Stack<Class> unwindStack = new Stack<Class>();
            compiler.compileToPrimitive(arg0, String.class, new OnEmpty.UnwindAndJump(unwindStack, returnFalse));
            unwindStack.add(String.class);
            compiler.compileToPrimitive(arg1, String.class, new OnEmpty.UnwindAndJump(unwindStack, returnFalse));
            if (comparison.getAtomicComparer() instanceof CodepointCollatingComparer) {
                switch (comparison.getSingletonOperator()) {
                    case 50: {
                        ga.invokeInstanceMethod(Object.class, "equals", Object.class);
                        ga.goTo(end);
                        break;
                    }
                    case 51: {
                        ga.invokeInstanceMethod(Object.class, "equals", Object.class);
                        ga.not();
                        ga.goTo(end);
                        break;
                    }
                    default: {
                        ga.invokeStaticMethod(CodepointCollator.class, "compareCS", CharSequence.class, CharSequence.class);
                        ga.ifZCmp(ValueComparisonCompiler.translateOperator(comparison.getSingletonOperator()), returnTrue.label());
                        ga.goTo(returnFalse);
                        break;
                    }
                }
            } else {
                GeneralComparisonCompiler.allocateStatic(compiler, comparison.getAtomicComparer().getCollator());
                ga.dupX2();
                ga.pop();
                ga.invokeInstanceMethod(StringCollator.class, "compareStrings", CharSequence.class, CharSequence.class);
                ga.ifZCmp(ValueComparisonCompiler.translateOperator(comparison.getSingletonOperator()), returnTrue.label());
                ga.goTo(returnFalse);
            }
            methodInfo.placeLabel(returnTrue);
            ga.push(true);
            ga.goTo(end);
            methodInfo.placeLabel(returnFalse);
            ga.push(false);
            methodInfo.placeLabel(end);
        } else {
            compiler.compileToItem(arg0);
            if (Cardinality.allowsZero(arg0.getCardinality())) {
                LabelInfo nonNullArg0 = methodInfo.newLabel("nonNullArg0");
                ga.dup();
                ga.ifNonNull(nonNullArg0.label());
                ga.pop();
                ga.goTo(returnFalse);
                methodInfo.placeLabel(nonNullArg0);
            }
            compiler.compileToItem(arg1);
            if (Cardinality.allowsZero(arg1.getCardinality())) {
                LabelInfo nonNullArg1 = methodInfo.newLabel("nonNullArg1");
                ga.dup();
                ga.ifNonNull(nonNullArg1.label());
                ga.pop2();
                ga.goTo(returnFalse);
                methodInfo.placeLabel(nonNullArg1);
            }
            int item0Var = methodInfo.allocateLocal(AtomicValue.class);
            int item1Var = methodInfo.allocateLocal(AtomicValue.class);
            ga.checkClass(AtomicValue.class);
            ga.storeLocal(item1Var);
            ga.checkClass(AtomicValue.class);
            ga.storeLocal(item0Var);
            boolean checkTypes = comparison.needsRuntimeCheck();
            GeneralComparisonCompiler.generateComparisonCode(compiler, comparison, returnTrue, returnFalse, end, item0Var, item1Var, type0, type1, checkTypes);
            methodInfo.placeLabel(returnTrue);
            ga.push(true);
            ga.goTo(end);
            methodInfo.placeLabel(returnFalse);
            ga.push(false);
            methodInfo.placeLabel(end);
            methodInfo.releaseLocal(item0Var);
            methodInfo.releaseLocal(item1Var);
        }
    }

    private void compileToBooleanManyToOne(CompilerService compiler, GeneralComparison comparison) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        GeneralComparisonCompiler.visitAnnotation(compiler, "GeneralComparison-ManyToOne-boolean");
        Expression arg0 = comparison.getLhsExpression();
        Expression arg1 = comparison.getRhsExpression();
        AtomicType type0 = (AtomicType)arg0.getItemType().getPrimitiveItemType();
        AtomicType type1 = (AtomicType)arg1.getItemType().getPrimitiveItemType();
        LabelInfo returnTrue = methodInfo.newLabel("returnTrue");
        LabelInfo returnFalse = methodInfo.newLabel("returnFalse");
        LabelInfo end = methodInfo.newLabel("genCompEnd");
        compiler.compileToItem(arg1);
        if (Cardinality.allowsZero(arg1.getCardinality())) {
            LabelInfo nonNullArg1 = methodInfo.newLabel("nonNullArg1");
            ga.dup();
            ga.ifNonNull(nonNullArg1.label());
            ga.pop();
            ga.goTo(returnFalse);
            methodInfo.placeLabel(nonNullArg1);
        }
        int item0Var = methodInfo.allocateLocal(AtomicValue.class);
        int item1Var = methodInfo.allocateLocal(AtomicValue.class);
        ga.checkClass(AtomicValue.class);
        ga.storeLocal(item1Var);
        compiler.compileToIterator(arg0);
        int iter0Var = methodInfo.allocateLocal(SequenceIterator.class);
        ga.storeLocal(iter0Var);
        LabelInfo loop = methodInfo.placeNewLabel("compLoop");
        LabelInfo out = methodInfo.newLabel("compout");
        ga.loadLocal(iter0Var);
        ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
        ga.checkClass(AtomicValue.class);
        ga.storeLocal(item0Var);
        ga.loadLocal(item0Var);
        ga.ifNull(returnFalse.label());
        boolean checkTypes = comparison.needsRuntimeCheck();
        GeneralComparisonCompiler.generateComparisonCode(compiler, comparison, returnTrue, loop, out, item0Var, item1Var, type0, type1, checkTypes);
        methodInfo.placeLabel(out);
        ga.ifTrue(returnTrue);
        ga.goTo(loop);
        methodInfo.placeLabel(returnTrue);
        ga.loadLocal(iter0Var);
        ga.invokeInstanceMethod(SequenceIterator.class, "close", new Class[0]);
        ga.push(true);
        ga.goTo(end);
        methodInfo.placeLabel(returnFalse);
        ga.push(false);
        methodInfo.placeLabel(end);
        methodInfo.releaseLocal(item0Var);
        methodInfo.releaseLocal(item1Var);
        methodInfo.releaseLocal(iter0Var);
    }

    public void compileToBooleanManyToMany(CompilerService compiler, GeneralComparison comparison) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        Expression arg0 = comparison.getLhsExpression();
        Expression arg1 = comparison.getRhsExpression();
        GeneralComparisonCompiler.allocateStatic(compiler, comparison);
        compiler.compileToIterator(arg0);
        compiler.compileToIterator(arg1);
        compiler.generateGetContext();
        ga.invokeInstanceMethod(GeneralComparison.class, "evaluateManyToMany", SequenceIterator.class, SequenceIterator.class, XPathContext.class);
    }

    public static void generateComparisonCode(CompilerService compiler, ComparisonExpression comparison, LabelInfo returnTrue, LabelInfo returnFalse, LabelInfo end, int item0Var, int item1Var, AtomicType type0, AtomicType type1, boolean checkTypes) {
        block32: {
            int checkTypesVar;
            GeneratedMethodInfo methodInfo;
            Generator ga;
            block33: {
                int op;
                block31: {
                    Converter untypedToOther;
                    TypeHierarchy th = compiler.getConfiguration().getTypeHierarchy();
                    ga = compiler.getCurrentGenerator();
                    methodInfo = compiler.getCurrentMethod();
                    ConversionRules rules = compiler.getConfiguration().getConversionRules();
                    GeneralComparisonCompiler.visitAnnotation(compiler, "generateComparisonCode-GeneralComp");
                    LabelInfo notUntyped0 = methodInfo.newLabel("notUntyped0");
                    LabelInfo notNumeric0 = methodInfo.newLabel("notNumeric0");
                    LabelInfo doneConversion0 = methodInfo.newLabel("doneConversion0");
                    LabelInfo notUntyped1 = methodInfo.newLabel("notUntyped1");
                    LabelInfo notNumeric1 = methodInfo.newLabel("notNumeric1");
                    LabelInfo doneConversion1 = methodInfo.newLabel("doneConversion1");
                    checkTypesVar = methodInfo.allocateLocal(Boolean.TYPE);
                    ga.push(checkTypes);
                    ga.storeLocal(checkTypesVar);
                    if (th.relationship(type0, BuiltInAtomicType.UNTYPED_ATOMIC) != 4) {
                        ga.loadArgOrLocal(item0Var);
                        ga.ifNotInstance(UntypedAtomicValue.class, notUntyped0);
                        ga.loadArgOrLocal(item1Var);
                        ga.ifInstance(UntypedAtomicValue.class, doneConversion1);
                        if (th.relationship(type1, NumericType.getInstance()) != 4) {
                            ga.loadArgOrLocal(item1Var);
                            ga.ifNotInstance(NumericValue.class, notNumeric0);
                            ga.loadArgOrLocal(item0Var);
                            ga.checkClass(UntypedAtomicValue.class);
                            ga.loadArgOrLocal(item1Var);
                            ga.checkClass(NumericValue.class);
                            ga.push(comparison.getSingletonOperator());
                            GeneralComparisonCompiler.allocateStatic(compiler, compiler.getConfiguration().getConversionRules());
                            ga.invokeStaticMethod(UntypedNumericComparer.class, "quickCompare", UntypedAtomicValue.class, NumericValue.class, Integer.TYPE, ConversionRules.class);
                            ga.goTo(end);
                            methodInfo.placeLabel(notNumeric0);
                        }
                        if (type1 == BuiltInAtomicType.ANY_ATOMIC) {
                            GeneralComparisonCompiler.allocateStatic(compiler, rules);
                            ga.getStaticField(BuiltInAtomicType.class, "UNTYPED_ATOMIC", BuiltInAtomicType.class);
                            ga.loadArgOrLocal(item1Var);
                            ga.invokeInstanceMethod(AtomicValue.class, "getPrimitiveType", new Class[0]);
                            ga.invokeInstanceMethod(ConversionRules.class, "getConverter", AtomicType.class, AtomicType.class);
                        } else {
                            untypedToOther = rules.getConverter(BuiltInAtomicType.UNTYPED_ATOMIC, type1);
                            GeneralComparisonCompiler.allocateStatic(compiler, untypedToOther);
                        }
                        ga.loadArgOrLocal(item0Var);
                        ga.invokeInstanceMethod(Converter.class, "convert", AtomicValue.class);
                        ga.invokeInstanceMethod(ConversionResult.class, "asAtomic", new Class[0]);
                        ga.storeArgOrLocal(item0Var);
                        ga.push(false);
                        ga.storeLocal(checkTypesVar);
                        methodInfo.placeLabel(doneConversion0);
                        methodInfo.placeLabel(notUntyped0);
                    }
                    if (th.relationship(type1, BuiltInAtomicType.UNTYPED_ATOMIC) != 4) {
                        if (type1 != BuiltInAtomicType.UNTYPED_ATOMIC) {
                            ga.loadArgOrLocal(item1Var);
                            ga.ifNotInstance(UntypedAtomicValue.class, notUntyped1);
                        }
                        if (th.relationship(type0, NumericType.getInstance()) != 4) {
                            ga.loadArgOrLocal(item0Var);
                            ga.ifNotInstance(NumericValue.class, notNumeric1);
                            ga.loadArgOrLocal(item1Var);
                            ga.checkClass(UntypedAtomicValue.class);
                            ga.loadArgOrLocal(item0Var);
                            ga.checkClass(NumericValue.class);
                            ga.push(Token.inverse(comparison.getSingletonOperator()));
                            GeneralComparisonCompiler.allocateStatic(compiler, compiler.getConfiguration().getConversionRules());
                            ga.invokeStaticMethod(UntypedNumericComparer.class, "quickCompare", UntypedAtomicValue.class, NumericValue.class, Integer.TYPE, ConversionRules.class);
                            ga.goTo(end);
                            methodInfo.placeLabel(notNumeric1);
                        }
                        if (type0 == BuiltInAtomicType.ANY_ATOMIC) {
                            GeneralComparisonCompiler.allocateStatic(compiler, rules);
                            ga.getStaticField(BuiltInAtomicType.class, "UNTYPED_ATOMIC", BuiltInAtomicType.class);
                            ga.loadArgOrLocal(item0Var);
                            ga.invokeInstanceMethod(AtomicValue.class, "getPrimitiveType", new Class[0]);
                            ga.invokeInstanceMethod(ConversionRules.class, "getConverter", AtomicType.class, AtomicType.class);
                            ga.loadArgOrLocal(item1Var);
                            ga.invokeInstanceMethod(Converter.class, "convert", AtomicValue.class);
                            ga.invokeInstanceMethod(ConversionResult.class, "asAtomic", new Class[0]);
                            ga.storeArgOrLocal(item1Var);
                            ga.push(false);
                            ga.storeLocal(checkTypesVar);
                            ga.goTo(doneConversion1);
                        } else if (type0 != BuiltInAtomicType.STRING) {
                            untypedToOther = rules.getConverter(BuiltInAtomicType.UNTYPED_ATOMIC, type0);
                            GeneralComparisonCompiler.allocateStatic(compiler, untypedToOther);
                            ga.loadArgOrLocal(item1Var);
                            ga.invokeInstanceMethod(Converter.class, "convert", AtomicValue.class);
                            ga.invokeInstanceMethod(ConversionResult.class, "asAtomic", new Class[0]);
                            ga.storeArgOrLocal(item1Var);
                            ga.push(false);
                            ga.storeLocal(checkTypesVar);
                            ga.goTo(doneConversion1);
                        }
                    }
                    methodInfo.placeLabel(doneConversion1);
                    methodInfo.placeLabel(notUntyped1);
                    if (checkTypes) {
                        LabelInfo doneCheckingTypes = methodInfo.newLabel("doneCheckingTypes");
                        ga.loadLocal(checkTypesVar);
                        ga.ifFalse(doneCheckingTypes);
                        ga.loadArgOrLocal(item0Var);
                        ga.invokeInstanceMethod(AtomicValue.class, "getPrimitiveType", new Class[0]);
                        ga.loadArgOrLocal(item1Var);
                        ga.invokeInstanceMethod(AtomicValue.class, "getPrimitiveType", new Class[0]);
                        ga.push(Token.isOrderedOperator(comparison.getSingletonOperator()));
                        ga.invokeStaticMethod(Type.class, "isGuaranteedComparable", BuiltInAtomicType.class, BuiltInAtomicType.class, Boolean.TYPE);
                        ga.ifTrue(doneCheckingTypes);
                        ga.loadArgOrLocal(item0Var);
                        ga.loadArgOrLocal(item1Var);
                        ga.push(((Expression)((Object)comparison)).getLocation().getSystemId());
                        ga.push(((Expression)((Object)comparison)).getLocation().getLineNumber());
                        ga.invokeStaticMethod(Callback.class, "makeNonComparableException", AtomicValue.class, AtomicValue.class, String.class, Integer.TYPE);
                        ga.throwException();
                        methodInfo.placeLabel(doneCheckingTypes);
                    }
                    if (th.relationship(type0, BuiltInAtomicType.DOUBLE) != 4 || th.relationship(type0, BuiltInAtomicType.FLOAT) != 4) {
                        ga.loadArgOrLocal(item0Var);
                        ga.invokeInstanceMethod(AtomicValue.class, "isNaN", new Class[0]);
                        ga.ifTrue(comparison.getSingletonOperator() == 51 ? returnTrue : returnFalse);
                    }
                    if (th.relationship(type1, BuiltInAtomicType.DOUBLE) != 4 || th.relationship(type1, BuiltInAtomicType.FLOAT) != 4) {
                        ga.loadArgOrLocal(item1Var);
                        ga.invokeInstanceMethod(AtomicValue.class, "isNaN", new Class[0]);
                        ga.ifTrue(comparison.getSingletonOperator() == 51 ? returnTrue : returnFalse);
                    }
                    op = comparison.getSingletonOperator();
                    if (!(comparison.getAtomicComparer() instanceof ComparableAtomicValueComparer)) break block31;
                    switch (op) {
                        case 50: 
                        case 51: {
                            ga.loadLocal(item0Var);
                            ga.loadLocal(item1Var);
                            ga.invokeInstanceMethod(AtomicValue.class, "equals", Object.class);
                            if (op == 51) {
                                ga.not();
                            }
                            ga.goTo(end);
                            break block32;
                        }
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: {
                            ga.loadLocal(item0Var);
                            ga.checkClass(Comparable.class);
                            ga.loadLocal(item1Var);
                            ga.invokeInstanceMethod(Comparable.class, "compareTo", Object.class);
                            ga.ifZCmp(ValueComparisonCompiler.translateOperator(op), returnTrue.label());
                            ga.goTo(returnFalse);
                            break block32;
                        }
                        default: {
                            throw new IllegalStateException("unknown operator");
                        }
                    }
                }
                if (!(comparison.getAtomicComparer() instanceof CodepointCollatingComparer)) break block33;
                switch (op) {
                    case 50: 
                    case 51: {
                        ga.loadLocal(item0Var);
                        ga.checkClass(StringValue.class);
                        ga.loadLocal(item1Var);
                        ga.checkClass(StringValue.class);
                        ga.invokeInstanceMethod(StringValue.class, "codepointEquals", StringValue.class);
                        if (op == 51) {
                            ga.not();
                        }
                        ga.goTo(end);
                        break block32;
                    }
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: {
                        boolean lhsIsBmp = comparison.getLhsExpression() instanceof StringLiteral && !UnicodeString.containsSurrogatePairs(((StringLiteral)comparison.getLhsExpression()).getStringValue());
                        boolean rhsIsBmp = comparison.getRhsExpression() instanceof StringLiteral && !UnicodeString.containsSurrogatePairs(((StringLiteral)comparison.getRhsExpression()).getStringValue());
                        LabelInfo hasSurrogates = methodInfo.newLabel("hasSurrogates");
                        LabelInfo noSurrogates = methodInfo.newLabel("noSurrogates");
                        LabelInfo comparisonDone = methodInfo.newLabel("comparisonDone");
                        if (!lhsIsBmp) {
                            ga.loadLocal(item0Var);
                            ga.checkClass(StringValue.class);
                            ga.invokeInstanceMethod(StringValue.class, "containsSurrogatePairs", new Class[0]);
                            ga.ifZCmp(154, hasSurrogates.label());
                        }
                        if (rhsIsBmp) {
                            ga.goTo(noSurrogates.label());
                        } else {
                            ga.loadLocal(item1Var);
                            ga.checkClass(StringValue.class);
                            ga.invokeInstanceMethod(StringValue.class, "containsSurrogatePairs", new Class[0]);
                            ga.ifZCmp(153, noSurrogates.label());
                        }
                        methodInfo.placeLabel(hasSurrogates);
                        ga.loadLocal(item0Var);
                        ga.invokeInstanceMethod(AtomicValue.class, "getStringValueCS", new Class[0]);
                        ga.loadLocal(item1Var);
                        ga.invokeInstanceMethod(AtomicValue.class, "getStringValueCS", new Class[0]);
                        ga.invokeStaticMethod(CodepointCollator.class, "compareCS", CharSequence.class, CharSequence.class);
                        ga.goTo(comparisonDone);
                        methodInfo.placeLabel(noSurrogates);
                        ga.loadLocal(item0Var);
                        ga.invokeInstanceMethod(AtomicValue.class, "getStringValue", new Class[0]);
                        ga.loadLocal(item1Var);
                        ga.invokeInstanceMethod(AtomicValue.class, "getStringValue", new Class[0]);
                        ga.invokeInstanceMethod(String.class, "compareTo", Object.class);
                        methodInfo.placeLabel(comparisonDone);
                        ga.ifZCmp(ValueComparisonCompiler.translateOperator(op), returnTrue.label());
                        ga.goTo(returnFalse);
                        break block32;
                    }
                    default: {
                        throw new IllegalStateException("unknown operator");
                    }
                }
            }
            GeneralComparisonCompiler.allocateStatic(compiler, comparison.getAtomicComparer());
            compiler.generateGetContext();
            ga.invokeInstanceMethod(AtomicComparer.class, "provideContext", XPathContext.class);
            ga.loadArgOrLocal(item0Var);
            ga.loadArgOrLocal(item1Var);
            LabelInfo L0 = methodInfo.newLabel("L0");
            LabelInfo L1 = methodInfo.newLabel("L1");
            LabelInfo L2 = methodInfo.newLabel("L2");
            ga.visitTryCatchBlock(L0, L1, L2, "java/lang/ClassCastException");
            methodInfo.placeLabel(L0);
            switch (comparison.getSingletonOperator()) {
                case 50: {
                    ga.invokeInstanceMethod(AtomicComparer.class, "comparesEqual", AtomicValue.class, AtomicValue.class);
                    methodInfo.placeLabel(L1);
                    ga.goTo(end);
                    break;
                }
                case 51: {
                    ga.invokeInstanceMethod(AtomicComparer.class, "comparesEqual", AtomicValue.class, AtomicValue.class);
                    methodInfo.placeLabel(L1);
                    ga.not();
                    ga.goTo(end);
                    break;
                }
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    ga.invokeInstanceMethod(AtomicComparer.class, "compareAtomicValues", AtomicValue.class, AtomicValue.class);
                    methodInfo.placeLabel(L1);
                    ga.ifZCmp(ValueComparisonCompiler.translateOperator(comparison.getSingletonOperator()), returnTrue.label());
                    ga.goTo(returnFalse);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown operator");
                }
            }
            methodInfo.releaseLocal(checkTypesVar);
            methodInfo.placeLabel(L2);
            ga.pop();
            ga.loadLocal(item0Var);
            ga.loadLocal(item1Var);
            ga.push(((Expression)((Object)comparison)).getLocation().getSystemId());
            ga.push(((Expression)((Object)comparison)).getLocation().getLineNumber());
            ga.invokeStaticMethod(Callback.class, "makeNonComparableException", AtomicValue.class, AtomicValue.class, String.class, Integer.TYPE);
            ga.throwException();
            ga.goTo(end.label());
        }
    }
}

