/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.LetExpressionCompiler;
import com.saxonica.ee.bytecode.ToIteratorCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.objectweb.asm.Type;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.ContextOriginator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.Evaluator;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.value.EmptySequence;

public class UserFunctionCallCompiler
extends ToIteratorCompiler {
    @Override
    public void compileToIterator(CompilerService compiler, Expression expression) throws CannotCompileException {
        UserFunctionCallCompiler.visitAnnotation(compiler, "UserFunctionCallCompiler-Itr");
        this.compileFunctionCall(compiler, expression, true);
        Generator ga = compiler.getCurrentGenerator();
        ga.invokeInstanceMethod(Sequence.class, "iterate", new Class[0]);
    }

    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        UserFunctionCallCompiler.visitAnnotation(compiler, "UserFunctionCallCompiler-Item");
        this.compileFunctionCall(compiler, expression, true);
        Generator ga = compiler.getCurrentGenerator();
        ga.invokeInstanceMethod(Sequence.class, "head", new Class[0]);
    }

    @Override
    public void compileToPush(CompilerService compiler, Expression expression) throws CannotCompileException {
        UserFunctionCallCompiler.visitAnnotation(compiler, "UserFunctionCallCompiler-Push");
        this.compileFunctionCall(compiler, expression, false);
    }

    public void compileFunctionCall(CompilerService compiler, Expression expression, boolean pull) throws CannotCompileException {
        UserFunctionCall userFunctionCall = (UserFunctionCall)expression;
        UserFunction provisionalFunction = userFunctionCall.getFunction();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        LabelInfo end = methodInfo.newLabel("endUFC");
        int numArgs = userFunctionCall.getArity();
        if (userFunctionCall.getArgumentEvaluators() == null) {
            userFunctionCall.allocateArgumentEvaluators();
        }
        Evaluator[] argumentEvaluators = userFunctionCall.getArgumentEvaluators();
        ga.push(numArgs);
        ga.newArray(Type.getType(Sequence.class));
        int arrVar = methodInfo.allocateLocal(Sequence[].class);
        ga.storeLocal(arrVar);
        for (int i = 0; i < numArgs; ++i) {
            LabelInfo notNull = methodInfo.newLabel("notNullUFC" + i);
            int refs = 10;
            ga.loadLocal(arrVar);
            ga.push(i);
            LetExpressionCompiler.compileCommonExpr(compiler, userFunctionCall.getArg(i), argumentEvaluators[i].getCode(), refs);
            ga.dup();
            ga.ifNonNull(notNull.label());
            ga.pop();
            ga.invokeStaticMethod(EmptySequence.class, "getInstance", new Class[0]);
            methodInfo.placeLabel(notNull);
            ga.arrayStore(Type.getType(Sequence.class));
        }
        if (userFunctionCall.isRecursiveTailCall()) {
            compiler.generateGetContext();
            ga.checkClass(XPathContextMajor.class);
            ga.loadLocal(arrVar);
            ga.invokeInstanceMethod(XPathContextMajor.class, "resetParameterValues", Sequence[].class);
            UserFunctionCallCompiler.visitAnnotation(compiler, "RecursiveTailCall");
            ga.goTo(methodInfo.getTailCallLabel());
        } else if (userFunctionCall.getBindingSlot() >= 0) {
            compiler.generateGetContext();
            ga.push(userFunctionCall.getBindingSlot());
            ga.invokeInstanceMethod(XPathContext.class, "getTargetComponent", Integer.TYPE);
            int componentVar = methodInfo.allocateLocal(Component.class);
            ga.dup();
            ga.storeLocal(componentVar);
            ga.invokeInstanceMethod(Component.class, "isHiddenAbstractComponent", new Class[0]);
            LabelInfo notAbstract = methodInfo.newLabel("notAbstract");
            ga.ifFalse(notAbstract);
            compiler.generateDynamicError("Cannot call an abstract function (" + userFunctionCall.getDisplayName() + "#" + userFunctionCall.getArity() + ") with no implementation", "XTDE3052", expression.getLocation(), false);
            ga.throwException();
            methodInfo.placeLabel(notAbstract);
            ga.loadLocal(componentVar);
            ga.invokeInstanceMethod(Component.class, "getActor", new Class[0]);
            ga.checkClass(UserFunction.class);
            ga.dup();
            compiler.generateGetContext();
            ga.pushNull();
            ga.invokeInstanceMethod(UserFunction.class, "makeNewContext", XPathContext.class, ContextOriginator.class);
            ga.dup();
            ga.loadLocal(componentVar);
            ga.invokeInstanceMethod(XPathContextMajor.class, "setCurrentComponent", Component.class);
            ga.loadLocal(arrVar);
            if (pull) {
                ga.invokeInstanceMethod(UserFunction.class, "call", XPathContext.class, Sequence[].class);
            } else {
                ga.swap();
                ga.invokeInstanceMethod(UserFunction.class, "process", Sequence[].class, XPathContextMajor.class);
            }
        } else {
            UserFunctionCallCompiler.allocateStatic(compiler, provisionalFunction);
            ga.dup();
            compiler.generateGetContext();
            ga.pushNull();
            ga.invokeInstanceMethod(UserFunction.class, "makeNewContext", XPathContext.class, ContextOriginator.class);
            if (pull) {
                ga.loadLocal(arrVar);
                ga.invokeInstanceMethod(UserFunction.class, "call", XPathContext.class, Sequence[].class);
            } else {
                ga.loadLocal(arrVar);
                ga.swap();
                ga.invokeInstanceMethod(UserFunction.class, "process", Sequence[].class, XPathContextMajor.class);
            }
        }
        methodInfo.placeLabel(end);
        methodInfo.releaseLocal(arrVar);
    }
}

