/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.ee.schema.Facet;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.UserSimpleType;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public class WhitespaceFacet
extends Facet {
    int action;

    @Override
    public boolean isConstraining() {
        return false;
    }

    @Override
    public String getName() {
        return "whiteSpace";
    }

    public void setValue(String value) throws SchemaException {
        if (value.equals("preserve")) {
            this.action = 0;
        } else if (value.equals("replace")) {
            this.action = 1;
        } else if (value.equals("collapse")) {
            this.action = 2;
        } else {
            throw new SchemaException("Invalid whiteSpace facet value: " + value);
        }
    }

    @Override
    public String getValue() {
        switch (this.action) {
            case 0: {
                return "preserve";
            }
            case 1: {
                return "replace";
            }
            case 2: {
                return "collapse";
            }
        }
        return null;
    }

    @Override
    public int getWhitespaceAction() {
        return this.action;
    }

    @Override
    public void checkFacetRestriction(UserSimpleType type, SimpleType base, SchemaCompiler compiler) throws SchemaException, ValidationException {
        if (base.isListType()) {
            if (this.action != 2) {
                throw new SchemaException("The whiteSpace facet on a list type must be {collapse}");
            }
        } else {
            if (base.isUnionType()) {
                throw new SchemaException("The whiteSpace facet is not applicable to a union type");
            }
            if (!(base instanceof AnySimpleType)) {
                int p = ((AtomicType)base).getPrimitiveType();
                if (type.getFingerprint() != 513) {
                    if (p == 513) {
                        if (this.action < base.getWhitespaceAction()) {
                            throw new SchemaException("The whiteSpace normalization must not be weaker than that of the base type");
                        }
                    } else if (this.action != 2) {
                        throw new SchemaException("The whiteSpace facet must be {collapse} unless the type is derived from string");
                    }
                }
            }
        }
    }

    @Override
    public boolean testAtomicValue(AtomicValue value) {
        return true;
    }

    @Override
    public Function getFacetAsFunctionItem() {
        Callable callable = new Callable(){

            public Sequence<?> call(XPathContext context, Sequence[] arguments) throws XPathException {
                String key;
                switch (key = arguments[0].head().getStringValue()) {
                    case "class": {
                        return new StringValue(WhitespaceFacet.this.getName());
                    }
                    case "implementation": {
                        return new ObjectValue<WhitespaceFacet>(WhitespaceFacet.this);
                    }
                    case "value": {
                        switch (WhitespaceFacet.this.action) {
                            default: {
                                return new StringValue("preserve");
                            }
                            case 2: {
                                return new StringValue("collapse");
                            }
                            case 1: 
                        }
                        return new StringValue("replace");
                    }
                    case "fixed": {
                        return BooleanValue.get(WhitespaceFacet.this.isFixed());
                    }
                }
                return EmptySequence.getInstance();
            }
        };
        return new CallableFunction(1, callable, SchemaComponent.COMPONENT_FUNCTION_TYPE);
    }
}

