/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korapxmltools;

import de.ids_mannheim.korapxmltools.KorapXml2Conllu;
import de.ids_mannheim.korapxmltools.ParserToolBridge;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maltparser.MaltParserService;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.syntaxgraph.DependencyStructure;
import org.maltparser.core.syntaxgraph.edge.Edge;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J:\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u00152\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lde/ids_mannheim/korapxmltools/MaltParserBridge;", "Lde/ids_mannheim/korapxmltools/ParserToolBridge;", "model", "", "logger", "Ljava/util/logging/Logger;", "<init>", "(Ljava/lang/String;Ljava/util/logging/Logger;)V", "getModel", "()Ljava/lang/String;", "getLogger", "()Ljava/util/logging/Logger;", "foundry", "getFoundry", "tagger", "Lorg/maltparser/MaltParserService;", "getTagger", "()Lorg/maltparser/MaltParserService;", "tagSentence", "", "sentenceTokens", "", "sentenceTokenOffsets", "morpho", "", "Lde/ids_mannheim/korapxmltools/KorapXml2Conllu$MorphoSpan;", "app"})
@SourceDebugExtension(value={"SMAP\nMaltParserBridge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MaltParserBridge.kt\nde/ids_mannheim/korapxmltools/MaltParserBridge\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n37#2,2:53\n1863#3,2:55\n*S KotlinDebug\n*F\n+ 1 MaltParserBridge.kt\nde/ids_mannheim/korapxmltools/MaltParserBridge\n*L\n35#1:53,2\n37#1:55,2\n*E\n"})
public final class MaltParserBridge
extends ParserToolBridge {
    @NotNull
    private final String model;
    @NotNull
    private final Logger logger;
    @NotNull
    private final String foundry;
    @NotNull
    private final MaltParserService tagger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaltParserBridge(@NotNull String model, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter(model, "model");
        Intrinsics.checkNotNullParameter(logger, "logger");
        this.model = model;
        this.logger = logger;
        this.foundry = "malt";
        this.getLogger().info("Initializing MaltParser with model " + this.getModel());
        Class<MaltParserService> clazz = MaltParserService.class;
        synchronized (clazz) {
            boolean bl = false;
            this.tagger = new MaltParserService();
            if (StringsKt.contains$default((CharSequence)this.getModel(), "/", false, 2, null)) {
                String dirName = StringsKt.substringBeforeLast$default(this.getModel(), "/", null, 2, null);
                String modelName = StringsKt.substringAfterLast$default(this.getModel(), "/", null, 2, null);
                this.getLogger().info("Loading model " + modelName + " from " + dirName);
                this.tagger.initializeParserModel("-w " + dirName + " -c " + modelName + " -m parse");
            } else {
                this.tagger.initializeParserModel("-c " + this.getModel() + " -m parse");
            }
            this.getLogger().info("Model " + this.getModel() + " loaded");
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    @NotNull
    public String getModel() {
        return this.model;
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    @NotNull
    public String getFoundry() {
        return this.foundry;
    }

    @NotNull
    public final MaltParserService getTagger() {
        return this.tagger;
    }

    @Override
    public void tagSentence(@NotNull List<String> sentenceTokens, @NotNull List<String> sentenceTokenOffsets, @Nullable Map<String, KorapXml2Conllu.MorphoSpan> morpho) throws MaltChainedException {
        Intrinsics.checkNotNullParameter(sentenceTokens, "sentenceTokens");
        Intrinsics.checkNotNullParameter(sentenceTokenOffsets, "sentenceTokenOffsets");
        Collection $this$toTypedArray$iv = sentenceTokens;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        DependencyStructure result2 = this.tagger.parse(thisCollection$iv.toArray(new String[0]));
        Intrinsics.checkNotNull(result2, "null cannot be cast to non-null type org.maltparser.core.syntaxgraph.DependencyStructure");
        SortedSet<Edge> sortedSet = result2.getEdges();
        Intrinsics.checkNotNullExpressionValue(sortedSet, "getEdges(...)");
        Iterable $this$forEach$iv = sortedSet;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KorapXml2Conllu.MorphoSpan old;
            Edge edge = (Edge)element$iv;
            boolean bl = false;
            int from = edge.getSource().getIndex();
            int head = edge.getTarget().getIndex();
            String label = edge.toString();
            if (!StringsKt.contains$default((CharSequence)label, "DEPREL:", false, 2, null)) continue;
            String rel = StringsKt.substringAfter$default(edge.toString(), "DEPREL:", null, 2, null);
            Map<String, KorapXml2Conllu.MorphoSpan> map2 = morpho;
            KorapXml2Conllu.MorphoSpan morphoSpan = old = map2 != null ? map2.get(sentenceTokenOffsets.get(head - 1)) : null;
            if (morpho == null) continue;
            KorapXml2Conllu.MorphoSpan morphoSpan2 = old;
            KorapXml2Conllu.MorphoSpan morphoSpan3 = old;
            KorapXml2Conllu.MorphoSpan morphoSpan4 = old;
            morpho.put(sentenceTokenOffsets.get(head - 1), new KorapXml2Conllu.MorphoSpan(morphoSpan2 != null ? morphoSpan2.getLemma() : null, null, morphoSpan3 != null ? morphoSpan3.getXpos() : null, morphoSpan4 != null ? morphoSpan4.getFeats() : null, String.valueOf(from), rel, null, null, 194, null));
        }
    }
}

