/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.lemmatizer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import opennlp.tools.cmdline.AbstractEvaluatorTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.lemmatizer.LemmaEvaluationErrorListener;
import opennlp.tools.cmdline.lemmatizer.LemmatizerFineGrainedReportListener;
import opennlp.tools.cmdline.lemmatizer.LemmatizerModelLoader;
import opennlp.tools.cmdline.params.EvaluatorParams;
import opennlp.tools.cmdline.params.FineGrainedEvaluatorParams;
import opennlp.tools.lemmatizer.LemmaSample;
import opennlp.tools.lemmatizer.LemmatizerEvaluator;
import opennlp.tools.lemmatizer.LemmatizerME;
import opennlp.tools.lemmatizer.LemmatizerModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LemmatizerEvaluatorTool
extends AbstractEvaluatorTool<LemmaSample, EvalToolParams> {
    private static final Logger logger = LoggerFactory.getLogger(LemmatizerEvaluatorTool.class);

    public LemmatizerEvaluatorTool() {
        super(LemmaSample.class, EvalToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "Measures the performance of the Lemmatizer model with the reference data";
    }

    @Override
    public void run(String format, String[] args2) {
        super.run(format, args2);
        LemmatizerModel model = (LemmatizerModel)new LemmatizerModelLoader().load(((EvalToolParams)this.params).getModel());
        LemmaEvaluationErrorListener missclassifiedListener = null;
        if (((EvalToolParams)this.params).getMisclassified().booleanValue()) {
            missclassifiedListener = new LemmaEvaluationErrorListener();
        }
        LemmatizerFineGrainedReportListener reportListener = null;
        File reportFile = ((EvalToolParams)this.params).getReportOutputFile();
        FileOutputStream reportOutputStream = null;
        if (reportFile != null) {
            CmdLineUtil.checkOutputFile("Report Output File", reportFile);
            try {
                reportOutputStream = new FileOutputStream(reportFile);
                reportListener = new LemmatizerFineGrainedReportListener(reportOutputStream);
            }
            catch (FileNotFoundException e) {
                throw new TerminateToolException(-1, "IO error while creating Lemmatizer fine-grained report file: " + e.getMessage());
            }
        }
        LemmatizerEvaluator evaluator = new LemmatizerEvaluator(new LemmatizerME(model), missclassifiedListener, reportListener);
        logger.info("Evaluating ... ");
        try {
            evaluator.evaluate(this.sampleStream);
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while reading test data: " + e.getMessage(), e);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        logger.info("done");
        if (reportListener != null) {
            logger.info("Writing fine-grained report to {}", (Object)((EvalToolParams)this.params).getReportOutputFile().getAbsolutePath());
            reportListener.writeReport();
            try {
                ((OutputStream)reportOutputStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        logger.info("Accuracy: {}", (Object)evaluator.getWordAccuracy());
    }

    static interface EvalToolParams
    extends EvaluatorParams,
    FineGrainedEvaluatorParams {
    }
}

