/*
 * Decompiled with CFR 0.152.
 */
package experimental.morfessor;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import experimental.morfessor.CharEncoder;
import experimental.morfessor.Expander;
import experimental.morfessor.Morpheme;
import experimental.morfessor.Splitter;
import experimental.morfessor.ViterbiDecoder;
import experimental.morfessor.Vocab;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import marmot.util.FileUtils;
import marmot.util.StringUtils;

public class Morfessor
implements Serializable,
Splitter {
    private static final long serialVersionUID = 1L;
    private CharEncoder encoder_;
    private ViterbiDecoder viterbi_;
    private Expander expander_;

    public Morfessor(String train_dir) {
        this(train_dir, null);
    }

    public Morfessor(String train_dir, CharEncoder encoder) {
        this.viterbi_ = new ViterbiDecoder(train_dir + "/viterbitagsplit2.ii.probs.gz");
        this.expander_ = new Expander(train_dir + "/viterbitagsplit2.ii.tagged.gz");
        this.encoder_ = encoder;
    }

    private List<Morpheme> split_(String word) {
        return this.expander_.expand(this.viterbi_.split(word));
    }

    public void setEncoder(CharEncoder encoder) {
        this.encoder_ = encoder;
    }

    @Override
    public List<String> split(String word) {
        return this.split(word, 200);
    }

    public List<String> split(String word, int length_limit) {
        LinkedList<String> list = new LinkedList<String>();
        for (String token2 : Vocab.tokenize(word)) {
            if (Vocab.isSpecial(token2)) {
                list.add(token2);
                continue;
            }
            String new_token = StringUtils.normalize(token2, StringUtils.Mode.lower);
            if (new_token.length() != token2.length()) {
                System.err.println(new_token + " ==> " + token2);
            }
            if (new_token.length() > length_limit) {
                list.add(new_token);
                continue;
            }
            if (this.encoder_ != null) {
                new_token = this.encoder_.encode(new_token);
            }
            List<Morpheme> morphemes = this.split_(new_token);
            int last_index = 0;
            for (Morpheme morph : morphemes) {
                int new_index = last_index + morph.getMorpheme().length();
                String string = token2.substring(last_index, new_index);
                last_index = new_index;
                list.add(string);
            }
        }
        return list;
    }

    public static void main(String[] args2) throws JSAPException, IOException {
        JSAP jsap = new JSAP();
        FlaggedOption opt = new FlaggedOption("morfessor").setRequired(true).setLongFlag("morfessor");
        jsap.registerParameter((Parameter)opt);
        opt = new FlaggedOption("encoder").setRequired(false).setLongFlag("encoder");
        jsap.registerParameter((Parameter)opt);
        JSAPResult config = jsap.parse(args2);
        if (!config.success()) {
            Iterator errs = config.getErrorMessageIterator();
            while (errs.hasNext()) {
                System.err.println("Error: " + errs.next());
            }
            System.err.println("Usage: ");
            System.err.println(jsap.getUsage());
            System.err.println(jsap.getHelp());
            System.err.println();
            System.exit(1);
        }
        CharEncoder encoder = null;
        if (config.getString("encoder") != null) {
            encoder = (CharEncoder)FileUtils.loadFromFile(config.getString("encoder"));
        }
        Morfessor m4 = new Morfessor(config.getString("morfessor"), encoder);
        BufferedReader console = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.print("morfessor> ");
            String commandLine = console.readLine();
            if (commandLine == null) break;
            if (commandLine.equals("")) continue;
            if (commandLine.equals("q") || commandLine.equals("e") || commandLine.equals("exit") || commandLine.equals("quit")) break;
            for (String morph : m4.split(commandLine)) {
                System.out.print(' ');
                System.out.print(morph);
            }
            System.out.println();
        }
    }
}

