/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.config;

import com.saxonica.config.EvaluationNuisance;
import com.saxonica.config.JavaExtensionLibrary;
import com.saxonica.config.JavaVerifier;
import com.saxonica.config.Verifier;
import com.saxonica.config.pe.ConfigurationReaderPE;
import com.saxonica.config.pe.StyleNodeFactoryPE;
import com.saxonica.expr.ObjectLookupExpression;
import com.saxonica.expr.SaxonSyntaxExtension;
import com.saxonica.expr.StaticQueryContextPE;
import com.saxonica.expr.XQueryParserExtensionPE;
import com.saxonica.functions.extfn.EXPathBinaryFunctionSet;
import com.saxonica.functions.extfn.EXPathFileFunctionSet;
import com.saxonica.functions.extfn.ObjectMap;
import com.saxonica.functions.extfn.VendorFunctionSetPE;
import com.saxonica.functions.registry.UseWhen40FunctionSet;
import com.saxonica.functions.registry.XPath40FunctionSet;
import com.saxonica.functions.registry.XQUpdate10FunctionSet;
import com.saxonica.functions.registry.XSLT40FunctionSet;
import com.saxonica.serialize.SerializerFactoryPE;
import com.saxonica.trans.ModePE;
import com.saxonica.trans.PackageLoaderPE;
import com.saxonica.xsltextn.ExtensionElementCreator;
import com.saxonica.xsltextn.ExtensionElementFactory;
import com.saxonica.xsltextn.style.SaxonElementFactory;
import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.MathFunctionSet;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.registry.BuiltInFunctionSet;
import net.sf.saxon.functions.registry.ExsltCommonFunctionSet;
import net.sf.saxon.functions.registry.OnDemandFunctionSet;
import net.sf.saxon.functions.registry.UseWhen30FunctionSet;
import net.sf.saxon.functions.registry.XPath20FunctionSet;
import net.sf.saxon.functions.registry.XPath30FunctionSet;
import net.sf.saxon.functions.registry.XPath31FunctionSet;
import net.sf.saxon.lib.ActiveSource;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.FeatureData;
import net.sf.saxon.lib.StaticQueryContextFactory;
import net.sf.saxon.ma.arrays.ArrayFunctionSet;
import net.sf.saxon.ma.map.MapFunctionSet;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.PatternParser;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.pull.PullSource;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryParser;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.XSLResultDocument;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.ConfigurationReader;
import net.sf.saxon.trans.LicenseException;
import net.sf.saxon.trans.SimpleMode;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.ObjectValue;

public class ProfessionalConfiguration
extends Configuration {
    private transient HashMap<String, FunctionLibrary> extensionBinders;
    private boolean licenseFound = false;
    private boolean licenseNotFound = false;
    private transient Verifier verifier;
    private transient HashMap<NamespaceUri, ExtensionElementCreator> xsltExtensionElementNamespaceMap;

    public ProfessionalConfiguration() {
        if (!"com.saxonica.config.ProfessionalConfiguration".equals(this.getClass().getName()) && !"com.saxonica.config.EnterpriseConfiguration".equals(this.getClass().getName())) {
            throw new LicenseException("Unauthorized subclass of Configuration", 6);
        }
        this.verifier = this.makeVerifier();
        this.declareBuiltInExtensionElementNamespaces();
        this.declareBuiltInExtensionFunctions();
        Version.platform.registerAllBuiltInObjectModels(this);
        this.setSerializerFactory(new SerializerFactoryPE(this));
        this.setStaticQueryContextFactory(new StaticQueryContextFactory(){

            @Override
            public StaticQueryContext newStaticQueryContext(Configuration config, boolean copyFromDefault) {
                return new StaticQueryContextPE(ProfessionalConfiguration.this, copyFromDefault);
            }
        });
        this.internalSetBooleanProperty(22, "http://saxon.sf.net/feature/disableXslEvaluate", false);
    }

    private Verifier makeVerifier() {
        return new JavaVerifier();
    }

    @Override
    protected ConfigurationReader makeConfigurationReader() {
        return new ConfigurationReaderPE();
    }

    public static Configuration makeProfessionalConfiguration(ClassLoader classLoader, String className) throws RuntimeException {
        if (className == null) {
            className = "com.saxonica.config.ProfessionalConfiguration";
        }
        try {
            return ProfessionalConfiguration.instantiateConfiguration(className, classLoader);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public String getEditionCode() {
        return "PE";
    }

    @Override
    public TypeHierarchy getTypeHierarchy() {
        if (this.typeHierarchy == null) {
            this.typeHierarchy = new TypeHierarchy(this);
        }
        return this.typeHierarchy;
    }

    @Override
    public PackageLoaderPE makePackageLoader() {
        return new PackageLoaderPE(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConfigurationProperty(String name, Object value) {
        if (name.equals("http://saxonica.com/oem-data")) {
            this.supplyLicenseKey(new BufferedReader(new StringReader((String)value)));
        } else if (name.equals(Feature.LICENSE_FILE_LOCATION.name)) {
            Verifier verifier = this.verifier;
            synchronized (verifier) {
                this.verifier.loadLicense((String)value);
                this.licenseFound = true;
                this.licenseNotFound = false;
                this.setLicensedFeatures();
            }
        } else {
            super.setConfigurationProperty(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setFeature(FeatureData feature, Object value) {
        String name = feature.uri;
        int code = feature.code;
        if (name.equals("http://saxonica.com/oem-data")) {
            this.supplyLicenseKey(new BufferedReader(new StringReader((String)value)));
        } else if (code == 37) {
            Verifier verifier = this.verifier;
            synchronized (verifier) {
                this.verifier.loadLicense((String)value);
                this.licenseFound = true;
                this.licenseNotFound = false;
                this.setLicensedFeatures();
            }
        } else if (code == 3) {
            this.internalSetBooleanProperty(3, "http://saxon.sf.net/feature/allow-old-java-uri-format", value);
            boolean b = ProfessionalConfiguration.requireBoolean("http://saxon.sf.net/feature/allow-old-java-uri-format", value);
            ((JavaExtensionLibrary)this.getExtensionBinder("java")).setStrictJavaUriFormat(!b);
        } else {
            super.setFeature(feature, value);
        }
    }

    public void supplyLicenseKey(Reader reader) {
        this.verifier.supplyLicenseKey(reader);
        this.licenseFound = true;
        this.licenseNotFound = false;
        this.setLicensedFeatures();
    }

    protected final void forceLoadLicense() throws LicenseException {
        this.verifier.loadLicense(this);
    }

    @Override
    public void importLicenseDetails(Configuration other) {
        if (other instanceof ProfessionalConfiguration) {
            ProfessionalConfiguration pc = (ProfessionalConfiguration)other;
            this.verifier = pc.verifier;
            this.licenseFound = pc.licenseFound;
            this.licenseNotFound = pc.licenseNotFound;
            this.setLicensedFeatures();
        }
    }

    protected String getFeature(String name) {
        String f = this.verifier.getFeature(name, this);
        if (!this.licenseFound) {
            this.licenseFound = true;
            this.licenseNotFound = false;
            this.setLicensedFeatures();
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkLicensedFeature(int feature, String name, int localLicenseId) throws LicenseException {
        if (feature != 8) {
            throw new LicenseException("Requested feature (" + name + ") requires Saxon-EE, but the current Configuration is an instance of com.saxonica.config.ProfessionalConfiguration", 6);
        }
        if (localLicenseId >= 0 && this.isFeatureAllowedBySecondaryLicense(localLicenseId, feature)) {
            return;
        }
        if (this.licenseNotFound) {
            try {
                this.loadLicense();
            }
            catch (Exception err) {
                int reason = err instanceof LicenseException ? ((LicenseException)err).getReason() : 5;
                String msg = err.getMessage() + ". A license is needed to use " + name;
                throw new LicenseException(msg, reason);
            }
        }
        if (this.licenseFound) {
            if (!this.testFeature(feature)) {
                throw new LicenseException("Requested feature (" + name + ") requires Saxon-EE, but the current Configuration is an instance of com.saxonica.config.ProfessionalConfiguration", 6);
            }
        } else {
            Verifier verifier = this.verifier;
            synchronized (verifier) {
                this.loadLicense();
                this.licenseFound = true;
                this.reportIfMissingLicenseFeature(feature, name);
            }
        }
    }

    @Override
    public void disableLicensing() {
        this.verifier.disableLicensing();
        this.licenseNotFound = true;
        this.licenseFound = false;
    }

    @Override
    public boolean isFeatureAllowedBySecondaryLicense(int localLicenseId, int feature) {
        return this.verifier.isFeatureAllowedBySecondaryLicense(localLicenseId, feature);
    }

    protected void reportIfMissingLicenseFeature(int feature, String name) {
        if (!this.testFeature(feature)) {
            throw new LicenseException("A valid license was found (" + this.verifier.getSerialNumber() + "), but does not support the requested feature (" + name + ")", 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isLicensedFeature(int feature) throws LicenseException {
        if (this.licenseNotFound) {
            return false;
        }
        Verifier verifier = this.verifier;
        synchronized (verifier) {
            if (!this.licenseFound) {
                try {
                    this.loadLicense();
                }
                catch (LicenseException e) {
                    if (e.getReason() == 3) {
                        this.licenseNotFound = true;
                        return false;
                    }
                    throw e;
                }
            }
            this.licenseFound = true;
            return this.testFeature(feature);
        }
    }

    @Override
    public final String getLicenseFeature(String name) {
        return this.verifier.getFeature(name, this);
    }

    @Override
    public Properties getLicenseFeatures() {
        return this.verifier.getLicenseFeatures(this);
    }

    protected final void loadLicense() throws LicenseException {
        this.verifier.loadPrimaryLicense(this);
        if (System.currentTimeMillis() % 100L == 42L && "yes".equals(this.verifier.getFeature("Evaluation", this))) {
            SerializerFactoryPE sf = new SerializerFactoryPE(this){

                @Override
                public Receiver getReceiver(Result result, SerializationProperties parameters, PipelineConfiguration pipe) throws XPathException {
                    Receiver r = super.getReceiver(result, parameters, pipe);
                    if (r instanceof EvaluationNuisance) {
                        return r;
                    }
                    return new EvaluationNuisance(r);
                }
            };
            this.setSerializerFactory(sf);
        }
        this.setLicensedFeatures();
    }

    protected void setLicensedFeatures() {
    }

    @Override
    public int registerLocalLicense(String dmk) {
        return this.verifier.registerSecondaryLicense(dmk);
    }

    protected boolean testFeature(int feature) {
        return feature == 8;
    }

    public boolean isLicenseNotFound() {
        return this.licenseNotFound;
    }

    public boolean isLicenseFound() {
        return this.licenseFound;
    }

    @Override
    public void displayLicenseMessage() {
        if (this.licenseNotFound) {
            if (this.isTiming()) {
                this.getLogger().info("No license file found - running with licensable features disabled");
            }
        } else {
            try {
                this.verifier.displayLicenseMessage(this);
                this.licenseFound = true;
                this.setLicensedFeatures();
            }
            catch (LicenseException err) {
                this.licenseFound = false;
                this.licenseNotFound = true;
                if (err.getReason() == 3) {
                    this.getLogger().info("No license file found - running with licensable features disabled");
                }
                throw err;
            }
        }
    }

    @Override
    public StyleNodeFactory makeStyleNodeFactory(Compilation compilation) {
        int feature;
        int locLic;
        PackageData pack = compilation.getPackageData();
        if (pack != null && !this.isFeatureAllowedBySecondaryLicense(locLic = pack.getLocalLicenseId(), feature = 8) && !this.isLicensedFeature(feature)) {
            return super.makeStyleNodeFactory(compilation);
        }
        return new StyleNodeFactoryPE(this, compilation);
    }

    @Override
    public XPathParser newExpressionParser(String language, boolean updating, StaticContext env) throws XPathException {
        if (updating) {
            throw new IllegalArgumentException("XQuery Update requires Saxon-EE");
        }
        if ("XQ".equals(language)) {
            XQueryParser parser = new XQueryParser(env);
            if (this.isLicensedFeature(8)) {
                parser.setParserExtension(new XQueryParserExtensionPE());
            }
            return parser;
        }
        if ("XP".equals(language)) {
            XPathParser parser = super.newExpressionParser(language, updating, env);
            if (this.isLicensedFeature(8)) {
                parser.setParserExtension(new SaxonSyntaxExtension());
            }
            return parser;
        }
        if ("PATTERN".equals(language)) {
            PatternParser parser = new PatternParser(env);
            if (this.isLicensedFeature(8)) {
                parser.setParserExtension(new SaxonSyntaxExtension());
            }
            return parser;
        }
        return super.newExpressionParser(language, updating, env);
    }

    @Override
    public BuiltInFunctionSet getXSLTFunctionSet(int version) {
        if (version == 40) {
            return XSLT40FunctionSet.getInstance();
        }
        return super.getXSLTFunctionSet(version);
    }

    @Override
    public BuiltInFunctionSet getXPathFunctionSet(int version) {
        switch (version) {
            case 20: {
                return XPath20FunctionSet.getInstance();
            }
            case 30: 
            case 305: {
                return XPath30FunctionSet.getInstance();
            }
            case 31: {
                return XPath31FunctionSet.getInstance();
            }
            case 40: {
                return XPath40FunctionSet.getInstance();
            }
        }
        return XPath31FunctionSet.getInstance();
    }

    @Override
    public BuiltInFunctionSet getXQueryUpdateFunctionSet() {
        return XQUpdate10FunctionSet.getInstance();
    }

    public SystemFunction makeSystemFunction(String localName, int arity) {
        try {
            return this.getXSLTFunctionSet(30).makeFunction(localName, arity);
        }
        catch (XPathException e) {
            return null;
        }
    }

    @Override
    public SystemFunction makeSystemFunction40(String localName, int arity) {
        try {
            return this.getXSLTFunctionSet(40).makeFunction(localName, arity);
        }
        catch (XPathException e) {
            return null;
        }
    }

    public void setExtensionBinder(String scheme, FunctionLibrary binder) {
        if (this.extensionBinders == null) {
            this.extensionBinders = new HashMap(4);
        }
        this.extensionBinders.put(scheme, binder);
    }

    public FunctionLibrary getExtensionBinder(String scheme) {
        if (this.extensionBinders == null) {
            return null;
        }
        return this.extensionBinders.get(scheme);
    }

    @Override
    public SystemFunction bindSaxonExtensionFunction(String localName, int arity) throws XPathException {
        this.checkLicensedFeature(8, "saxon:" + localName + "#" + arity, -1);
        return this.getVendorFunctionSet().makeFunction(localName, arity);
    }

    @Override
    public void addExtensionBinders(FunctionLibraryList list) {
        if (this.getBooleanProperty(Feature.ALLOW_EXTERNAL_FUNCTIONS) && this.extensionBinders != null) {
            for (FunctionLibrary functionLibrary : this.extensionBinders.values()) {
                list.addFunctionLibrary(functionLibrary);
            }
        }
    }

    @Override
    public FunctionItem getSystemFunction(StructuredQName name, int arity) {
        FunctionItem result = super.getSystemFunction(name, arity);
        if (result != null) {
            return result;
        }
        if (this.isLicensedFeature(8)) {
            try {
                if (this.staticContextForSystemFunctions == null) {
                    this.staticContextForSystemFunctions = new IndependentContext(this);
                }
                FunctionLibrary lib = this.getExtensionBinder("java");
                SymbolicName.F symbolicName = new SymbolicName.F(name, arity);
                return lib.getFunctionItem(symbolicName, this.staticContextForSystemFunctions);
            }
            catch (XPathException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public synchronized UseWhen30FunctionSet getUseWhenFunctionLibrary(int version) {
        return UseWhen40FunctionSet.getInstance(version);
    }

    @Override
    protected synchronized FunctionLibraryList makeBuiltInExtensionLibraryList(int version) {
        FunctionLibraryList result = new FunctionLibraryList();
        result.addFunctionLibrary(this.getVendorFunctionSet());
        result.addFunctionLibrary(MathFunctionSet.getInstance());
        result.addFunctionLibrary(MapFunctionSet.getInstance(version));
        result.addFunctionLibrary(ArrayFunctionSet.getInstance(version));
        result.addFunctionLibrary(EXPathBinaryFunctionSet.getInstance());
        result.addFunctionLibrary(ExsltCommonFunctionSet.getInstance());
        if (this.getBooleanProperty(Feature.ALLOW_EXTERNAL_FUNCTIONS)) {
            result.addFunctionLibrary(EXPathFileFunctionSet.getInstance());
            OnDemandFunctionSet sql = new OnDemandFunctionSet(this, NamespaceUri.SQL, "com.saxonica.functions.sql.SQLFunctionSet");
            result.addFunctionLibrary(sql);
        }
        return result;
    }

    @Override
    public BuiltInFunctionSet getVendorFunctionSet() {
        if (this.isLicensedFeature(8)) {
            return VendorFunctionSetPE.getInstance();
        }
        return super.getVendorFunctionSet();
    }

    public void declareBuiltInExtensionFunctions() {
    }

    public void declareBuiltInExtensionElementNamespaces() {
        try {
            this.setExtensionElementCreator(NamespaceUri.SAXON, SaxonElementFactory.FACTORY);
            this.setExtensionElementCreator(NamespaceUri.SAXON6, localName -> {
                if (localName.equals("output")) {
                    return new XSLResultDocument();
                }
                return null;
            });
        }
        catch (XPathException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public void setExtensionElementNamespace(String namespace, ExtensionElementFactory factory) throws XPathException {
        this.setExtensionElementCreator(NamespaceUri.of(namespace), localName -> {
            try {
                return factory.getExtensionClass(localName).newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void setExtensionElementNamespace(String namespace, String className) throws XPathException {
        Object o = this.getDynamicLoader().getInstance(className, null);
        if (!(o instanceof ExtensionElementFactory)) {
            throw new XPathException("Class " + className + " does not implement ExtensionElementFactory");
        }
        this.setExtensionElementNamespace(namespace, (ExtensionElementFactory)o);
    }

    public void setExtensionElementCreator(NamespaceUri namespace, ExtensionElementCreator creator) throws XPathException {
        if (NamespaceUri.isReserved(namespace)) {
            throw new XPathException("Namespace " + namespace + " is reserved: it cannot be used for extension instructions");
        }
        if (this.xsltExtensionElementNamespaceMap == null) {
            this.xsltExtensionElementNamespaceMap = new HashMap(4);
        }
        this.xsltExtensionElementNamespaceMap.put(namespace, creator);
    }

    public ExtensionElementCreator getExtensionElementCreator(NamespaceUri namespace) {
        if (this.xsltExtensionElementNamespaceMap == null) {
            return null;
        }
        return this.xsltExtensionElementNamespaceMap.get(namespace);
    }

    @Override
    public boolean isExtensionElementAvailable(StructuredQName qName) {
        ExtensionElementCreator eef = this.getExtensionElementCreator(qName.getNamespaceUri());
        return eef != null && eef.createExtensionElement(qName.getLocalPart()) != null;
    }

    @Override
    public Map<String, FunctionItem> makeMethodMap(Class<?> javaClass, String required) {
        return ObjectMap.makeMethodMap(this, javaClass, required);
    }

    @Override
    public MapItem externalObjectAsMap(ObjectValue<?> value, String required) {
        return ObjectMap.toMap(this, value, required);
    }

    @Override
    public Expression makeObjectLookupExpression(Expression lhs, Expression rhs) {
        return new ObjectLookupExpression(lhs, rhs);
    }

    @Override
    public ActiveSource resolveSource(Source source, Configuration config) throws XPathException {
        ActiveSource s = super.resolveSource(source, config);
        if (s != null) {
            return s;
        }
        if (source instanceof PullProvider) {
            this.checkLicensedFeature(8, "pull processing", -1);
            return new PullSource((PullProvider)((Object)source));
        }
        return null;
    }

    @Override
    public SimpleMode makeMode(StructuredQName modeName, CompilerInfo compilerInfo) {
        return new ModePE(modeName);
    }
}

