/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.local;

import net.sf.saxon.expr.number.AbstractNumberer;

public class Numberer_it
extends AbstractNumberer {
    private static final long serialVersionUID = 1L;
    private static final String[] italianOrdinalUnits = new String[]{"", "primo", "secondo", "terzo", "quarto", "quinto", "sesto", "settimo", "ottavo", "nono", "decimo", "undicesimo ", "dodicesimo", "tredicesimo", "quattordicesimo", "quindiczesimo", "sedicesimo", "diciassettesimo", "diciottesimo", "novantesimo"};
    private static final String[] italianOrdinalTens = new String[]{"", "decimo", "ventesimo", "trentesimo", "quarantesimo", "cinquantesimo", "sessantesimo", "settantesimo", "ottantesimo", "novantesimo"};
    private static final String[] italianUnits = new String[]{"", "uno", "due", "tre", "quattro", "cinque", "sei", "sette", "otto", "nove", "dieci", "undici", "dodici", "tredici", "quattordici", "quindici", "sedici", "diciassette", "diciotto", "diciannove"};
    private static final String[] italianTens = new String[]{"", "dieci", "venti", "trenta", "quaranta", "cinquanta", "sessanta", "settanta", "ottanta", "novanta"};
    private static final String[] italianMonths = new String[]{"gennaio", "febbraio", "marzo", "aprile", "maggio", "giugno", "luglio", "agosto", "settembre", "ottobre", "novembre", "dicembre"};
    private static final String[] italianMonthAbbreviations = new String[]{"gen", "feb", "mar", "apr", "mag", "giu", "lug", "ago", "set", "ott", "nov", "dic"};
    private static final String[] italianDays = new String[]{"luned\u00ec", "marted\u00ec ", "mercoled\u00ec", "gioved\u00ec", "venerd\u00ec", "sabato", "domenica"};
    private static final String[] italianDayAbbreviations = new String[]{"lun", "mar", "mer", "gio", "ven", "sab", "dom"};
    private static final int[] minUniqueDayLength = new int[]{1, 2, 2, 1, 1, 1, 1};

    @Override
    public String toOrdinalWords(String ordinalParam, long number, int wordCase) {
        String s;
        if (number == 0L && !"notNull".equalsIgnoreCase(ordinalParam)) {
            return "";
        }
        ordinalParam = "notNull";
        if (number >= 1000000000L) {
            long rem = number % 1000000000L;
            long num = number / 1000000000L;
            s = (num == 1L ? "un" : this.toWords("", num)) + (rem == 0L ? " miliardesimo" : (num == 1L ? " miliardo " : " miliardi ") + this.toOrdinalWords(ordinalParam, rem, wordCase));
        } else if (number >= 1000000L) {
            long rem = number % 1000000L;
            long num = number / 1000000L;
            s = (num == 1L ? "un" : this.toWords("", num)) + (rem == 0L ? " milionesimo" : (num == 1L ? " milione " : " milioni ") + this.toOrdinalWords(ordinalParam, rem, wordCase));
        } else if (number >= 1000L) {
            if (number == 100000L) {
                s = "centomillesimo";
            } else if (number == 10000L) {
                s = "diecimillesimo";
            } else {
                long rem = number % 1000L;
                long num = number / 1000L;
                s = (num == 1L ? "" : this.toWords("", num)) + (rem == 0L ? "millesimo" : (num == 1L ? "mille" : "mila") + this.toOrdinalWords(ordinalParam, rem, wordCase));
            }
        } else if (number >= 100L) {
            int rem = (int)number % 100;
            int num = (int)number / 100;
            s = number == 100L ? "centesimo" : (rem == 0 && num != 1 ? this.toWords("", num) + "centesimo" : (num == 1 ? "" : this.toWords("", num)) + "cento" + this.toOrdinalWords(ordinalParam, rem, wordCase));
        } else if (number < 20L) {
            s = italianOrdinalUnits[(int)number];
        } else {
            int rem = (int)(number % 10L);
            if (rem == 0) {
                s = italianOrdinalTens[(int)number / 10];
            } else {
                s = italianTens[(int)number / 10];
                switch (rem) {
                    case 1: {
                        s = s.substring(0, s.length() - 1) + "unesimo";
                        break;
                    }
                    case 3: 
                    case 6: {
                        s = s + italianUnits[rem] + "esimo";
                        break;
                    }
                    default: {
                        s = s + italianUnits[rem].substring(0, italianUnits[rem].length() - 1) + "esimo";
                    }
                }
            }
        }
        s = s.toLowerCase();
        s = s.replace("centoun", "centun");
        if (wordCase == 0) {
            s = s.toUpperCase();
        }
        return s;
    }

    @Override
    public String toWords(String cardinal, long number) {
        if (number >= 1000000000L) {
            long rem = number % 1000000000L;
            long num = number / 1000000000L;
            return (num == 1L ? "un miliardo" : this.toWords(cardinal, num) + " miliardi") + (rem == 0L ? "" : " ") + this.toWords(cardinal, rem);
        }
        if (number >= 1000000L) {
            long rem = number % 1000000L;
            long num = number / 1000000L;
            return (num == 1L ? "un milione" : this.toWords(cardinal, num) + " milioni") + (rem == 0L ? "" : " ") + this.toWords(cardinal, rem);
        }
        if (number >= 1000L) {
            long rem = number % 1000L;
            long num = number / 1000L;
            return (num == 1L ? "mille" : this.toWords(cardinal, num) + "mila") + this.toWords(cardinal, rem);
        }
        if (number >= 100L) {
            long rem = number % 100L;
            return (number / 100L == 1L ? "" : this.toWords(cardinal, number / 100L)) + "cento" + this.toWords(cardinal, rem);
        }
        if (number < 20L) {
            return italianUnits[(int)number];
        }
        int rem = (int)(number % 10L);
        String s = italianTens[(int)number / 10];
        switch (rem) {
            case 0: {
                return italianTens[(int)number / 10];
            }
            case 1: 
            case 8: {
                return s.substring(0, s.length() - 1) + italianUnits[rem];
            }
            case 3: {
                return s + "tr\u00e9";
            }
        }
        return s + italianUnits[rem];
    }

    @Override
    public String toWords(String cardinal, long number, int wordCase) {
        String s = number == 0L ? "zero" : this.toWords(cardinal, number);
        if (wordCase == 0) {
            return s.toUpperCase();
        }
        if (wordCase == 1) {
            return s.toLowerCase();
        }
        return s;
    }

    @Override
    public String monthName(int month, int minWidth, int maxWidth) {
        String name = italianMonths[month - 1];
        if (maxWidth < 3) {
            maxWidth = 3;
        }
        if (name.length() > maxWidth && (name = italianMonthAbbreviations[month - 1]).length() > maxWidth) {
            name = name.substring(0, maxWidth);
        }
        while (name.length() < minWidth) {
            name = name + ' ';
        }
        return name;
    }

    @Override
    public String dayName(int day, int minWidth, int maxWidth) {
        String name = italianDays[day - 1];
        if (maxWidth < 2) {
            maxWidth = 2;
        }
        if (name.length() > maxWidth && (name = italianDayAbbreviations[day - 1]).length() > maxWidth) {
            name = name.substring(0, maxWidth);
        }
        while (name.length() < minWidth) {
            name = name + ' ';
        }
        if (minWidth == 1 && maxWidth == 2) {
            name = name.substring(0, minUniqueDayLength[day - 1]);
        }
        return name;
    }
}

