/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.extfn.js;

import com.saxonica.ee.extfn.js.IXSLFunctionSet;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class IXSLRemoveAttribute
extends StyleElement {
    private Expression name;
    private Expression object;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    protected boolean mayContainSequenceConstructor() {
        return false;
    }

    @Override
    protected void prepareAttributes() {
        AttributeMap atts = this.attributes();
        for (AttributeInfo att : atts) {
            NodeName attName = att.getNodeName();
            String f = attName.getDisplayName();
            if (f.equals("name")) {
                String nameAtt = Whitespace.trim(att.getValue());
                this.name = this.makeAttributeValueTemplate(nameAtt, att);
                continue;
            }
            if (f.equals("object")) {
                String objectAtt = att.getValue();
                this.object = this.makeExpression(objectAtt, att);
                continue;
            }
            this.checkUnknownAttribute(attName);
        }
        if (this.object == null) {
            this.object = this.makeExpression(".", null);
        }
        if (this.name == null) {
            this.reportAbsence("name");
        }
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        this.name = this.typeCheck("name", this.name);
        this.object = this.typeCheck("object", this.object);
    }

    @Override
    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        Expression e = IXSLFunctionSet.getInstance().makeFunction("remove-attribute", 2).makeFunctionCall(this.name, this.object);
        e.setRetainedStaticContext(this.makeRetainedStaticContext());
        return e;
    }
}

