/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.watch;

import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.ForEachAction;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.WatchManager;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.TailCallLoop;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.BreakInstr;
import net.sf.saxon.expr.instruct.IterateInstr;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.QuitParsingException;
import net.sf.saxon.trans.XPathException;

public class IterateAction
extends ForEachAction {
    boolean broken = false;
    Terminator terminator;

    public IterateAction(WatchManager watchManager, Expression expression, ItemFeed result, XPathContext context) {
        super(watchManager, expression, result, context);
    }

    @Override
    public void open(Terminator terminator) throws XPathException {
        super.open(terminator);
        this.terminator = terminator;
        XPathContext outerContext = this.getContext();
        ((IterateInstr)this.getExpression()).getInitiallyExp().process(this.getNextOutputter(), outerContext);
        this.makeBodyContext();
    }

    @Override
    public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
        if (this.broken) {
            return null;
        }
        return super.startSelectedParentNode(node, locationId);
    }

    @Override
    public void append(Item it) throws XPathException {
        if (this.broken) {
            return;
        }
        super.append(it);
        this.checkForBreakInstruction();
    }

    @Override
    public void endSelectedParentNode(Location locationId) throws XPathException {
        if (this.broken) {
            return;
        }
        super.endSelectedParentNode(locationId);
        this.checkForBreakInstruction();
    }

    private void checkForBreakInstruction() throws QuitParsingException {
        XPathContextMajor cm = this.getContext().getMajorContext();
        TailCallLoop.TailCallInfo tail = cm.getTailCallInfo();
        if (tail instanceof BreakInstr) {
            this.broken = true;
            if (this.getWatchManager().allowsEarlyExit()) {
                this.terminator.terminate();
            }
        }
    }

    @Override
    public void close() throws XPathException {
        if (!this.broken) {
            Expression onCompletion = ((IterateInstr)this.getExpression()).getOnCompletion();
            SequenceIterator iter = onCompletion.iterate(this.getContext());
            IterateAction.processItems(iter, this.getNextOutputter());
        }
        this.broken = false;
        super.close();
    }
}

