/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.xtupdate;

import com.saxonica.ee.update.RenameExpression;
import com.saxonica.ee.xtupdate.SaxonUpdate;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.ExtensionInstruction;
import net.sf.saxon.trans.XPathException;

public class SaxonRename
extends ExtensionInstruction {
    private Expression select;
    private Expression newName;

    @Override
    protected boolean mayContainSequenceConstructor() {
        return false;
    }

    @Override
    protected void prepareAttributes() {
        String selectAtt = null;
        String toAtt = null;
        for (AttributeInfo att : this.attributes()) {
            NodeName attName = att.getNodeName();
            String f = attName.getDisplayName();
            String value = att.getValue();
            if (f.equals("select")) {
                selectAtt = value;
                this.select = this.makeExpression(selectAtt, att);
                continue;
            }
            if (f.equals("to")) {
                toAtt = value;
                this.newName = this.makeExpression(toAtt, att);
                continue;
            }
            this.checkUnknownAttribute(attName);
        }
        if (selectAtt == null) {
            this.select = new ContextItemExpression();
            this.select.setLocation(this.allocateLocation());
        }
        if (toAtt == null) {
            this.reportAbsence("to");
        }
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        this.getConfiguration().checkLicensedFeature(2, "saxon:rename", this.getPackageData().getLocalLicenseId());
        this.select = this.typeCheck("select", this.select);
        this.newName = this.typeCheck("to", this.newName);
        SaxonUpdate.checkContainment(this);
    }

    @Override
    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        return new RenameExpression(this.select, this.newName, this.getAllNamespaces(), this.getDefaultXPathNamespace(), true);
    }
}

